#ifndef __mac_wavelan1_h__
#define __mac_wavelan1_h__

#include <assert.h>

#define min(x, y)	((x) < (y) ? (x) : (y))
#define HDR_MAC3(p)      ((struct hdr_mac802_3*)(p)->access(off_mac_))

#define IEEE_8023_SLOT		0.000051200	// 512 bit times
#define	IEEE_8023_IFS		0.000009600	// 9.6us
#define IEEE_8023_ALIMIT	16		// attempt limit
#define IEEE_8023_BLIMIT	10		// backoff limit
#define IEEE_8023_JAMSIZE	32		// bits
// #define IEEE_8023_JAMTIME	(IEEE_8023_JAMSIZE/(1e7))
#define IEEE_8023_MAXFRAME	1518		// bytes
#define IEEE_8023_MINFRAME	64		// bytes

#define WAVELAN_ANTENNA_SLOT    0.00001600      // 32 bit periods
#define WAVELAN_IFS             0.00001600      // 32 bit periods
#define WAVELAN_ALIMIT          15              // attempt limit
#define WAVELAN_BLIMIT          8               // backoff limit
#define WAVELAN_BMIN            5               // backoff min slot range
#define WAVELAN_XDELAY          31              // extra xmit delay

     /* At the physical layer, WaveLAN pads each packet with the following:
      *        field         symbols     bits     bytes
      *   training pattern     118        236      29.5
      *   start delimiter        4          8       1
      *   carrier training       8         16       2
      *   NWID (see below)      16         16       4
      *   end delimiter          4          8       1
      *                           TOTAL BYTES      37.5
      *
      * In order to pad the packet with an integer number of bytes,
      * the training pattern is rounded to 30 bytes, yielding a 
      * total pad size of 38 bytes.
      *
      * WaveLAN operates at a symbol rate of 1 Mbaud.  Normal modulation 
      * yields 2 bits per symbol, and hence 2 Mbits/s.  However, this 
      * modulation can be varied during the physical layer preamble and
      * postamble.  In this  case, the Network Identifier (NWID) is 
      * modulated at a rate of 1 bit per symbol.  Therefore, it's actually
      * only 16 bits long; however, since we're interested in the network's
      * performance, we treat the NWID as 32 bits (4 bytes)--the equivelent
      * of 16 symbols under normal (2 bits / symbol) modulation conditions
      */

#define WAVELAN_PHYS_PRE        37              // physical layer preamble
#define WAVELAN_PHYS_POST       1               // physical layer postamble

#define WAVELAN_HDR_LEN 	WAVELAN_PHYS_PRE + ETHER_MAC_PREAM_LEN + \
                                ETHER_SFD_LEN + (ETHER_ADDR_LEN << 1) +  \
                                ETHER_TYPE_LEN + ETHER_FCS_LEN +        \
                                WAVELAN_PHYS_POST 

struct hdr_mac802_3 {
	u_char		mh_da[ETHER_ADDR_LEN];
	u_char		mh_sa[ETHER_ADDR_LEN];
	u_int16_t	mh_type;
};


/* ======================================================================
   Handler Functions
   ====================================================================== */
class Mac_WaveLAN1;

class MacHandler : public Handler {
public:
	MacHandler(Mac_WaveLAN1* m) :  callback(0), mac(m), busy_(0) {}
	virtual void handle(Event *e) = 0;
	virtual inline void cancel() {
		assert(0);
#if 0
		Scheduler& s = Scheduler::instance();
		assert(busy_);
		s.cancel(&intr);
		busy_ = 0;
#endif
	}
	inline int busy(void) { return busy_; }
//	inline double expire(void) { return intr.time_; }
	inline Event retintr(void) { return intr; }
protected:
	Handler		*callback;
	Mac_WaveLAN1	*mac;
	Event		intr;
	int		busy_;
};


class MacWL_HandlerDefer : public MacHandler {
public:
	MacWL_HandlerDefer(Mac_WaveLAN1* m) : MacHandler(m) {}
	void handle(Event*);
	void schedule(Handler *h, double t);
};


class MacWL_HandlerSend : public MacHandler {
public:
	MacWL_HandlerSend(Mac_WaveLAN1* m) : MacHandler(m) {}
	void handle(Event*);
	void schedule(double t);
};


class MacWL_HandlerBack : public MacHandler {
public:
	MacWL_HandlerBack(Mac_WaveLAN1* m) : MacHandler(m) {}
	void handle(Event*);
	void schedule(Packet *p, double t);
};


class MacWL_HandlerRecv : public MacHandler {
public:
	MacWL_HandlerRecv(Mac_WaveLAN1* m) : MacHandler(m), p_(0) {}
	void handle(Event*);
	void schedule(Packet *p, double t);
	double expire(void);
	virtual inline void cancel() {
		Scheduler& s = Scheduler::instance();
		assert(busy_ && p_);
		s.cancel(p_);
		busy_ = 0;
	}
private:
	Packet *p_;
	double endTime_;
};


/* ======================================================================
   MAC data structure
   ====================================================================== */
class Mac_WaveLAN1 : public Mac {
	friend class MacWL_HandlerBack;
	friend class MacWL_HandlerRecv;
	friend class MacWL_HandlerSend;
public:
	Mac_WaveLAN1();

	void		recv(Packet* p, Handler* h);
	inline u_int32_t	hdr_dst(void* hdr, u_int32_t dst = 0);
	inline u_int32_t	hdr_src(void* hdr, u_int32_t src = 0);
	inline int	hdr_type(void* hdr, u_int16_t type = 0);
	
	void		recv_complete(Packet *p);
	virtual void	resume();

protected:
	virtual void	send(Packet* p);
private:
	int		command(int argc, const char*const* argv);
	void		send(Packet *p, Handler *h);
	void		discard(Packet *p, const char* why = 0);

	virtual void	backoff(void);
	void		collision(Packet *p);

	int		pktTxcnt;
	int             backoff_;
	int             collision_;

	MacWL_HandlerBack	mhBack;
	MacWL_HandlerDefer	mhDefer;
	MacWL_HandlerRecv	mhRecv;
	MacWL_HandlerSend	mhSend;
};

#endif /* __mac_wavelan1_h__ */
