/* -*- c++ -*-
   god.h

   General Operations Director

   perform operations requiring omnipotence in the simulation
   $Id: god.h,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $
   */

#ifndef __god_h
#define __god_h

#include <stdarg.h>

#include <object.h>
#include <packet.h>
#include <trace.h>
#include <math.h>
#include <random.h>
#include <cmu/node.h>

struct nentry{
    nsaddr_t index;
    struct nentry *next;
};

struct block_t {
  double x1, y1, x2, y2;
  block_t() : x1(0), y1(0), x2(0), y2(0) { }
  block_t(double _x1, double _y1, double _x2, double _y2) : x1(_x1), y1(_y1), x2(_x2), y2(_y2) { }
};

//bellman-ford route entry
struct bf_rt_entry{
    nsaddr_t prev_hop;
    nsaddr_t next_hop;
    int	dist;
};

struct mac_log_entry{
    double tx;
    double rx;
    double backoff;
    double useless_backoff;
    double defering;
    double idle;
    double true_idle;
};
class God;

class GodTimer: public Handler {
public:
    GodTimer(God *g, double t): god_(g),interrupt_time_(t) {};
    void handle(Event *e);

    God *god_;
    double interrupt_time_;
};

class God : public Connector {
public:
        God();

        int             command(int argc, const char* const* argv);

        void            recv(Packet *p, Handler *h);
        void            stampPacket(Packet *p);

	nsaddr_t 	getNodeDstAway(double,double,double);
	nsaddr_t	shortestPathNextHop(nsaddr_t src, nsaddr_t dst);
	int		shortestPathLength(nsaddr_t src, nsaddr_t dst);
	bool		isAwake(nsaddr_t index);
	bool		isNeighbor(nsaddr_t src, nsaddr_t dst);
	void		handleTimer();
	void		start_maclog();

        int initialized() {
                return num_nodes && min_hops && target_;
        }

        int             hops(int i, int j);
        static God*     instance() { assert(instance_); return instance_; }

	MobileNode **nodelist;
	Mac	**maclist;
	struct mac_log_entry *maclog;

#ifdef IDEAL_ROUTE
	bool		getRouteToLoc(nsaddr_t fromnode,location dstloc, nsaddr_t *route, int maxnodes);
	Quadtree        *root;
#endif
	double *wakeup_list;
        int num_nodes;

	GodTimer *god_timer;
	Event god_interrupt_event;
	Topography      *T;

private:
	bf_rt_entry *shortest_path;
        int* min_hops;   // square array of num_nodesXnum_nodes
                         // min_hops[i * num_nodes + j] giving 
			 // minhops between i and j
	double *wakelist;
        static God*     instance_;
	struct nentry **loc_to_nodes;
	double maxx,maxy;
	int len_x,len_y;

  	int lines_intersect(double x1, double y1, double x2, double y2,  
		            double x3, double y3, double x4, double y4,  
		            double *x, double *y);

};

#endif
