#ifndef __channel_h__
#define __channel_h__

class Channel;
#include <packet.h>
#include <cmu/net-if.h>

/* ======================================================================
   Channel

	This class is used to represent the physical media to which
	network interfaces are attached.  As such, the send() function
	simply schedules packet reception at the interfaces.  The recv()
	function should never be called.
   ====================================================================== */

class Channel : public TclObject {

public:
	Channel(void);
	virtual int command(int argc, const char*const* argv);

	void recv(Packet* p, NetIf* txifp);

private:
	void send(Packet* p, NetIf* txifp);
	void dump(void);

	int index;
	struct if_head	ifhead;
};


#endif __channel_h__
