#
# tcl/ex/newmcast/cmcast-150.tcl
#
# Copyright (C) 1997 by USC/ISI
# All rights reserved.                                            
#                                                                
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation, advertising
# materials, and other materials related to such distribution and use
# acknowledge that the software was developed by the University of
# Southern California, Information Sciences Institute.  The name of the
# University may not be used to endorse or promote products derived from
# this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# 
# Contributed by Polly Huang (USC/ISI), http://www-scf.usc.edu/~bhuang
# 
#
# Generated by sgb2nsctr, sgb2nsctr created by Polly Huang
# GRAPH (#nodes #edges id uu vv ww xx yy zz):
# 150 4372 geo(0,{150,100,3,0.200,0.250,75.000}) 100 

set verbose 1
set ns [new Simulator]
Simulator set EnableMcast_ 1
Simulator set NumberInterfaces_ 1
Node expandaddr
set g [Node allocaddr]

if {$verbose} { puts "creating 150 nodes..." }
for {set i 0} {$i < 150} {incr i} {
	set n($i) [$ns node]
}

# EDGES (from-node to-node length a b):
if {$verbose} { puts -nonewline "Creating links 0..."; flush stdout }
$ns duplex-link $n(0) $n(115) 1.5Mb 530ms DropTail
$ns duplex-link $n(0) $n(109) 1.5Mb 210ms DropTail
$ns duplex-link $n(0) $n(97) 1.5Mb 170ms DropTail
$ns duplex-link $n(0) $n(88) 1.5Mb 190ms DropTail
$ns duplex-link $n(0) $n(82) 1.5Mb 350ms DropTail
$ns duplex-link $n(0) $n(75) 1.5Mb 250ms DropTail
$ns duplex-link $n(0) $n(74) 1.5Mb 600ms DropTail
$ns duplex-link $n(0) $n(72) 1.5Mb 180ms DropTail
$ns duplex-link $n(0) $n(70) 1.5Mb 360ms DropTail
$ns duplex-link $n(0) $n(54) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "10..."; flush stdout }
$ns duplex-link $n(0) $n(51) 1.5Mb 640ms DropTail
$ns duplex-link $n(0) $n(49) 1.5Mb 430ms DropTail
$ns duplex-link $n(0) $n(47) 1.5Mb 530ms DropTail
$ns duplex-link $n(0) $n(40) 1.5Mb 200ms DropTail
$ns duplex-link $n(0) $n(34) 1.5Mb 300ms DropTail
$ns duplex-link $n(0) $n(32) 1.5Mb 390ms DropTail
$ns duplex-link $n(0) $n(27) 1.5Mb 440ms DropTail
$ns duplex-link $n(0) $n(19) 1.5Mb 160ms DropTail
$ns duplex-link $n(0) $n(9) 1.5Mb 640ms DropTail
$ns duplex-link $n(0) $n(8) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "20..."; flush stdout }
$ns duplex-link $n(1) $n(145) 1.5Mb 580ms DropTail
$ns duplex-link $n(1) $n(144) 1.5Mb 780ms DropTail
$ns duplex-link $n(1) $n(139) 1.5Mb 700ms DropTail
$ns duplex-link $n(1) $n(137) 1.5Mb 490ms DropTail
$ns duplex-link $n(1) $n(133) 1.5Mb 540ms DropTail
$ns duplex-link $n(1) $n(132) 1.5Mb 520ms DropTail
$ns duplex-link $n(1) $n(130) 1.5Mb 140ms DropTail
$ns duplex-link $n(1) $n(129) 1.5Mb 530ms DropTail
$ns duplex-link $n(1) $n(126) 1.5Mb 670ms DropTail
$ns duplex-link $n(1) $n(121) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "30..."; flush stdout }
$ns duplex-link $n(1) $n(116) 1.5Mb 1210ms DropTail
$ns duplex-link $n(1) $n(109) 1.5Mb 590ms DropTail
$ns duplex-link $n(1) $n(104) 1.5Mb 550ms DropTail
$ns duplex-link $n(1) $n(102) 1.5Mb 610ms DropTail
$ns duplex-link $n(1) $n(93) 1.5Mb 340ms DropTail
$ns duplex-link $n(1) $n(88) 1.5Mb 600ms DropTail
$ns duplex-link $n(1) $n(86) 1.5Mb 720ms DropTail
$ns duplex-link $n(1) $n(84) 1.5Mb 280ms DropTail
$ns duplex-link $n(1) $n(70) 1.5Mb 570ms DropTail
$ns duplex-link $n(1) $n(68) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "40..."; flush stdout }
$ns duplex-link $n(1) $n(54) 1.5Mb 530ms DropTail
$ns duplex-link $n(1) $n(49) 1.5Mb 710ms DropTail
$ns duplex-link $n(1) $n(43) 1.5Mb 890ms DropTail
$ns duplex-link $n(1) $n(32) 1.5Mb 1060ms DropTail
$ns duplex-link $n(1) $n(30) 1.5Mb 50ms DropTail
$ns duplex-link $n(1) $n(26) 1.5Mb 270ms DropTail
$ns duplex-link $n(1) $n(20) 1.5Mb 1200ms DropTail
$ns duplex-link $n(1) $n(18) 1.5Mb 450ms DropTail
$ns duplex-link $n(1) $n(13) 1.5Mb 230ms DropTail
$ns duplex-link $n(1) $n(12) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "50..."; flush stdout }
$ns duplex-link $n(1) $n(5) 1.5Mb 760ms DropTail
$ns duplex-link $n(2) $n(143) 1.5Mb 720ms DropTail
$ns duplex-link $n(2) $n(124) 1.5Mb 950ms DropTail
$ns duplex-link $n(2) $n(120) 1.5Mb 610ms DropTail
$ns duplex-link $n(2) $n(116) 1.5Mb 130ms DropTail
$ns duplex-link $n(2) $n(101) 1.5Mb 160ms DropTail
$ns duplex-link $n(2) $n(97) 1.5Mb 630ms DropTail
$ns duplex-link $n(2) $n(93) 1.5Mb 980ms DropTail
$ns duplex-link $n(2) $n(92) 1.5Mb 780ms DropTail
$ns duplex-link $n(2) $n(79) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "60..."; flush stdout }
$ns duplex-link $n(2) $n(78) 1.5Mb 750ms DropTail
$ns duplex-link $n(2) $n(76) 1.5Mb 690ms DropTail
$ns duplex-link $n(2) $n(68) 1.5Mb 870ms DropTail
$ns duplex-link $n(2) $n(66) 1.5Mb 570ms DropTail
$ns duplex-link $n(2) $n(56) 1.5Mb 580ms DropTail
$ns duplex-link $n(2) $n(53) 1.5Mb 140ms DropTail
$ns duplex-link $n(2) $n(43) 1.5Mb 420ms DropTail
$ns duplex-link $n(2) $n(41) 1.5Mb 820ms DropTail
$ns duplex-link $n(2) $n(40) 1.5Mb 290ms DropTail
$ns duplex-link $n(2) $n(17) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "70..."; flush stdout }
$ns duplex-link $n(2) $n(13) 1.5Mb 850ms DropTail
$ns duplex-link $n(3) $n(149) 1.5Mb 270ms DropTail
$ns duplex-link $n(3) $n(148) 1.5Mb 400ms DropTail
$ns duplex-link $n(3) $n(134) 1.5Mb 970ms DropTail
$ns duplex-link $n(3) $n(130) 1.5Mb 660ms DropTail
$ns duplex-link $n(3) $n(105) 1.5Mb 390ms DropTail
$ns duplex-link $n(3) $n(104) 1.5Mb 460ms DropTail
$ns duplex-link $n(3) $n(101) 1.5Mb 400ms DropTail
$ns duplex-link $n(3) $n(93) 1.5Mb 800ms DropTail
$ns duplex-link $n(3) $n(90) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "80..."; flush stdout }
$ns duplex-link $n(3) $n(88) 1.5Mb 360ms DropTail
$ns duplex-link $n(3) $n(86) 1.5Mb 900ms DropTail
$ns duplex-link $n(3) $n(83) 1.5Mb 680ms DropTail
$ns duplex-link $n(3) $n(82) 1.5Mb 890ms DropTail
$ns duplex-link $n(3) $n(74) 1.5Mb 460ms DropTail
$ns duplex-link $n(3) $n(68) 1.5Mb 790ms DropTail
$ns duplex-link $n(3) $n(67) 1.5Mb 620ms DropTail
$ns duplex-link $n(3) $n(62) 1.5Mb 750ms DropTail
$ns duplex-link $n(3) $n(54) 1.5Mb 240ms DropTail
$ns duplex-link $n(3) $n(42) 1.5Mb 840ms DropTail
if {$verbose} { puts -nonewline "90..."; flush stdout }
$ns duplex-link $n(3) $n(39) 1.5Mb 150ms DropTail
$ns duplex-link $n(3) $n(36) 1.5Mb 360ms DropTail
$ns duplex-link $n(3) $n(32) 1.5Mb 650ms DropTail
$ns duplex-link $n(3) $n(18) 1.5Mb 480ms DropTail
$ns duplex-link $n(3) $n(15) 1.5Mb 140ms DropTail
$ns duplex-link $n(3) $n(6) 1.5Mb 480ms DropTail
$ns duplex-link $n(4) $n(135) 1.5Mb 110ms DropTail
$ns duplex-link $n(4) $n(132) 1.5Mb 230ms DropTail
$ns duplex-link $n(4) $n(130) 1.5Mb 170ms DropTail
$ns duplex-link $n(4) $n(128) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "100..."; flush stdout }
$ns duplex-link $n(4) $n(125) 1.5Mb 210ms DropTail
$ns duplex-link $n(4) $n(108) 1.5Mb 260ms DropTail
$ns duplex-link $n(4) $n(106) 1.5Mb 320ms DropTail
$ns duplex-link $n(4) $n(93) 1.5Mb 270ms DropTail
$ns duplex-link $n(4) $n(83) 1.5Mb 640ms DropTail
$ns duplex-link $n(4) $n(79) 1.5Mb 390ms DropTail
$ns duplex-link $n(4) $n(74) 1.5Mb 250ms DropTail
$ns duplex-link $n(4) $n(73) 1.5Mb 530ms DropTail
$ns duplex-link $n(4) $n(72) 1.5Mb 340ms DropTail
$ns duplex-link $n(4) $n(56) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "110..."; flush stdout }
$ns duplex-link $n(4) $n(51) 1.5Mb 240ms DropTail
$ns duplex-link $n(4) $n(44) 1.5Mb 40ms DropTail
$ns duplex-link $n(4) $n(38) 1.5Mb 530ms DropTail
$ns duplex-link $n(4) $n(33) 1.5Mb 660ms DropTail
$ns duplex-link $n(4) $n(27) 1.5Mb 280ms DropTail
$ns duplex-link $n(4) $n(23) 1.5Mb 730ms DropTail
$ns duplex-link $n(4) $n(16) 1.5Mb 440ms DropTail
$ns duplex-link $n(4) $n(13) 1.5Mb 70ms DropTail
$ns duplex-link $n(4) $n(12) 1.5Mb 360ms DropTail
$ns duplex-link $n(4) $n(6) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "120..."; flush stdout }
$ns duplex-link $n(5) $n(135) 1.5Mb 620ms DropTail
$ns duplex-link $n(5) $n(133) 1.5Mb 390ms DropTail
$ns duplex-link $n(5) $n(132) 1.5Mb 300ms DropTail
$ns duplex-link $n(5) $n(127) 1.5Mb 380ms DropTail
$ns duplex-link $n(5) $n(122) 1.5Mb 140ms DropTail
$ns duplex-link $n(5) $n(121) 1.5Mb 470ms DropTail
$ns duplex-link $n(5) $n(113) 1.5Mb 360ms DropTail
$ns duplex-link $n(5) $n(112) 1.5Mb 260ms DropTail
$ns duplex-link $n(5) $n(101) 1.5Mb 220ms DropTail
$ns duplex-link $n(5) $n(95) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "130..."; flush stdout }
$ns duplex-link $n(5) $n(89) 1.5Mb 190ms DropTail
$ns duplex-link $n(5) $n(86) 1.5Mb 760ms DropTail
$ns duplex-link $n(5) $n(76) 1.5Mb 650ms DropTail
$ns duplex-link $n(5) $n(71) 1.5Mb 430ms DropTail
$ns duplex-link $n(5) $n(57) 1.5Mb 440ms DropTail
$ns duplex-link $n(5) $n(44) 1.5Mb 540ms DropTail
$ns duplex-link $n(5) $n(42) 1.5Mb 820ms DropTail
$ns duplex-link $n(5) $n(41) 1.5Mb 740ms DropTail
$ns duplex-link $n(5) $n(36) 1.5Mb 160ms DropTail
$ns duplex-link $n(5) $n(28) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "140..."; flush stdout }
$ns duplex-link $n(5) $n(27) 1.5Mb 710ms DropTail
$ns duplex-link $n(5) $n(26) 1.5Mb 740ms DropTail
$ns duplex-link $n(5) $n(24) 1.5Mb 60ms DropTail
$ns duplex-link $n(5) $n(19) 1.5Mb 290ms DropTail
$ns duplex-link $n(5) $n(16) 1.5Mb 350ms DropTail
$ns duplex-link $n(5) $n(14) 1.5Mb 750ms DropTail
$ns duplex-link $n(5) $n(11) 1.5Mb 470ms DropTail
$ns duplex-link $n(5) $n(8) 1.5Mb 110ms DropTail
$ns duplex-link $n(5) $n(6) 1.5Mb 430ms DropTail
$ns duplex-link $n(6) $n(147) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "150..."; flush stdout }
$ns duplex-link $n(6) $n(142) 1.5Mb 330ms DropTail
$ns duplex-link $n(6) $n(141) 1.5Mb 280ms DropTail
$ns duplex-link $n(6) $n(136) 1.5Mb 140ms DropTail
$ns duplex-link $n(6) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(6) $n(122) 1.5Mb 430ms DropTail
$ns duplex-link $n(6) $n(111) 1.5Mb 280ms DropTail
$ns duplex-link $n(6) $n(103) 1.5Mb 420ms DropTail
$ns duplex-link $n(6) $n(100) 1.5Mb 540ms DropTail
$ns duplex-link $n(6) $n(99) 1.5Mb 640ms DropTail
$ns duplex-link $n(6) $n(98) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "160..."; flush stdout }
$ns duplex-link $n(6) $n(85) 1.5Mb 40ms DropTail
$ns duplex-link $n(6) $n(77) 1.5Mb 260ms DropTail
$ns duplex-link $n(6) $n(76) 1.5Mb 460ms DropTail
$ns duplex-link $n(6) $n(75) 1.5Mb 490ms DropTail
$ns duplex-link $n(6) $n(74) 1.5Mb 300ms DropTail
$ns duplex-link $n(6) $n(70) 1.5Mb 360ms DropTail
$ns duplex-link $n(6) $n(69) 1.5Mb 160ms DropTail
$ns duplex-link $n(6) $n(67) 1.5Mb 220ms DropTail
$ns duplex-link $n(6) $n(57) 1.5Mb 610ms DropTail
$ns duplex-link $n(6) $n(49) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "170..."; flush stdout }
$ns duplex-link $n(6) $n(45) 1.5Mb 220ms DropTail
$ns duplex-link $n(6) $n(43) 1.5Mb 510ms DropTail
$ns duplex-link $n(6) $n(42) 1.5Mb 400ms DropTail
$ns duplex-link $n(6) $n(41) 1.5Mb 470ms DropTail
$ns duplex-link $n(6) $n(38) 1.5Mb 470ms DropTail
$ns duplex-link $n(6) $n(36) 1.5Mb 500ms DropTail
$ns duplex-link $n(6) $n(29) 1.5Mb 320ms DropTail
$ns duplex-link $n(6) $n(27) 1.5Mb 300ms DropTail
$ns duplex-link $n(6) $n(26) 1.5Mb 310ms DropTail
$ns duplex-link $n(6) $n(21) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "180..."; flush stdout }
$ns duplex-link $n(6) $n(17) 1.5Mb 360ms DropTail
$ns duplex-link $n(6) $n(15) 1.5Mb 620ms DropTail
$ns duplex-link $n(6) $n(13) 1.5Mb 160ms DropTail
$ns duplex-link $n(6) $n(11) 1.5Mb 290ms DropTail
$ns duplex-link $n(7) $n(143) 1.5Mb 660ms DropTail
$ns duplex-link $n(7) $n(140) 1.5Mb 710ms DropTail
$ns duplex-link $n(7) $n(136) 1.5Mb 40ms DropTail
$ns duplex-link $n(7) $n(132) 1.5Mb 290ms DropTail
$ns duplex-link $n(7) $n(129) 1.5Mb 300ms DropTail
$ns duplex-link $n(7) $n(121) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "190..."; flush stdout }
$ns duplex-link $n(7) $n(107) 1.5Mb 450ms DropTail
$ns duplex-link $n(7) $n(81) 1.5Mb 280ms DropTail
$ns duplex-link $n(7) $n(75) 1.5Mb 640ms DropTail
$ns duplex-link $n(7) $n(65) 1.5Mb 650ms DropTail
$ns duplex-link $n(7) $n(62) 1.5Mb 260ms DropTail
$ns duplex-link $n(7) $n(33) 1.5Mb 680ms DropTail
$ns duplex-link $n(7) $n(30) 1.5Mb 270ms DropTail
$ns duplex-link $n(7) $n(27) 1.5Mb 340ms DropTail
$ns duplex-link $n(7) $n(24) 1.5Mb 490ms DropTail
$ns duplex-link $n(7) $n(23) 1.5Mb 800ms DropTail
if {$verbose} { puts -nonewline "200..."; flush stdout }
$ns duplex-link $n(7) $n(17) 1.5Mb 220ms DropTail
$ns duplex-link $n(7) $n(16) 1.5Mb 400ms DropTail
$ns duplex-link $n(8) $n(149) 1.5Mb 310ms DropTail
$ns duplex-link $n(8) $n(147) 1.5Mb 120ms DropTail
$ns duplex-link $n(8) $n(145) 1.5Mb 730ms DropTail
$ns duplex-link $n(8) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(8) $n(120) 1.5Mb 130ms DropTail
$ns duplex-link $n(8) $n(107) 1.5Mb 130ms DropTail
$ns duplex-link $n(8) $n(104) 1.5Mb 370ms DropTail
$ns duplex-link $n(8) $n(98) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "210..."; flush stdout }
$ns duplex-link $n(8) $n(93) 1.5Mb 740ms DropTail
$ns duplex-link $n(8) $n(90) 1.5Mb 90ms DropTail
$ns duplex-link $n(8) $n(87) 1.5Mb 560ms DropTail
$ns duplex-link $n(8) $n(86) 1.5Mb 800ms DropTail
$ns duplex-link $n(8) $n(80) 1.5Mb 60ms DropTail
$ns duplex-link $n(8) $n(75) 1.5Mb 690ms DropTail
$ns duplex-link $n(8) $n(72) 1.5Mb 560ms DropTail
$ns duplex-link $n(8) $n(69) 1.5Mb 410ms DropTail
$ns duplex-link $n(8) $n(65) 1.5Mb 450ms DropTail
$ns duplex-link $n(8) $n(50) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "220..."; flush stdout }
$ns duplex-link $n(8) $n(44) 1.5Mb 510ms DropTail
$ns duplex-link $n(8) $n(43) 1.5Mb 590ms DropTail
$ns duplex-link $n(8) $n(36) 1.5Mb 270ms DropTail
$ns duplex-link $n(8) $n(30) 1.5Mb 740ms DropTail
$ns duplex-link $n(8) $n(29) 1.5Mb 360ms DropTail
$ns duplex-link $n(8) $n(27) 1.5Mb 710ms DropTail
$ns duplex-link $n(8) $n(22) 1.5Mb 190ms DropTail
$ns duplex-link $n(8) $n(14) 1.5Mb 790ms DropTail
$ns duplex-link $n(8) $n(10) 1.5Mb 220ms DropTail
$ns duplex-link $n(9) $n(142) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "230..."; flush stdout }
$ns duplex-link $n(9) $n(138) 1.5Mb 120ms DropTail
$ns duplex-link $n(9) $n(133) 1.5Mb 90ms DropTail
$ns duplex-link $n(9) $n(132) 1.5Mb 430ms DropTail
$ns duplex-link $n(9) $n(128) 1.5Mb 510ms DropTail
$ns duplex-link $n(9) $n(127) 1.5Mb 120ms DropTail
$ns duplex-link $n(9) $n(126) 1.5Mb 850ms DropTail
$ns duplex-link $n(9) $n(120) 1.5Mb 220ms DropTail
$ns duplex-link $n(9) $n(113) 1.5Mb 790ms DropTail
$ns duplex-link $n(9) $n(112) 1.5Mb 580ms DropTail
$ns duplex-link $n(9) $n(111) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "240..."; flush stdout }
$ns duplex-link $n(9) $n(110) 1.5Mb 260ms DropTail
$ns duplex-link $n(9) $n(109) 1.5Mb 680ms DropTail
$ns duplex-link $n(9) $n(105) 1.5Mb 150ms DropTail
$ns duplex-link $n(9) $n(93) 1.5Mb 660ms DropTail
$ns duplex-link $n(9) $n(92) 1.5Mb 130ms DropTail
$ns duplex-link $n(9) $n(91) 1.5Mb 780ms DropTail
$ns duplex-link $n(9) $n(90) 1.5Mb 300ms DropTail
$ns duplex-link $n(9) $n(89) 1.5Mb 620ms DropTail
$ns duplex-link $n(9) $n(81) 1.5Mb 410ms DropTail
$ns duplex-link $n(9) $n(63) 1.5Mb 940ms DropTail
if {$verbose} { puts -nonewline "250..."; flush stdout }
$ns duplex-link $n(9) $n(55) 1.5Mb 370ms DropTail
$ns duplex-link $n(9) $n(48) 1.5Mb 490ms DropTail
$ns duplex-link $n(9) $n(47) 1.5Mb 200ms DropTail
$ns duplex-link $n(9) $n(39) 1.5Mb 380ms DropTail
$ns duplex-link $n(9) $n(25) 1.5Mb 590ms DropTail
$ns duplex-link $n(9) $n(21) 1.5Mb 430ms DropTail
$ns duplex-link $n(9) $n(19) 1.5Mb 480ms DropTail
$ns duplex-link $n(9) $n(18) 1.5Mb 450ms DropTail
$ns duplex-link $n(9) $n(17) 1.5Mb 210ms DropTail
$ns duplex-link $n(9) $n(14) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "260..."; flush stdout }
$ns duplex-link $n(10) $n(135) 1.5Mb 800ms DropTail
$ns duplex-link $n(10) $n(132) 1.5Mb 530ms DropTail
$ns duplex-link $n(10) $n(131) 1.5Mb 780ms DropTail
$ns duplex-link $n(10) $n(118) 1.5Mb 590ms DropTail
$ns duplex-link $n(10) $n(117) 1.5Mb 370ms DropTail
$ns duplex-link $n(10) $n(116) 1.5Mb 530ms DropTail
$ns duplex-link $n(10) $n(112) 1.5Mb 510ms DropTail
$ns duplex-link $n(10) $n(104) 1.5Mb 580ms DropTail
$ns duplex-link $n(10) $n(96) 1.5Mb 500ms DropTail
$ns duplex-link $n(10) $n(92) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "270..."; flush stdout }
$ns duplex-link $n(10) $n(91) 1.5Mb 670ms DropTail
$ns duplex-link $n(10) $n(87) 1.5Mb 780ms DropTail
$ns duplex-link $n(10) $n(83) 1.5Mb 710ms DropTail
$ns duplex-link $n(10) $n(80) 1.5Mb 280ms DropTail
$ns duplex-link $n(10) $n(79) 1.5Mb 480ms DropTail
$ns duplex-link $n(10) $n(76) 1.5Mb 900ms DropTail
$ns duplex-link $n(10) $n(75) 1.5Mb 870ms DropTail
$ns duplex-link $n(10) $n(73) 1.5Mb 600ms DropTail
$ns duplex-link $n(10) $n(64) 1.5Mb 110ms DropTail
$ns duplex-link $n(10) $n(58) 1.5Mb 880ms DropTail
if {$verbose} { puts -nonewline "280..."; flush stdout }
$ns duplex-link $n(10) $n(51) 1.5Mb 810ms DropTail
$ns duplex-link $n(10) $n(47) 1.5Mb 300ms DropTail
$ns duplex-link $n(10) $n(43) 1.5Mb 730ms DropTail
$ns duplex-link $n(10) $n(40) 1.5Mb 460ms DropTail
$ns duplex-link $n(10) $n(37) 1.5Mb 860ms DropTail
$ns duplex-link $n(10) $n(29) 1.5Mb 520ms DropTail
$ns duplex-link $n(10) $n(25) 1.5Mb 460ms DropTail
$ns duplex-link $n(10) $n(23) 1.5Mb 710ms DropTail
$ns duplex-link $n(10) $n(18) 1.5Mb 620ms DropTail
$ns duplex-link $n(10) $n(17) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "290..."; flush stdout }
$ns duplex-link $n(10) $n(12) 1.5Mb 380ms DropTail
$ns duplex-link $n(10) $n(11) 1.5Mb 570ms DropTail
$ns duplex-link $n(11) $n(149) 1.5Mb 170ms DropTail
$ns duplex-link $n(11) $n(145) 1.5Mb 650ms DropTail
$ns duplex-link $n(11) $n(137) 1.5Mb 160ms DropTail
$ns duplex-link $n(11) $n(136) 1.5Mb 190ms DropTail
$ns duplex-link $n(11) $n(135) 1.5Mb 320ms DropTail
$ns duplex-link $n(11) $n(129) 1.5Mb 380ms DropTail
$ns duplex-link $n(11) $n(123) 1.5Mb 460ms DropTail
$ns duplex-link $n(11) $n(122) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "300..."; flush stdout }
$ns duplex-link $n(11) $n(119) 1.5Mb 430ms DropTail
$ns duplex-link $n(11) $n(118) 1.5Mb 80ms DropTail
$ns duplex-link $n(11) $n(116) 1.5Mb 940ms DropTail
$ns duplex-link $n(11) $n(113) 1.5Mb 770ms DropTail
$ns duplex-link $n(11) $n(75) 1.5Mb 770ms DropTail
$ns duplex-link $n(11) $n(58) 1.5Mb 430ms DropTail
$ns duplex-link $n(11) $n(55) 1.5Mb 230ms DropTail
$ns duplex-link $n(11) $n(54) 1.5Mb 250ms DropTail
$ns duplex-link $n(11) $n(53) 1.5Mb 910ms DropTail
$ns duplex-link $n(11) $n(47) 1.5Mb 270ms DropTail
if {$verbose} { puts -nonewline "310..."; flush stdout }
$ns duplex-link $n(11) $n(45) 1.5Mb 300ms DropTail
$ns duplex-link $n(11) $n(42) 1.5Mb 490ms DropTail
$ns duplex-link $n(11) $n(41) 1.5Mb 750ms DropTail
$ns duplex-link $n(11) $n(40) 1.5Mb 590ms DropTail
$ns duplex-link $n(11) $n(35) 1.5Mb 850ms DropTail
$ns duplex-link $n(11) $n(34) 1.5Mb 780ms DropTail
$ns duplex-link $n(11) $n(32) 1.5Mb 860ms DropTail
$ns duplex-link $n(11) $n(30) 1.5Mb 380ms DropTail
$ns duplex-link $n(11) $n(22) 1.5Mb 250ms DropTail
$ns duplex-link $n(11) $n(17) 1.5Mb 120ms DropTail
if {$verbose} { puts -nonewline "320..."; flush stdout }
$ns duplex-link $n(11) $n(15) 1.5Mb 510ms DropTail
$ns duplex-link $n(11) $n(13) 1.5Mb 220ms DropTail
$ns duplex-link $n(12) $n(149) 1.5Mb 380ms DropTail
$ns duplex-link $n(12) $n(141) 1.5Mb 520ms DropTail
$ns duplex-link $n(12) $n(116) 1.5Mb 590ms DropTail
$ns duplex-link $n(12) $n(114) 1.5Mb 640ms DropTail
$ns duplex-link $n(12) $n(112) 1.5Mb 190ms DropTail
$ns duplex-link $n(12) $n(102) 1.5Mb 140ms DropTail
$ns duplex-link $n(12) $n(99) 1.5Mb 490ms DropTail
$ns duplex-link $n(12) $n(98) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "330..."; flush stdout }
$ns duplex-link $n(12) $n(96) 1.5Mb 120ms DropTail
$ns duplex-link $n(12) $n(82) 1.5Mb 620ms DropTail
$ns duplex-link $n(12) $n(80) 1.5Mb 110ms DropTail
$ns duplex-link $n(12) $n(78) 1.5Mb 660ms DropTail
$ns duplex-link $n(12) $n(76) 1.5Mb 540ms DropTail
$ns duplex-link $n(12) $n(71) 1.5Mb 330ms DropTail
$ns duplex-link $n(12) $n(69) 1.5Mb 240ms DropTail
$ns duplex-link $n(12) $n(68) 1.5Mb 540ms DropTail
$ns duplex-link $n(12) $n(67) 1.5Mb 470ms DropTail
$ns duplex-link $n(12) $n(56) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "340..."; flush stdout }
$ns duplex-link $n(12) $n(54) 1.5Mb 130ms DropTail
$ns duplex-link $n(12) $n(45) 1.5Mb 480ms DropTail
$ns duplex-link $n(12) $n(33) 1.5Mb 310ms DropTail
$ns duplex-link $n(12) $n(30) 1.5Mb 660ms DropTail
$ns duplex-link $n(12) $n(26) 1.5Mb 580ms DropTail
$ns duplex-link $n(12) $n(24) 1.5Mb 140ms DropTail
$ns duplex-link $n(12) $n(23) 1.5Mb 500ms DropTail
$ns duplex-link $n(12) $n(20) 1.5Mb 580ms DropTail
$ns duplex-link $n(12) $n(18) 1.5Mb 250ms DropTail
$ns duplex-link $n(12) $n(16) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "350..."; flush stdout }
$ns duplex-link $n(12) $n(14) 1.5Mb 620ms DropTail
$ns duplex-link $n(12) $n(13) 1.5Mb 400ms DropTail
$ns duplex-link $n(13) $n(149) 1.5Mb 390ms DropTail
$ns duplex-link $n(13) $n(144) 1.5Mb 630ms DropTail
$ns duplex-link $n(13) $n(139) 1.5Mb 490ms DropTail
$ns duplex-link $n(13) $n(136) 1.5Mb 50ms DropTail
$ns duplex-link $n(13) $n(133) 1.5Mb 420ms DropTail
$ns duplex-link $n(13) $n(130) 1.5Mb 130ms DropTail
$ns duplex-link $n(13) $n(129) 1.5Mb 300ms DropTail
$ns duplex-link $n(13) $n(126) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "360..."; flush stdout }
$ns duplex-link $n(13) $n(125) 1.5Mb 220ms DropTail
$ns duplex-link $n(13) $n(116) 1.5Mb 980ms DropTail
$ns duplex-link $n(13) $n(111) 1.5Mb 150ms DropTail
$ns duplex-link $n(13) $n(93) 1.5Mb 290ms DropTail
$ns duplex-link $n(13) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(13) $n(86) 1.5Mb 570ms DropTail
$ns duplex-link $n(13) $n(84) 1.5Mb 250ms DropTail
$ns duplex-link $n(13) $n(80) 1.5Mb 450ms DropTail
$ns duplex-link $n(13) $n(78) 1.5Mb 710ms DropTail
$ns duplex-link $n(13) $n(70) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "370..."; flush stdout }
$ns duplex-link $n(13) $n(63) 1.5Mb 650ms DropTail
$ns duplex-link $n(13) $n(59) 1.5Mb 490ms DropTail
$ns duplex-link $n(13) $n(58) 1.5Mb 210ms DropTail
$ns duplex-link $n(13) $n(53) 1.5Mb 900ms DropTail
$ns duplex-link $n(13) $n(52) 1.5Mb 510ms DropTail
$ns duplex-link $n(13) $n(49) 1.5Mb 510ms DropTail
$ns duplex-link $n(13) $n(41) 1.5Mb 560ms DropTail
$ns duplex-link $n(13) $n(37) 1.5Mb 720ms DropTail
$ns duplex-link $n(13) $n(36) 1.5Mb 640ms DropTail
$ns duplex-link $n(14) $n(136) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "380..."; flush stdout }
$ns duplex-link $n(14) $n(135) 1.5Mb 480ms DropTail
$ns duplex-link $n(14) $n(129) 1.5Mb 450ms DropTail
$ns duplex-link $n(14) $n(121) 1.5Mb 430ms DropTail
$ns duplex-link $n(14) $n(118) 1.5Mb 660ms DropTail
$ns duplex-link $n(14) $n(110) 1.5Mb 640ms DropTail
$ns duplex-link $n(14) $n(102) 1.5Mb 480ms DropTail
$ns duplex-link $n(14) $n(101) 1.5Mb 780ms DropTail
$ns duplex-link $n(14) $n(99) 1.5Mb 610ms DropTail
$ns duplex-link $n(14) $n(97) 1.5Mb 310ms DropTail
$ns duplex-link $n(14) $n(96) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "390..."; flush stdout }
$ns duplex-link $n(14) $n(77) 1.5Mb 270ms DropTail
$ns duplex-link $n(14) $n(66) 1.5Mb 500ms DropTail
$ns duplex-link $n(14) $n(60) 1.5Mb 630ms DropTail
$ns duplex-link $n(14) $n(53) 1.5Mb 790ms DropTail
$ns duplex-link $n(14) $n(51) 1.5Mb 670ms DropTail
$ns duplex-link $n(14) $n(37) 1.5Mb 370ms DropTail
$ns duplex-link $n(14) $n(36) 1.5Mb 720ms DropTail
$ns duplex-link $n(14) $n(34) 1.5Mb 180ms DropTail
$ns duplex-link $n(14) $n(31) 1.5Mb 760ms DropTail
$ns duplex-link $n(14) $n(28) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "400..."; flush stdout }
$ns duplex-link $n(14) $n(26) 1.5Mb 430ms DropTail
$ns duplex-link $n(14) $n(22) 1.5Mb 650ms DropTail
$ns duplex-link $n(14) $n(18) 1.5Mb 430ms DropTail
$ns duplex-link $n(14) $n(16) 1.5Mb 870ms DropTail
$ns duplex-link $n(14) $n(15) 1.5Mb 1020ms DropTail
$ns duplex-link $n(15) $n(145) 1.5Mb 960ms DropTail
$ns duplex-link $n(15) $n(143) 1.5Mb 1000ms DropTail
$ns duplex-link $n(15) $n(131) 1.5Mb 850ms DropTail
$ns duplex-link $n(15) $n(129) 1.5Mb 580ms DropTail
$ns duplex-link $n(15) $n(113) 1.5Mb 630ms DropTail
if {$verbose} { puts -nonewline "410..."; flush stdout }
$ns duplex-link $n(15) $n(112) 1.5Mb 560ms DropTail
$ns duplex-link $n(15) $n(111) 1.5Mb 630ms DropTail
$ns duplex-link $n(15) $n(104) 1.5Mb 590ms DropTail
$ns duplex-link $n(15) $n(102) 1.5Mb 540ms DropTail
$ns duplex-link $n(15) $n(97) 1.5Mb 710ms DropTail
$ns duplex-link $n(15) $n(96) 1.5Mb 510ms DropTail
$ns duplex-link $n(15) $n(94) 1.5Mb 490ms DropTail
$ns duplex-link $n(15) $n(93) 1.5Mb 940ms DropTail
$ns duplex-link $n(15) $n(84) 1.5Mb 910ms DropTail
$ns duplex-link $n(15) $n(83) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "420..."; flush stdout }
$ns duplex-link $n(15) $n(80) 1.5Mb 290ms DropTail
$ns duplex-link $n(15) $n(64) 1.5Mb 180ms DropTail
$ns duplex-link $n(15) $n(61) 1.5Mb 820ms DropTail
$ns duplex-link $n(15) $n(60) 1.5Mb 500ms DropTail
$ns duplex-link $n(15) $n(59) 1.5Mb 370ms DropTail
$ns duplex-link $n(15) $n(46) 1.5Mb 620ms DropTail
$ns duplex-link $n(15) $n(44) 1.5Mb 700ms DropTail
$ns duplex-link $n(15) $n(43) 1.5Mb 790ms DropTail
$ns duplex-link $n(15) $n(40) 1.5Mb 520ms DropTail
$ns duplex-link $n(15) $n(37) 1.5Mb 920ms DropTail
if {$verbose} { puts -nonewline "430..."; flush stdout }
$ns duplex-link $n(15) $n(36) 1.5Mb 430ms DropTail
$ns duplex-link $n(15) $n(35) 1.5Mb 900ms DropTail
$ns duplex-link $n(15) $n(30) 1.5Mb 890ms DropTail
$ns duplex-link $n(15) $n(21) 1.5Mb 800ms DropTail
$ns duplex-link $n(15) $n(20) 1.5Mb 640ms DropTail
$ns duplex-link $n(15) $n(16) 1.5Mb 290ms DropTail
$ns duplex-link $n(16) $n(148) 1.5Mb 360ms DropTail
$ns duplex-link $n(16) $n(143) 1.5Mb 910ms DropTail
$ns duplex-link $n(16) $n(134) 1.5Mb 980ms DropTail
$ns duplex-link $n(16) $n(131) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "440..."; flush stdout }
$ns duplex-link $n(16) $n(130) 1.5Mb 530ms DropTail
$ns duplex-link $n(16) $n(127) 1.5Mb 150ms DropTail
$ns duplex-link $n(16) $n(126) 1.5Mb 850ms DropTail
$ns duplex-link $n(16) $n(118) 1.5Mb 280ms DropTail
$ns duplex-link $n(16) $n(117) 1.5Mb 460ms DropTail
$ns duplex-link $n(16) $n(116) 1.5Mb 810ms DropTail
$ns duplex-link $n(16) $n(115) 1.5Mb 340ms DropTail
$ns duplex-link $n(16) $n(106) 1.5Mb 610ms DropTail
$ns duplex-link $n(16) $n(105) 1.5Mb 220ms DropTail
$ns duplex-link $n(16) $n(102) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "450..."; flush stdout }
$ns duplex-link $n(16) $n(99) 1.5Mb 820ms DropTail
$ns duplex-link $n(16) $n(92) 1.5Mb 80ms DropTail
$ns duplex-link $n(16) $n(84) 1.5Mb 670ms DropTail
$ns duplex-link $n(16) $n(73) 1.5Mb 650ms DropTail
$ns duplex-link $n(16) $n(71) 1.5Mb 640ms DropTail
$ns duplex-link $n(16) $n(64) 1.5Mb 370ms DropTail
$ns duplex-link $n(16) $n(59) 1.5Mb 370ms DropTail
$ns duplex-link $n(16) $n(57) 1.5Mb 770ms DropTail
$ns duplex-link $n(16) $n(52) 1.5Mb 780ms DropTail
$ns duplex-link $n(16) $n(47) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "460..."; flush stdout }
$ns duplex-link $n(16) $n(46) 1.5Mb 680ms DropTail
$ns duplex-link $n(16) $n(40) 1.5Mb 540ms DropTail
$ns duplex-link $n(16) $n(37) 1.5Mb 880ms DropTail
$ns duplex-link $n(16) $n(31) 1.5Mb 650ms DropTail
$ns duplex-link $n(16) $n(22) 1.5Mb 240ms DropTail
$ns duplex-link $n(16) $n(19) 1.5Mb 440ms DropTail
$ns duplex-link $n(17) $n(130) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(129) 1.5Mb 470ms DropTail
$ns duplex-link $n(17) $n(128) 1.5Mb 670ms DropTail
$ns duplex-link $n(17) $n(123) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "470..."; flush stdout }
$ns duplex-link $n(17) $n(119) 1.5Mb 500ms DropTail
$ns duplex-link $n(17) $n(118) 1.5Mb 160ms DropTail
$ns duplex-link $n(17) $n(116) 1.5Mb 1060ms DropTail
$ns duplex-link $n(17) $n(113) 1.5Mb 880ms DropTail
$ns duplex-link $n(17) $n(111) 1.5Mb 90ms DropTail
$ns duplex-link $n(17) $n(107) 1.5Mb 530ms DropTail
$ns duplex-link $n(17) $n(102) 1.5Mb 530ms DropTail
$ns duplex-link $n(17) $n(101) 1.5Mb 800ms DropTail
$ns duplex-link $n(17) $n(97) 1.5Mb 550ms DropTail
$ns duplex-link $n(17) $n(96) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "480..."; flush stdout }
$ns duplex-link $n(17) $n(95) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(89) 1.5Mb 770ms DropTail
$ns duplex-link $n(17) $n(86) 1.5Mb 820ms DropTail
$ns duplex-link $n(17) $n(85) 1.5Mb 360ms DropTail
$ns duplex-link $n(17) $n(71) 1.5Mb 680ms DropTail
$ns duplex-link $n(17) $n(64) 1.5Mb 660ms DropTail
$ns duplex-link $n(17) $n(62) 1.5Mb 460ms DropTail
$ns duplex-link $n(17) $n(55) 1.5Mb 290ms DropTail
$ns duplex-link $n(17) $n(53) 1.5Mb 1030ms DropTail
$ns duplex-link $n(17) $n(52) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "490..."; flush stdout }
$ns duplex-link $n(17) $n(51) 1.5Mb 190ms DropTail
$ns duplex-link $n(17) $n(50) 1.5Mb 320ms DropTail
$ns duplex-link $n(17) $n(40) 1.5Mb 700ms DropTail
$ns duplex-link $n(17) $n(33) 1.5Mb 720ms DropTail
$ns duplex-link $n(17) $n(29) 1.5Mb 150ms DropTail
$ns duplex-link $n(17) $n(28) 1.5Mb 970ms DropTail
$ns duplex-link $n(17) $n(21) 1.5Mb 240ms DropTail
$ns duplex-link $n(17) $n(20) 1.5Mb 1060ms DropTail
$ns duplex-link $n(17) $n(19) 1.5Mb 510ms DropTail
$ns duplex-link $n(18) $n(143) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "500..."; flush stdout }
$ns duplex-link $n(18) $n(141) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(139) 1.5Mb 350ms DropTail
$ns duplex-link $n(18) $n(138) 1.5Mb 380ms DropTail
$ns duplex-link $n(18) $n(122) 1.5Mb 380ms DropTail
$ns duplex-link $n(18) $n(118) 1.5Mb 260ms DropTail
$ns duplex-link $n(18) $n(103) 1.5Mb 470ms DropTail
$ns duplex-link $n(18) $n(102) 1.5Mb 170ms DropTail
$ns duplex-link $n(18) $n(96) 1.5Mb 120ms DropTail
$ns duplex-link $n(18) $n(94) 1.5Mb 140ms DropTail
$ns duplex-link $n(18) $n(90) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "510..."; flush stdout }
$ns duplex-link $n(18) $n(87) 1.5Mb 170ms DropTail
$ns duplex-link $n(18) $n(86) 1.5Mb 450ms DropTail
$ns duplex-link $n(18) $n(81) 1.5Mb 100ms DropTail
$ns duplex-link $n(18) $n(73) 1.5Mb 380ms DropTail
$ns duplex-link $n(18) $n(70) 1.5Mb 340ms DropTail
$ns duplex-link $n(18) $n(58) 1.5Mb 280ms DropTail
$ns duplex-link $n(18) $n(50) 1.5Mb 390ms DropTail
$ns duplex-link $n(18) $n(47) 1.5Mb 410ms DropTail
$ns duplex-link $n(18) $n(44) 1.5Mb 180ms DropTail
$ns duplex-link $n(18) $n(39) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "520..."; flush stdout }
$ns duplex-link $n(18) $n(27) 1.5Mb 310ms DropTail
$ns duplex-link $n(18) $n(20) 1.5Mb 770ms DropTail
$ns duplex-link $n(19) $n(149) 1.5Mb 470ms DropTail
$ns duplex-link $n(19) $n(145) 1.5Mb 410ms DropTail
$ns duplex-link $n(19) $n(144) 1.5Mb 490ms DropTail
$ns duplex-link $n(19) $n(143) 1.5Mb 470ms DropTail
$ns duplex-link $n(19) $n(139) 1.5Mb 250ms DropTail
$ns duplex-link $n(19) $n(122) 1.5Mb 250ms DropTail
$ns duplex-link $n(19) $n(105) 1.5Mb 400ms DropTail
$ns duplex-link $n(19) $n(102) 1.5Mb 30ms DropTail
if {$verbose} { puts -nonewline "530..."; flush stdout }
$ns duplex-link $n(19) $n(97) 1.5Mb 160ms DropTail
$ns duplex-link $n(19) $n(94) 1.5Mb 80ms DropTail
$ns duplex-link $n(19) $n(93) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(90) 1.5Mb 260ms DropTail
$ns duplex-link $n(19) $n(88) 1.5Mb 60ms DropTail
$ns duplex-link $n(19) $n(79) 1.5Mb 110ms DropTail
$ns duplex-link $n(19) $n(76) 1.5Mb 400ms DropTail
$ns duplex-link $n(19) $n(70) 1.5Mb 400ms DropTail
$ns duplex-link $n(19) $n(69) 1.5Mb 90ms DropTail
$ns duplex-link $n(19) $n(65) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "540..."; flush stdout }
$ns duplex-link $n(19) $n(52) 1.5Mb 350ms DropTail
$ns duplex-link $n(19) $n(51) 1.5Mb 510ms DropTail
$ns duplex-link $n(19) $n(48) 1.5Mb 190ms DropTail
$ns duplex-link $n(19) $n(44) 1.5Mb 320ms DropTail
$ns duplex-link $n(19) $n(41) 1.5Mb 470ms DropTail
$ns duplex-link $n(19) $n(40) 1.5Mb 230ms DropTail
$ns duplex-link $n(19) $n(32) 1.5Mb 480ms DropTail
$ns duplex-link $n(19) $n(30) 1.5Mb 610ms DropTail
$ns duplex-link $n(19) $n(26) 1.5Mb 480ms DropTail
$ns duplex-link $n(20) $n(146) 1.5Mb 890ms DropTail
if {$verbose} { puts -nonewline "550..."; flush stdout }
$ns duplex-link $n(20) $n(144) 1.5Mb 900ms DropTail
$ns duplex-link $n(20) $n(139) 1.5Mb 520ms DropTail
$ns duplex-link $n(20) $n(131) 1.5Mb 490ms DropTail
$ns duplex-link $n(20) $n(129) 1.5Mb 690ms DropTail
$ns duplex-link $n(20) $n(118) 1.5Mb 920ms DropTail
$ns duplex-link $n(20) $n(106) 1.5Mb 710ms DropTail
$ns duplex-link $n(20) $n(92) 1.5Mb 860ms DropTail
$ns duplex-link $n(20) $n(91) 1.5Mb 480ms DropTail
$ns duplex-link $n(20) $n(87) 1.5Mb 930ms DropTail
$ns duplex-link $n(20) $n(85) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "560..."; flush stdout }
$ns duplex-link $n(20) $n(82) 1.5Mb 720ms DropTail
$ns duplex-link $n(20) $n(80) 1.5Mb 570ms DropTail
$ns duplex-link $n(20) $n(76) 1.5Mb 790ms DropTail
$ns duplex-link $n(20) $n(67) 1.5Mb 1030ms DropTail
$ns duplex-link $n(20) $n(63) 1.5Mb 840ms DropTail
$ns duplex-link $n(20) $n(60) 1.5Mb 370ms DropTail
$ns duplex-link $n(20) $n(57) 1.5Mb 320ms DropTail
$ns duplex-link $n(20) $n(52) 1.5Mb 800ms DropTail
$ns duplex-link $n(20) $n(48) 1.5Mb 470ms DropTail
$ns duplex-link $n(20) $n(44) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "570..."; flush stdout }
$ns duplex-link $n(20) $n(42) 1.5Mb 1210ms DropTail
$ns duplex-link $n(20) $n(40) 1.5Mb 400ms DropTail
$ns duplex-link $n(20) $n(38) 1.5Mb 760ms DropTail
$ns duplex-link $n(20) $n(31) 1.5Mb 210ms DropTail
$ns duplex-link $n(20) $n(25) 1.5Mb 440ms DropTail
$ns duplex-link $n(20) $n(23) 1.5Mb 380ms DropTail
$ns duplex-link $n(20) $n(22) 1.5Mb 690ms DropTail
$ns duplex-link $n(21) $n(146) 1.5Mb 310ms DropTail
$ns duplex-link $n(21) $n(139) 1.5Mb 650ms DropTail
$ns duplex-link $n(21) $n(138) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "580..."; flush stdout }
$ns duplex-link $n(21) $n(113) 1.5Mb 920ms DropTail
$ns duplex-link $n(21) $n(107) 1.5Mb 620ms DropTail
$ns duplex-link $n(21) $n(106) 1.5Mb 550ms DropTail
$ns duplex-link $n(21) $n(105) 1.5Mb 300ms DropTail
$ns duplex-link $n(21) $n(103) 1.5Mb 170ms DropTail
$ns duplex-link $n(21) $n(101) 1.5Mb 890ms DropTail
$ns duplex-link $n(21) $n(98) 1.5Mb 250ms DropTail
$ns duplex-link $n(21) $n(91) 1.5Mb 810ms DropTail
$ns duplex-link $n(21) $n(89) 1.5Mb 890ms DropTail
$ns duplex-link $n(21) $n(77) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "590..."; flush stdout }
$ns duplex-link $n(21) $n(72) 1.5Mb 550ms DropTail
$ns duplex-link $n(21) $n(65) 1.5Mb 820ms DropTail
$ns duplex-link $n(21) $n(50) 1.5Mb 500ms DropTail
$ns duplex-link $n(21) $n(41) 1.5Mb 660ms DropTail
$ns duplex-link $n(21) $n(39) 1.5Mb 650ms DropTail
$ns duplex-link $n(21) $n(35) 1.5Mb 890ms DropTail
$ns duplex-link $n(21) $n(32) 1.5Mb 1010ms DropTail
$ns duplex-link $n(21) $n(30) 1.5Mb 90ms DropTail
$ns duplex-link $n(21) $n(29) 1.5Mb 340ms DropTail
$ns duplex-link $n(21) $n(28) 1.5Mb 1040ms DropTail
if {$verbose} { puts -nonewline "600..."; flush stdout }
$ns duplex-link $n(21) $n(26) 1.5Mb 240ms DropTail
$ns duplex-link $n(21) $n(25) 1.5Mb 710ms DropTail
$ns duplex-link $n(22) $n(134) 1.5Mb 750ms DropTail
$ns duplex-link $n(22) $n(133) 1.5Mb 260ms DropTail
$ns duplex-link $n(22) $n(128) 1.5Mb 340ms DropTail
$ns duplex-link $n(22) $n(126) 1.5Mb 630ms DropTail
$ns duplex-link $n(22) $n(122) 1.5Mb 300ms DropTail
$ns duplex-link $n(22) $n(116) 1.5Mb 700ms DropTail
$ns duplex-link $n(22) $n(100) 1.5Mb 480ms DropTail
$ns duplex-link $n(22) $n(88) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "610..."; flush stdout }
$ns duplex-link $n(22) $n(80) 1.5Mb 140ms DropTail
$ns duplex-link $n(22) $n(75) 1.5Mb 600ms DropTail
$ns duplex-link $n(22) $n(73) 1.5Mb 430ms DropTail
$ns duplex-link $n(22) $n(72) 1.5Mb 430ms DropTail
$ns duplex-link $n(22) $n(57) 1.5Mb 570ms DropTail
$ns duplex-link $n(22) $n(53) 1.5Mb 660ms DropTail
$ns duplex-link $n(22) $n(47) 1.5Mb 180ms DropTail
$ns duplex-link $n(22) $n(46) 1.5Mb 480ms DropTail
$ns duplex-link $n(22) $n(45) 1.5Mb 400ms DropTail
$ns duplex-link $n(22) $n(37) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "620..."; flush stdout }
$ns duplex-link $n(22) $n(27) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(147) 1.5Mb 540ms DropTail
$ns duplex-link $n(23) $n(146) 1.5Mb 670ms DropTail
$ns duplex-link $n(23) $n(144) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(142) 1.5Mb 940ms DropTail
$ns duplex-link $n(23) $n(130) 1.5Mb 890ms DropTail
$ns duplex-link $n(23) $n(126) 1.5Mb 600ms DropTail
$ns duplex-link $n(23) $n(125) 1.5Mb 840ms DropTail
$ns duplex-link $n(23) $n(111) 1.5Mb 900ms DropTail
$ns duplex-link $n(23) $n(110) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "630..."; flush stdout }
$ns duplex-link $n(23) $n(105) 1.5Mb 850ms DropTail
$ns duplex-link $n(23) $n(103) 1.5Mb 1030ms DropTail
$ns duplex-link $n(23) $n(89) 1.5Mb 480ms DropTail
$ns duplex-link $n(23) $n(88) 1.5Mb 460ms DropTail
$ns duplex-link $n(23) $n(84) 1.5Mb 860ms DropTail
$ns duplex-link $n(23) $n(68) 1.5Mb 690ms DropTail
$ns duplex-link $n(23) $n(67) 1.5Mb 850ms DropTail
$ns duplex-link $n(23) $n(63) 1.5Mb 470ms DropTail
$ns duplex-link $n(23) $n(61) 1.5Mb 750ms DropTail
$ns duplex-link $n(23) $n(60) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "640..."; flush stdout }
$ns duplex-link $n(23) $n(45) 1.5Mb 850ms DropTail
$ns duplex-link $n(23) $n(38) 1.5Mb 400ms DropTail
$ns duplex-link $n(23) $n(35) 1.5Mb 210ms DropTail
$ns duplex-link $n(23) $n(33) 1.5Mb 530ms DropTail
$ns duplex-link $n(23) $n(30) 1.5Mb 1040ms DropTail
$ns duplex-link $n(23) $n(25) 1.5Mb 310ms DropTail
$ns duplex-link $n(24) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(24) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(24) $n(130) 1.5Mb 630ms DropTail
$ns duplex-link $n(24) $n(128) 1.5Mb 150ms DropTail
if {$verbose} { puts -nonewline "650..."; flush stdout }
$ns duplex-link $n(24) $n(121) 1.5Mb 450ms DropTail
$ns duplex-link $n(24) $n(120) 1.5Mb 170ms DropTail
$ns duplex-link $n(24) $n(114) 1.5Mb 770ms DropTail
$ns duplex-link $n(24) $n(103) 1.5Mb 800ms DropTail
$ns duplex-link $n(24) $n(101) 1.5Mb 280ms DropTail
$ns duplex-link $n(24) $n(96) 1.5Mb 260ms DropTail
$ns duplex-link $n(24) $n(85) 1.5Mb 360ms DropTail
$ns duplex-link $n(24) $n(78) 1.5Mb 790ms DropTail
$ns duplex-link $n(24) $n(70) 1.5Mb 690ms DropTail
$ns duplex-link $n(24) $n(69) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "660..."; flush stdout }
$ns duplex-link $n(24) $n(67) 1.5Mb 580ms DropTail
$ns duplex-link $n(24) $n(66) 1.5Mb 280ms DropTail
$ns duplex-link $n(24) $n(58) 1.5Mb 650ms DropTail
$ns duplex-link $n(24) $n(57) 1.5Mb 490ms DropTail
$ns duplex-link $n(24) $n(51) 1.5Mb 630ms DropTail
$ns duplex-link $n(24) $n(48) 1.5Mb 140ms DropTail
$ns duplex-link $n(24) $n(45) 1.5Mb 590ms DropTail
$ns duplex-link $n(24) $n(43) 1.5Mb 530ms DropTail
$ns duplex-link $n(24) $n(39) 1.5Mb 10ms DropTail
$ns duplex-link $n(24) $n(26) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "670..."; flush stdout }
$ns duplex-link $n(25) $n(148) 1.5Mb 330ms DropTail
$ns duplex-link $n(25) $n(133) 1.5Mb 550ms DropTail
$ns duplex-link $n(25) $n(131) 1.5Mb 340ms DropTail
$ns duplex-link $n(25) $n(108) 1.5Mb 210ms DropTail
$ns duplex-link $n(25) $n(107) 1.5Mb 180ms DropTail
$ns duplex-link $n(25) $n(92) 1.5Mb 590ms DropTail
$ns duplex-link $n(25) $n(86) 1.5Mb 570ms DropTail
$ns duplex-link $n(25) $n(81) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(80) 1.5Mb 260ms DropTail
$ns duplex-link $n(25) $n(79) 1.5Mb 90ms DropTail
if {$verbose} { puts -nonewline "680..."; flush stdout }
$ns duplex-link $n(25) $n(77) 1.5Mb 550ms DropTail
$ns duplex-link $n(25) $n(75) 1.5Mb 410ms DropTail
$ns duplex-link $n(25) $n(73) 1.5Mb 140ms DropTail
$ns duplex-link $n(25) $n(55) 1.5Mb 450ms DropTail
$ns duplex-link $n(25) $n(52) 1.5Mb 430ms DropTail
$ns duplex-link $n(25) $n(37) 1.5Mb 400ms DropTail
$ns duplex-link $n(25) $n(34) 1.5Mb 460ms DropTail
$ns duplex-link $n(25) $n(32) 1.5Mb 300ms DropTail
$ns duplex-link $n(25) $n(26) 1.5Mb 670ms DropTail
$ns duplex-link $n(26) $n(144) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "690..."; flush stdout }
$ns duplex-link $n(26) $n(141) 1.5Mb 220ms DropTail
$ns duplex-link $n(26) $n(135) 1.5Mb 140ms DropTail
$ns duplex-link $n(26) $n(130) 1.5Mb 160ms DropTail
$ns duplex-link $n(26) $n(128) 1.5Mb 860ms DropTail
$ns duplex-link $n(26) $n(125) 1.5Mb 30ms DropTail
$ns duplex-link $n(26) $n(103) 1.5Mb 180ms DropTail
$ns duplex-link $n(26) $n(95) 1.5Mb 260ms DropTail
$ns duplex-link $n(26) $n(92) 1.5Mb 730ms DropTail
$ns duplex-link $n(26) $n(87) 1.5Mb 180ms DropTail
$ns duplex-link $n(26) $n(83) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "700..."; flush stdout }
$ns duplex-link $n(26) $n(82) 1.5Mb 710ms DropTail
$ns duplex-link $n(26) $n(81) 1.5Mb 440ms DropTail
$ns duplex-link $n(26) $n(79) 1.5Mb 590ms DropTail
$ns duplex-link $n(26) $n(75) 1.5Mb 600ms DropTail
$ns duplex-link $n(26) $n(74) 1.5Mb 420ms DropTail
$ns duplex-link $n(26) $n(73) 1.5Mb 680ms DropTail
$ns duplex-link $n(26) $n(44) 1.5Mb 210ms DropTail
$ns duplex-link $n(26) $n(30) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(149) 1.5Mb 690ms DropTail
$ns duplex-link $n(27) $n(136) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "710..."; flush stdout }
$ns duplex-link $n(27) $n(132) 1.5Mb 400ms DropTail
$ns duplex-link $n(27) $n(128) 1.5Mb 830ms DropTail
$ns duplex-link $n(27) $n(121) 1.5Mb 250ms DropTail
$ns duplex-link $n(27) $n(114) 1.5Mb 420ms DropTail
$ns duplex-link $n(27) $n(110) 1.5Mb 430ms DropTail
$ns duplex-link $n(27) $n(103) 1.5Mb 340ms DropTail
$ns duplex-link $n(27) $n(101) 1.5Mb 810ms DropTail
$ns duplex-link $n(27) $n(97) 1.5Mb 280ms DropTail
$ns duplex-link $n(27) $n(91) 1.5Mb 590ms DropTail
$ns duplex-link $n(27) $n(83) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "720..."; flush stdout }
$ns duplex-link $n(27) $n(82) 1.5Mb 560ms DropTail
$ns duplex-link $n(27) $n(79) 1.5Mb 520ms DropTail
$ns duplex-link $n(27) $n(77) 1.5Mb 50ms DropTail
$ns duplex-link $n(27) $n(66) 1.5Mb 410ms DropTail
$ns duplex-link $n(27) $n(53) 1.5Mb 910ms DropTail
$ns duplex-link $n(27) $n(47) 1.5Mb 700ms DropTail
$ns duplex-link $n(27) $n(42) 1.5Mb 260ms DropTail
$ns duplex-link $n(27) $n(38) 1.5Mb 410ms DropTail
$ns duplex-link $n(27) $n(37) 1.5Mb 570ms DropTail
$ns duplex-link $n(27) $n(33) 1.5Mb 860ms DropTail
if {$verbose} { puts -nonewline "730..."; flush stdout }
$ns duplex-link $n(28) $n(148) 1.5Mb 660ms DropTail
$ns duplex-link $n(28) $n(146) 1.5Mb 790ms DropTail
$ns duplex-link $n(28) $n(137) 1.5Mb 720ms DropTail
$ns duplex-link $n(28) $n(132) 1.5Mb 580ms DropTail
$ns duplex-link $n(28) $n(113) 1.5Mb 180ms DropTail
$ns duplex-link $n(28) $n(102) 1.5Mb 500ms DropTail
$ns duplex-link $n(28) $n(99) 1.5Mb 290ms DropTail
$ns duplex-link $n(28) $n(91) 1.5Mb 380ms DropTail
$ns duplex-link $n(28) $n(90) 1.5Mb 550ms DropTail
$ns duplex-link $n(28) $n(72) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "740..."; flush stdout }
$ns duplex-link $n(28) $n(71) 1.5Mb 520ms DropTail
$ns duplex-link $n(28) $n(64) 1.5Mb 410ms DropTail
$ns duplex-link $n(28) $n(63) 1.5Mb 750ms DropTail
$ns duplex-link $n(28) $n(62) 1.5Mb 970ms DropTail
$ns duplex-link $n(28) $n(60) 1.5Mb 270ms DropTail
$ns duplex-link $n(28) $n(57) 1.5Mb 240ms DropTail
$ns duplex-link $n(28) $n(54) 1.5Mb 600ms DropTail
$ns duplex-link $n(28) $n(53) 1.5Mb 130ms DropTail
$ns duplex-link $n(28) $n(52) 1.5Mb 710ms DropTail
$ns duplex-link $n(28) $n(48) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "750..."; flush stdout }
$ns duplex-link $n(28) $n(35) 1.5Mb 510ms DropTail
$ns duplex-link $n(29) $n(147) 1.5Mb 340ms DropTail
$ns duplex-link $n(29) $n(142) 1.5Mb 160ms DropTail
$ns duplex-link $n(29) $n(139) 1.5Mb 390ms DropTail
$ns duplex-link $n(29) $n(136) 1.5Mb 230ms DropTail
$ns duplex-link $n(29) $n(134) 1.5Mb 910ms DropTail
$ns duplex-link $n(29) $n(128) 1.5Mb 530ms DropTail
$ns duplex-link $n(29) $n(127) 1.5Mb 60ms DropTail
$ns duplex-link $n(29) $n(125) 1.5Mb 480ms DropTail
$ns duplex-link $n(29) $n(120) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "760..."; flush stdout }
$ns duplex-link $n(29) $n(105) 1.5Mb 50ms DropTail
$ns duplex-link $n(29) $n(99) 1.5Mb 850ms DropTail
$ns duplex-link $n(29) $n(90) 1.5Mb 290ms DropTail
$ns duplex-link $n(29) $n(82) 1.5Mb 910ms DropTail
$ns duplex-link $n(29) $n(80) 1.5Mb 340ms DropTail
$ns duplex-link $n(29) $n(73) 1.5Mb 660ms DropTail
$ns duplex-link $n(29) $n(69) 1.5Mb 450ms DropTail
$ns duplex-link $n(29) $n(68) 1.5Mb 610ms DropTail
$ns duplex-link $n(29) $n(51) 1.5Mb 310ms DropTail
$ns duplex-link $n(29) $n(47) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "770..."; flush stdout }
$ns duplex-link $n(29) $n(46) 1.5Mb 720ms DropTail
$ns duplex-link $n(29) $n(42) 1.5Mb 540ms DropTail
$ns duplex-link $n(29) $n(37) 1.5Mb 860ms DropTail
$ns duplex-link $n(30) $n(149) 1.5Mb 550ms DropTail
$ns duplex-link $n(30) $n(130) 1.5Mb 150ms DropTail
$ns duplex-link $n(30) $n(120) 1.5Mb 630ms DropTail
$ns duplex-link $n(30) $n(116) 1.5Mb 1240ms DropTail
$ns duplex-link $n(30) $n(112) 1.5Mb 740ms DropTail
$ns duplex-link $n(30) $n(103) 1.5Mb 110ms DropTail
$ns duplex-link $n(30) $n(100) 1.5Mb 950ms DropTail
if {$verbose} { puts -nonewline "780..."; flush stdout }
$ns duplex-link $n(30) $n(96) 1.5Mb 550ms DropTail
$ns duplex-link $n(30) $n(95) 1.5Mb 320ms DropTail
$ns duplex-link $n(30) $n(94) 1.5Mb 570ms DropTail
$ns duplex-link $n(30) $n(90) 1.5Mb 650ms DropTail
$ns duplex-link $n(30) $n(87) 1.5Mb 360ms DropTail
$ns duplex-link $n(30) $n(85) 1.5Mb 440ms DropTail
$ns duplex-link $n(30) $n(82) 1.5Mb 940ms DropTail
$ns duplex-link $n(30) $n(81) 1.5Mb 540ms DropTail
$ns duplex-link $n(30) $n(79) 1.5Mb 710ms DropTail
$ns duplex-link $n(30) $n(63) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "790..."; flush stdout }
$ns duplex-link $n(30) $n(61) 1.5Mb 320ms DropTail
$ns duplex-link $n(30) $n(54) 1.5Mb 570ms DropTail
$ns duplex-link $n(30) $n(41) 1.5Mb 700ms DropTail
$ns duplex-link $n(30) $n(40) 1.5Mb 830ms DropTail
$ns duplex-link $n(30) $n(35) 1.5Mb 950ms DropTail
$ns duplex-link $n(30) $n(33) 1.5Mb 940ms DropTail
$ns duplex-link $n(31) $n(146) 1.5Mb 680ms DropTail
$ns duplex-link $n(31) $n(145) 1.5Mb 760ms DropTail
$ns duplex-link $n(31) $n(140) 1.5Mb 160ms DropTail
$ns duplex-link $n(31) $n(128) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "800..."; flush stdout }
$ns duplex-link $n(31) $n(124) 1.5Mb 860ms DropTail
$ns duplex-link $n(31) $n(114) 1.5Mb 700ms DropTail
$ns duplex-link $n(31) $n(107) 1.5Mb 340ms DropTail
$ns duplex-link $n(31) $n(104) 1.5Mb 470ms DropTail
$ns duplex-link $n(31) $n(101) 1.5Mb 90ms DropTail
$ns duplex-link $n(31) $n(98) 1.5Mb 720ms DropTail
$ns duplex-link $n(31) $n(96) 1.5Mb 470ms DropTail
$ns duplex-link $n(31) $n(94) 1.5Mb 450ms DropTail
$ns duplex-link $n(31) $n(87) 1.5Mb 730ms DropTail
$ns duplex-link $n(31) $n(76) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "810..."; flush stdout }
$ns duplex-link $n(31) $n(69) 1.5Mb 490ms DropTail
$ns duplex-link $n(31) $n(65) 1.5Mb 210ms DropTail
$ns duplex-link $n(31) $n(54) 1.5Mb 500ms DropTail
$ns duplex-link $n(31) $n(44) 1.5Mb 740ms DropTail
$ns duplex-link $n(32) $n(149) 1.5Mb 850ms DropTail
$ns duplex-link $n(32) $n(148) 1.5Mb 630ms DropTail
$ns duplex-link $n(32) $n(145) 1.5Mb 730ms DropTail
$ns duplex-link $n(32) $n(137) 1.5Mb 750ms DropTail
$ns duplex-link $n(32) $n(133) 1.5Mb 830ms DropTail
$ns duplex-link $n(32) $n(132) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "820..."; flush stdout }
$ns duplex-link $n(32) $n(131) 1.5Mb 250ms DropTail
$ns duplex-link $n(32) $n(121) 1.5Mb 700ms DropTail
$ns duplex-link $n(32) $n(112) 1.5Mb 350ms DropTail
$ns duplex-link $n(32) $n(110) 1.5Mb 840ms DropTail
$ns duplex-link $n(32) $n(101) 1.5Mb 260ms DropTail
$ns duplex-link $n(32) $n(95) 1.5Mb 770ms DropTail
$ns duplex-link $n(32) $n(93) 1.5Mb 910ms DropTail
$ns duplex-link $n(32) $n(88) 1.5Mb 470ms DropTail
$ns duplex-link $n(32) $n(87) 1.5Mb 760ms DropTail
$ns duplex-link $n(32) $n(73) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "830..."; flush stdout }
$ns duplex-link $n(32) $n(70) 1.5Mb 730ms DropTail
$ns duplex-link $n(32) $n(68) 1.5Mb 780ms DropTail
$ns duplex-link $n(32) $n(64) 1.5Mb 520ms DropTail
$ns duplex-link $n(32) $n(50) 1.5Mb 740ms DropTail
$ns duplex-link $n(32) $n(48) 1.5Mb 390ms DropTail
$ns duplex-link $n(32) $n(37) 1.5Mb 390ms DropTail
$ns duplex-link $n(32) $n(35) 1.5Mb 350ms DropTail
$ns duplex-link $n(32) $n(34) 1.5Mb 550ms DropTail
$ns duplex-link $n(33) $n(146) 1.5Mb 670ms DropTail
$ns duplex-link $n(33) $n(129) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "840..."; flush stdout }
$ns duplex-link $n(33) $n(125) 1.5Mb 860ms DropTail
$ns duplex-link $n(33) $n(116) 1.5Mb 370ms DropTail
$ns duplex-link $n(33) $n(114) 1.5Mb 860ms DropTail
$ns duplex-link $n(33) $n(111) 1.5Mb 710ms DropTail
$ns duplex-link $n(33) $n(104) 1.5Mb 480ms DropTail
$ns duplex-link $n(33) $n(103) 1.5Mb 990ms DropTail
$ns duplex-link $n(33) $n(102) 1.5Mb 410ms DropTail
$ns duplex-link $n(33) $n(82) 1.5Mb 790ms DropTail
$ns duplex-link $n(33) $n(81) 1.5Mb 450ms DropTail
$ns duplex-link $n(33) $n(74) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "850..."; flush stdout }
$ns duplex-link $n(33) $n(73) 1.5Mb 440ms DropTail
$ns duplex-link $n(33) $n(72) 1.5Mb 650ms DropTail
$ns duplex-link $n(33) $n(71) 1.5Mb 540ms DropTail
$ns duplex-link $n(33) $n(66) 1.5Mb 450ms DropTail
$ns duplex-link $n(33) $n(57) 1.5Mb 450ms DropTail
$ns duplex-link $n(33) $n(56) 1.5Mb 610ms DropTail
$ns duplex-link $n(33) $n(55) 1.5Mb 620ms DropTail
$ns duplex-link $n(33) $n(43) 1.5Mb 570ms DropTail
$ns duplex-link $n(33) $n(36) 1.5Mb 180ms DropTail
$ns duplex-link $n(34) $n(137) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "860..."; flush stdout }
$ns duplex-link $n(34) $n(130) 1.5Mb 660ms DropTail
$ns duplex-link $n(34) $n(129) 1.5Mb 430ms DropTail
$ns duplex-link $n(34) $n(121) 1.5Mb 470ms DropTail
$ns duplex-link $n(34) $n(110) 1.5Mb 700ms DropTail
$ns duplex-link $n(34) $n(109) 1.5Mb 220ms DropTail
$ns duplex-link $n(34) $n(104) 1.5Mb 400ms DropTail
$ns duplex-link $n(34) $n(96) 1.5Mb 500ms DropTail
$ns duplex-link $n(34) $n(95) 1.5Mb 570ms DropTail
$ns duplex-link $n(34) $n(94) 1.5Mb 500ms DropTail
$ns duplex-link $n(34) $n(86) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "870..."; flush stdout }
$ns duplex-link $n(34) $n(84) 1.5Mb 560ms DropTail
$ns duplex-link $n(34) $n(78) 1.5Mb 100ms DropTail
$ns duplex-link $n(34) $n(76) 1.5Mb 40ms DropTail
$ns duplex-link $n(34) $n(74) 1.5Mb 790ms DropTail
$ns duplex-link $n(34) $n(70) 1.5Mb 260ms DropTail
$ns duplex-link $n(34) $n(64) 1.5Mb 820ms DropTail
$ns duplex-link $n(34) $n(63) 1.5Mb 60ms DropTail
$ns duplex-link $n(34) $n(61) 1.5Mb 480ms DropTail
$ns duplex-link $n(34) $n(48) 1.5Mb 560ms DropTail
$ns duplex-link $n(34) $n(47) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "880..."; flush stdout }
$ns duplex-link $n(34) $n(44) 1.5Mb 560ms DropTail
$ns duplex-link $n(34) $n(38) 1.5Mb 30ms DropTail
$ns duplex-link $n(34) $n(36) 1.5Mb 610ms DropTail
$ns duplex-link $n(35) $n(144) 1.5Mb 330ms DropTail
$ns duplex-link $n(35) $n(142) 1.5Mb 900ms DropTail
$ns duplex-link $n(35) $n(141) 1.5Mb 840ms DropTail
$ns duplex-link $n(35) $n(130) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(122) 1.5Mb 470ms DropTail
$ns duplex-link $n(35) $n(115) 1.5Mb 800ms DropTail
$ns duplex-link $n(35) $n(110) 1.5Mb 780ms DropTail
if {$verbose} { puts -nonewline "890..."; flush stdout }
$ns duplex-link $n(35) $n(107) 1.5Mb 560ms DropTail
$ns duplex-link $n(35) $n(97) 1.5Mb 400ms DropTail
$ns duplex-link $n(35) $n(96) 1.5Mb 520ms DropTail
$ns duplex-link $n(35) $n(90) 1.5Mb 660ms DropTail
$ns duplex-link $n(35) $n(82) 1.5Mb 130ms DropTail
$ns duplex-link $n(35) $n(77) 1.5Mb 570ms DropTail
$ns duplex-link $n(35) $n(73) 1.5Mb 240ms DropTail
$ns duplex-link $n(35) $n(72) 1.5Mb 340ms DropTail
$ns duplex-link $n(35) $n(67) 1.5Mb 770ms DropTail
$ns duplex-link $n(35) $n(64) 1.5Mb 730ms DropTail
if {$verbose} { puts -nonewline "900..."; flush stdout }
$ns duplex-link $n(35) $n(61) 1.5Mb 640ms DropTail
$ns duplex-link $n(35) $n(50) 1.5Mb 810ms DropTail
$ns duplex-link $n(35) $n(39) 1.5Mb 650ms DropTail
$ns duplex-link $n(36) $n(139) 1.5Mb 200ms DropTail
$ns duplex-link $n(36) $n(138) 1.5Mb 490ms DropTail
$ns duplex-link $n(36) $n(136) 1.5Mb 600ms DropTail
$ns duplex-link $n(36) $n(135) 1.5Mb 700ms DropTail
$ns duplex-link $n(36) $n(134) 1.5Mb 730ms DropTail
$ns duplex-link $n(36) $n(130) 1.5Mb 760ms DropTail
$ns duplex-link $n(36) $n(129) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "910..."; flush stdout }
$ns duplex-link $n(36) $n(127) 1.5Mb 530ms DropTail
$ns duplex-link $n(36) $n(119) 1.5Mb 610ms DropTail
$ns duplex-link $n(36) $n(115) 1.5Mb 640ms DropTail
$ns duplex-link $n(36) $n(114) 1.5Mb 690ms DropTail
$ns duplex-link $n(36) $n(113) 1.5Mb 210ms DropTail
$ns duplex-link $n(36) $n(109) 1.5Mb 530ms DropTail
$ns duplex-link $n(36) $n(108) 1.5Mb 330ms DropTail
$ns duplex-link $n(36) $n(106) 1.5Mb 450ms DropTail
$ns duplex-link $n(36) $n(101) 1.5Mb 80ms DropTail
$ns duplex-link $n(36) $n(97) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "920..."; flush stdout }
$ns duplex-link $n(36) $n(94) 1.5Mb 330ms DropTail
$ns duplex-link $n(36) $n(74) 1.5Mb 670ms DropTail
$ns duplex-link $n(36) $n(72) 1.5Mb 500ms DropTail
$ns duplex-link $n(36) $n(70) 1.5Mb 690ms DropTail
$ns duplex-link $n(36) $n(69) 1.5Mb 400ms DropTail
$ns duplex-link $n(36) $n(62) 1.5Mb 760ms DropTail
$ns duplex-link $n(36) $n(60) 1.5Mb 90ms DropTail
$ns duplex-link $n(36) $n(59) 1.5Mb 160ms DropTail
$ns duplex-link $n(36) $n(54) 1.5Mb 360ms DropTail
$ns duplex-link $n(36) $n(43) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "930..."; flush stdout }
$ns duplex-link $n(36) $n(37) 1.5Mb 520ms DropTail
$ns duplex-link $n(37) $n(142) 1.5Mb 900ms DropTail
$ns duplex-link $n(37) $n(139) 1.5Mb 620ms DropTail
$ns duplex-link $n(37) $n(138) 1.5Mb 830ms DropTail
$ns duplex-link $n(37) $n(136) 1.5Mb 710ms DropTail
$ns duplex-link $n(37) $n(134) 1.5Mb 270ms DropTail
$ns duplex-link $n(37) $n(129) 1.5Mb 470ms DropTail
$ns duplex-link $n(37) $n(113) 1.5Mb 380ms DropTail
$ns duplex-link $n(37) $n(112) 1.5Mb 370ms DropTail
$ns duplex-link $n(37) $n(102) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "940..."; flush stdout }
$ns duplex-link $n(37) $n(97) 1.5Mb 390ms DropTail
$ns duplex-link $n(37) $n(95) 1.5Mb 660ms DropTail
$ns duplex-link $n(37) $n(86) 1.5Mb 350ms DropTail
$ns duplex-link $n(37) $n(79) 1.5Mb 420ms DropTail
$ns duplex-link $n(37) $n(69) 1.5Mb 420ms DropTail
$ns duplex-link $n(37) $n(62) 1.5Mb 670ms DropTail
$ns duplex-link $n(37) $n(58) 1.5Mb 660ms DropTail
$ns duplex-link $n(37) $n(53) 1.5Mb 460ms DropTail
$ns duplex-link $n(37) $n(47) 1.5Mb 810ms DropTail
$ns duplex-link $n(37) $n(44) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "950..."; flush stdout }
$ns duplex-link $n(37) $n(39) 1.5Mb 670ms DropTail
$ns duplex-link $n(38) $n(144) 1.5Mb 140ms DropTail
$ns duplex-link $n(38) $n(143) 1.5Mb 80ms DropTail
$ns duplex-link $n(38) $n(140) 1.5Mb 430ms DropTail
$ns duplex-link $n(38) $n(133) 1.5Mb 860ms DropTail
$ns duplex-link $n(38) $n(124) 1.5Mb 520ms DropTail
$ns duplex-link $n(38) $n(119) 1.5Mb 1030ms DropTail
$ns duplex-link $n(38) $n(112) 1.5Mb 380ms DropTail
$ns duplex-link $n(38) $n(111) 1.5Mb 750ms DropTail
$ns duplex-link $n(38) $n(105) 1.5Mb 750ms DropTail
if {$verbose} { puts -nonewline "960..."; flush stdout }
$ns duplex-link $n(38) $n(102) 1.5Mb 400ms DropTail
$ns duplex-link $n(38) $n(101) 1.5Mb 630ms DropTail
$ns duplex-link $n(38) $n(95) 1.5Mb 550ms DropTail
$ns duplex-link $n(38) $n(82) 1.5Mb 150ms DropTail
$ns duplex-link $n(38) $n(78) 1.5Mb 130ms DropTail
$ns duplex-link $n(38) $n(75) 1.5Mb 50ms DropTail
$ns duplex-link $n(38) $n(69) 1.5Mb 340ms DropTail
$ns duplex-link $n(38) $n(63) 1.5Mb 90ms DropTail
$ns duplex-link $n(38) $n(60) 1.5Mb 480ms DropTail
$ns duplex-link $n(38) $n(59) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "970..."; flush stdout }
$ns duplex-link $n(38) $n(56) 1.5Mb 170ms DropTail
$ns duplex-link $n(38) $n(54) 1.5Mb 620ms DropTail
$ns duplex-link $n(38) $n(47) 1.5Mb 780ms DropTail
$ns duplex-link $n(38) $n(45) 1.5Mb 610ms DropTail
$ns duplex-link $n(38) $n(41) 1.5Mb 180ms DropTail
$ns duplex-link $n(39) $n(148) 1.5Mb 320ms DropTail
$ns duplex-link $n(39) $n(146) 1.5Mb 490ms DropTail
$ns duplex-link $n(39) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(39) $n(137) 1.5Mb 260ms DropTail
$ns duplex-link $n(39) $n(136) 1.5Mb 450ms DropTail
if {$verbose} { puts -nonewline "980..."; flush stdout }
$ns duplex-link $n(39) $n(134) 1.5Mb 820ms DropTail
$ns duplex-link $n(39) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(39) $n(129) 1.5Mb 320ms DropTail
$ns duplex-link $n(39) $n(112) 1.5Mb 300ms DropTail
$ns duplex-link $n(39) $n(110) 1.5Mb 440ms DropTail
$ns duplex-link $n(39) $n(99) 1.5Mb 550ms DropTail
$ns duplex-link $n(39) $n(96) 1.5Mb 260ms DropTail
$ns duplex-link $n(39) $n(88) 1.5Mb 230ms DropTail
$ns duplex-link $n(39) $n(82) 1.5Mb 740ms DropTail
$ns duplex-link $n(39) $n(73) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "990..."; flush stdout }
$ns duplex-link $n(39) $n(66) 1.5Mb 280ms DropTail
$ns duplex-link $n(39) $n(64) 1.5Mb 160ms DropTail
$ns duplex-link $n(39) $n(61) 1.5Mb 600ms DropTail
$ns duplex-link $n(39) $n(47) 1.5Mb 190ms DropTail
$ns duplex-link $n(40) $n(149) 1.5Mb 590ms DropTail
$ns duplex-link $n(40) $n(146) 1.5Mb 480ms DropTail
$ns duplex-link $n(40) $n(145) 1.5Mb 570ms DropTail
$ns duplex-link $n(40) $n(141) 1.5Mb 690ms DropTail
$ns duplex-link $n(40) $n(138) 1.5Mb 500ms DropTail
$ns duplex-link $n(40) $n(137) 1.5Mb 490ms DropTail
if {$verbose} { puts -nonewline "1000..."; flush stdout }
$ns duplex-link $n(40) $n(135) 1.5Mb 620ms DropTail
$ns duplex-link $n(40) $n(134) 1.5Mb 600ms DropTail
$ns duplex-link $n(40) $n(133) 1.5Mb 580ms DropTail
$ns duplex-link $n(40) $n(123) 1.5Mb 330ms DropTail
$ns duplex-link $n(40) $n(121) 1.5Mb 450ms DropTail
$ns duplex-link $n(40) $n(119) 1.5Mb 680ms DropTail
$ns duplex-link $n(40) $n(116) 1.5Mb 420ms DropTail
$ns duplex-link $n(40) $n(102) 1.5Mb 200ms DropTail
$ns duplex-link $n(40) $n(86) 1.5Mb 590ms DropTail
$ns duplex-link $n(40) $n(83) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "1010..."; flush stdout }
$ns duplex-link $n(40) $n(81) 1.5Mb 290ms DropTail
$ns duplex-link $n(40) $n(80) 1.5Mb 280ms DropTail
$ns duplex-link $n(40) $n(66) 1.5Mb 280ms DropTail
$ns duplex-link $n(40) $n(61) 1.5Mb 580ms DropTail
$ns duplex-link $n(40) $n(59) 1.5Mb 170ms DropTail
$ns duplex-link $n(40) $n(58) 1.5Mb 640ms DropTail
$ns duplex-link $n(41) $n(149) 1.5Mb 880ms DropTail
$ns duplex-link $n(41) $n(143) 1.5Mb 150ms DropTail
$ns duplex-link $n(41) $n(134) 1.5Mb 160ms DropTail
$ns duplex-link $n(41) $n(128) 1.5Mb 860ms DropTail
if {$verbose} { puts -nonewline "1020..."; flush stdout }
$ns duplex-link $n(41) $n(124) 1.5Mb 410ms DropTail
$ns duplex-link $n(41) $n(123) 1.5Mb 830ms DropTail
$ns duplex-link $n(41) $n(119) 1.5Mb 1090ms DropTail
$ns duplex-link $n(41) $n(105) 1.5Mb 750ms DropTail
$ns duplex-link $n(41) $n(100) 1.5Mb 590ms DropTail
$ns duplex-link $n(41) $n(94) 1.5Mb 530ms DropTail
$ns duplex-link $n(41) $n(91) 1.5Mb 450ms DropTail
$ns duplex-link $n(41) $n(89) 1.5Mb 860ms DropTail
$ns duplex-link $n(41) $n(88) 1.5Mb 530ms DropTail
$ns duplex-link $n(41) $n(87) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "1030..."; flush stdout }
$ns duplex-link $n(41) $n(78) 1.5Mb 190ms DropTail
$ns duplex-link $n(41) $n(69) 1.5Mb 380ms DropTail
$ns duplex-link $n(41) $n(63) 1.5Mb 140ms DropTail
$ns duplex-link $n(41) $n(54) 1.5Mb 670ms DropTail
$ns duplex-link $n(41) $n(51) 1.5Mb 690ms DropTail
$ns duplex-link $n(41) $n(43) 1.5Mb 420ms DropTail
$ns duplex-link $n(42) $n(147) 1.5Mb 700ms DropTail
$ns duplex-link $n(42) $n(145) 1.5Mb 430ms DropTail
$ns duplex-link $n(42) $n(143) 1.5Mb 690ms DropTail
$ns duplex-link $n(42) $n(139) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "1040..."; flush stdout }
$ns duplex-link $n(42) $n(134) 1.5Mb 710ms DropTail
$ns duplex-link $n(42) $n(129) 1.5Mb 530ms DropTail
$ns duplex-link $n(42) $n(126) 1.5Mb 510ms DropTail
$ns duplex-link $n(42) $n(121) 1.5Mb 360ms DropTail
$ns duplex-link $n(42) $n(118) 1.5Mb 430ms DropTail
$ns duplex-link $n(42) $n(111) 1.5Mb 380ms DropTail
$ns duplex-link $n(42) $n(98) 1.5Mb 420ms DropTail
$ns duplex-link $n(42) $n(95) 1.5Mb 330ms DropTail
$ns duplex-link $n(42) $n(90) 1.5Mb 700ms DropTail
$ns duplex-link $n(42) $n(85) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1050..."; flush stdout }
$ns duplex-link $n(42) $n(79) 1.5Mb 690ms DropTail
$ns duplex-link $n(42) $n(78) 1.5Mb 730ms DropTail
$ns duplex-link $n(42) $n(73) 1.5Mb 790ms DropTail
$ns duplex-link $n(42) $n(71) 1.5Mb 640ms DropTail
$ns duplex-link $n(42) $n(68) 1.5Mb 330ms DropTail
$ns duplex-link $n(42) $n(64) 1.5Mb 950ms DropTail
$ns duplex-link $n(42) $n(56) 1.5Mb 590ms DropTail
$ns duplex-link $n(42) $n(54) 1.5Mb 610ms DropTail
$ns duplex-link $n(42) $n(51) 1.5Mb 260ms DropTail
$ns duplex-link $n(42) $n(45) 1.5Mb 200ms DropTail
if {$verbose} { puts -nonewline "1060..."; flush stdout }
$ns duplex-link $n(43) $n(149) 1.5Mb 810ms DropTail
$ns duplex-link $n(43) $n(143) 1.5Mb 300ms DropTail
$ns duplex-link $n(43) $n(141) 1.5Mb 780ms DropTail
$ns duplex-link $n(43) $n(140) 1.5Mb 200ms DropTail
$ns duplex-link $n(43) $n(138) 1.5Mb 720ms DropTail
$ns duplex-link $n(43) $n(131) 1.5Mb 90ms DropTail
$ns duplex-link $n(43) $n(128) 1.5Mb 570ms DropTail
$ns duplex-link $n(43) $n(127) 1.5Mb 720ms DropTail
$ns duplex-link $n(43) $n(123) 1.5Mb 590ms DropTail
$ns duplex-link $n(43) $n(117) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "1070..."; flush stdout }
$ns duplex-link $n(43) $n(116) 1.5Mb 540ms DropTail
$ns duplex-link $n(43) $n(109) 1.5Mb 340ms DropTail
$ns duplex-link $n(43) $n(108) 1.5Mb 380ms DropTail
$ns duplex-link $n(43) $n(107) 1.5Mb 450ms DropTail
$ns duplex-link $n(43) $n(90) 1.5Mb 560ms DropTail
$ns duplex-link $n(43) $n(88) 1.5Mb 380ms DropTail
$ns duplex-link $n(43) $n(87) 1.5Mb 550ms DropTail
$ns duplex-link $n(43) $n(83) 1.5Mb 70ms DropTail
$ns duplex-link $n(43) $n(80) 1.5Mb 540ms DropTail
$ns duplex-link $n(43) $n(77) 1.5Mb 550ms DropTail
if {$verbose} { puts -nonewline "1080..."; flush stdout }
$ns duplex-link $n(43) $n(76) 1.5Mb 280ms DropTail
$ns duplex-link $n(43) $n(71) 1.5Mb 190ms DropTail
$ns duplex-link $n(43) $n(69) 1.5Mb 350ms DropTail
$ns duplex-link $n(43) $n(63) 1.5Mb 320ms DropTail
$ns duplex-link $n(43) $n(54) 1.5Mb 560ms DropTail
$ns duplex-link $n(43) $n(52) 1.5Mb 300ms DropTail
$ns duplex-link $n(43) $n(49) 1.5Mb 570ms DropTail
$ns duplex-link $n(44) $n(145) 1.5Mb 390ms DropTail
$ns duplex-link $n(44) $n(141) 1.5Mb 160ms DropTail
$ns duplex-link $n(44) $n(138) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1090..."; flush stdout }
$ns duplex-link $n(44) $n(131) 1.5Mb 720ms DropTail
$ns duplex-link $n(44) $n(130) 1.5Mb 140ms DropTail
$ns duplex-link $n(44) $n(124) 1.5Mb 180ms DropTail
$ns duplex-link $n(44) $n(119) 1.5Mb 680ms DropTail
$ns duplex-link $n(44) $n(118) 1.5Mb 190ms DropTail
$ns duplex-link $n(44) $n(117) 1.5Mb 540ms DropTail
$ns duplex-link $n(44) $n(111) 1.5Mb 210ms DropTail
$ns duplex-link $n(44) $n(105) 1.5Mb 270ms DropTail
$ns duplex-link $n(44) $n(101) 1.5Mb 700ms DropTail
$ns duplex-link $n(44) $n(99) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "1100..."; flush stdout }
$ns duplex-link $n(44) $n(97) 1.5Mb 280ms DropTail
$ns duplex-link $n(44) $n(90) 1.5Mb 410ms DropTail
$ns duplex-link $n(44) $n(89) 1.5Mb 730ms DropTail
$ns duplex-link $n(44) $n(88) 1.5Mb 350ms DropTail
$ns duplex-link $n(44) $n(84) 1.5Mb 210ms DropTail
$ns duplex-link $n(44) $n(82) 1.5Mb 690ms DropTail
$ns duplex-link $n(44) $n(77) 1.5Mb 230ms DropTail
$ns duplex-link $n(44) $n(69) 1.5Mb 280ms DropTail
$ns duplex-link $n(44) $n(62) 1.5Mb 190ms DropTail
$ns duplex-link $n(44) $n(57) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1110..."; flush stdout }
$ns duplex-link $n(44) $n(53) 1.5Mb 870ms DropTail
$ns duplex-link $n(44) $n(47) 1.5Mb 460ms DropTail
$ns duplex-link $n(45) $n(142) 1.5Mb 250ms DropTail
$ns duplex-link $n(45) $n(140) 1.5Mb 770ms DropTail
$ns duplex-link $n(45) $n(139) 1.5Mb 570ms DropTail
$ns duplex-link $n(45) $n(127) 1.5Mb 360ms DropTail
$ns duplex-link $n(45) $n(126) 1.5Mb 500ms DropTail
$ns duplex-link $n(45) $n(121) 1.5Mb 190ms DropTail
$ns duplex-link $n(45) $n(109) 1.5Mb 410ms DropTail
$ns duplex-link $n(45) $n(107) 1.5Mb 540ms DropTail
if {$verbose} { puts -nonewline "1120..."; flush stdout }
$ns duplex-link $n(45) $n(105) 1.5Mb 300ms DropTail
$ns duplex-link $n(45) $n(102) 1.5Mb 440ms DropTail
$ns duplex-link $n(45) $n(99) 1.5Mb 850ms DropTail
$ns duplex-link $n(45) $n(98) 1.5Mb 220ms DropTail
$ns duplex-link $n(45) $n(97) 1.5Mb 360ms DropTail
$ns duplex-link $n(45) $n(94) 1.5Mb 390ms DropTail
$ns duplex-link $n(45) $n(92) 1.5Mb 570ms DropTail
$ns duplex-link $n(45) $n(78) 1.5Mb 700ms DropTail
$ns duplex-link $n(45) $n(76) 1.5Mb 580ms DropTail
$ns duplex-link $n(45) $n(75) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "1130..."; flush stdout }
$ns duplex-link $n(45) $n(65) 1.5Mb 700ms DropTail
$ns duplex-link $n(45) $n(62) 1.5Mb 160ms DropTail
$ns duplex-link $n(45) $n(60) 1.5Mb 670ms DropTail
$ns duplex-link $n(45) $n(51) 1.5Mb 150ms DropTail
$ns duplex-link $n(46) $n(145) 1.5Mb 630ms DropTail
$ns duplex-link $n(46) $n(141) 1.5Mb 820ms DropTail
$ns duplex-link $n(46) $n(139) 1.5Mb 370ms DropTail
$ns duplex-link $n(46) $n(127) 1.5Mb 660ms DropTail
$ns duplex-link $n(46) $n(126) 1.5Mb 620ms DropTail
$ns duplex-link $n(46) $n(124) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "1140..."; flush stdout }
$ns duplex-link $n(46) $n(122) 1.5Mb 210ms DropTail
$ns duplex-link $n(46) $n(115) 1.5Mb 730ms DropTail
$ns duplex-link $n(46) $n(107) 1.5Mb 340ms DropTail
$ns duplex-link $n(46) $n(100) 1.5Mb 20ms DropTail
$ns duplex-link $n(46) $n(97) 1.5Mb 440ms DropTail
$ns duplex-link $n(46) $n(95) 1.5Mb 640ms DropTail
$ns duplex-link $n(46) $n(91) 1.5Mb 170ms DropTail
$ns duplex-link $n(46) $n(90) 1.5Mb 460ms DropTail
$ns duplex-link $n(46) $n(67) 1.5Mb 760ms DropTail
$ns duplex-link $n(46) $n(66) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1150..."; flush stdout }
$ns duplex-link $n(46) $n(65) 1.5Mb 80ms DropTail
$ns duplex-link $n(46) $n(60) 1.5Mb 130ms DropTail
$ns duplex-link $n(46) $n(58) 1.5Mb 750ms DropTail
$ns duplex-link $n(46) $n(54) 1.5Mb 490ms DropTail
$ns duplex-link $n(47) $n(134) 1.5Mb 930ms DropTail
$ns duplex-link $n(47) $n(126) 1.5Mb 810ms DropTail
$ns duplex-link $n(47) $n(111) 1.5Mb 390ms DropTail
$ns duplex-link $n(47) $n(107) 1.5Mb 250ms DropTail
$ns duplex-link $n(47) $n(105) 1.5Mb 260ms DropTail
$ns duplex-link $n(47) $n(94) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "1160..."; flush stdout }
$ns duplex-link $n(47) $n(87) 1.5Mb 540ms DropTail
$ns duplex-link $n(47) $n(86) 1.5Mb 850ms DropTail
$ns duplex-link $n(47) $n(75) 1.5Mb 770ms DropTail
$ns duplex-link $n(47) $n(68) 1.5Mb 710ms DropTail
$ns duplex-link $n(47) $n(66) 1.5Mb 340ms DropTail
$ns duplex-link $n(47) $n(49) 1.5Mb 170ms DropTail
$ns duplex-link $n(48) $n(143) 1.5Mb 600ms DropTail
$ns duplex-link $n(48) $n(136) 1.5Mb 450ms DropTail
$ns duplex-link $n(48) $n(131) 1.5Mb 460ms DropTail
$ns duplex-link $n(48) $n(118) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1170..."; flush stdout }
$ns duplex-link $n(48) $n(115) 1.5Mb 500ms DropTail
$ns duplex-link $n(48) $n(93) 1.5Mb 670ms DropTail
$ns duplex-link $n(48) $n(89) 1.5Mb 250ms DropTail
$ns duplex-link $n(48) $n(87) 1.5Mb 490ms DropTail
$ns duplex-link $n(48) $n(86) 1.5Mb 650ms DropTail
$ns duplex-link $n(48) $n(80) 1.5Mb 150ms DropTail
$ns duplex-link $n(48) $n(71) 1.5Mb 320ms DropTail
$ns duplex-link $n(48) $n(67) 1.5Mb 570ms DropTail
$ns duplex-link $n(48) $n(66) 1.5Mb 220ms DropTail
$ns duplex-link $n(48) $n(54) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "1180..."; flush stdout }
$ns duplex-link $n(48) $n(49) 1.5Mb 180ms DropTail
$ns duplex-link $n(49) $n(149) 1.5Mb 330ms DropTail
$ns duplex-link $n(49) $n(148) 1.5Mb 330ms DropTail
$ns duplex-link $n(49) $n(145) 1.5Mb 730ms DropTail
$ns duplex-link $n(49) $n(142) 1.5Mb 520ms DropTail
$ns duplex-link $n(49) $n(134) 1.5Mb 850ms DropTail
$ns duplex-link $n(49) $n(133) 1.5Mb 300ms DropTail
$ns duplex-link $n(49) $n(126) 1.5Mb 770ms DropTail
$ns duplex-link $n(49) $n(110) 1.5Mb 440ms DropTail
$ns duplex-link $n(49) $n(108) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "1190..."; flush stdout }
$ns duplex-link $n(49) $n(106) 1.5Mb 490ms DropTail
$ns duplex-link $n(49) $n(95) 1.5Mb 460ms DropTail
$ns duplex-link $n(49) $n(90) 1.5Mb 100ms DropTail
$ns duplex-link $n(49) $n(86) 1.5Mb 790ms DropTail
$ns duplex-link $n(49) $n(85) 1.5Mb 370ms DropTail
$ns duplex-link $n(49) $n(75) 1.5Mb 680ms DropTail
$ns duplex-link $n(49) $n(72) 1.5Mb 550ms DropTail
$ns duplex-link $n(49) $n(59) 1.5Mb 140ms DropTail
$ns duplex-link $n(49) $n(58) 1.5Mb 660ms DropTail
$ns duplex-link $n(49) $n(56) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "1200..."; flush stdout }
$ns duplex-link $n(50) $n(148) 1.5Mb 310ms DropTail
$ns duplex-link $n(50) $n(146) 1.5Mb 470ms DropTail
$ns duplex-link $n(50) $n(144) 1.5Mb 860ms DropTail
$ns duplex-link $n(50) $n(140) 1.5Mb 640ms DropTail
$ns duplex-link $n(50) $n(124) 1.5Mb 610ms DropTail
$ns duplex-link $n(50) $n(121) 1.5Mb 420ms DropTail
$ns duplex-link $n(50) $n(117) 1.5Mb 410ms DropTail
$ns duplex-link $n(50) $n(111) 1.5Mb 340ms DropTail
$ns duplex-link $n(50) $n(104) 1.5Mb 410ms DropTail
$ns duplex-link $n(50) $n(99) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "1210..."; flush stdout }
$ns duplex-link $n(50) $n(98) 1.5Mb 260ms DropTail
$ns duplex-link $n(50) $n(73) 1.5Mb 590ms DropTail
$ns duplex-link $n(50) $n(66) 1.5Mb 330ms DropTail
$ns duplex-link $n(50) $n(57) 1.5Mb 720ms DropTail
$ns duplex-link $n(50) $n(55) 1.5Mb 360ms DropTail
$ns duplex-link $n(50) $n(52) 1.5Mb 720ms DropTail
$ns duplex-link $n(51) $n(148) 1.5Mb 370ms DropTail
$ns duplex-link $n(51) $n(144) 1.5Mb 760ms DropTail
$ns duplex-link $n(51) $n(143) 1.5Mb 790ms DropTail
$ns duplex-link $n(51) $n(135) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "1220..."; flush stdout }
$ns duplex-link $n(51) $n(130) 1.5Mb 120ms DropTail
$ns duplex-link $n(51) $n(128) 1.5Mb 780ms DropTail
$ns duplex-link $n(51) $n(123) 1.5Mb 690ms DropTail
$ns duplex-link $n(51) $n(120) 1.5Mb 510ms DropTail
$ns duplex-link $n(51) $n(112) 1.5Mb 650ms DropTail
$ns duplex-link $n(51) $n(109) 1.5Mb 550ms DropTail
$ns duplex-link $n(51) $n(107) 1.5Mb 600ms DropTail
$ns duplex-link $n(51) $n(102) 1.5Mb 540ms DropTail
$ns duplex-link $n(51) $n(95) 1.5Mb 230ms DropTail
$ns duplex-link $n(51) $n(85) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1230..."; flush stdout }
$ns duplex-link $n(51) $n(76) 1.5Mb 730ms DropTail
$ns duplex-link $n(51) $n(73) 1.5Mb 760ms DropTail
$ns duplex-link $n(51) $n(65) 1.5Mb 810ms DropTail
$ns duplex-link $n(51) $n(61) 1.5Mb 300ms DropTail
$ns duplex-link $n(51) $n(53) 1.5Mb 1060ms DropTail
$ns duplex-link $n(52) $n(148) 1.5Mb 430ms DropTail
$ns duplex-link $n(52) $n(146) 1.5Mb 340ms DropTail
$ns duplex-link $n(52) $n(140) 1.5Mb 470ms DropTail
$ns duplex-link $n(52) $n(132) 1.5Mb 380ms DropTail
$ns duplex-link $n(52) $n(129) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1240..."; flush stdout }
$ns duplex-link $n(52) $n(119) 1.5Mb 980ms DropTail
$ns duplex-link $n(52) $n(110) 1.5Mb 590ms DropTail
$ns duplex-link $n(52) $n(107) 1.5Mb 540ms DropTail
$ns duplex-link $n(52) $n(104) 1.5Mb 310ms DropTail
$ns duplex-link $n(52) $n(103) 1.5Mb 640ms DropTail
$ns duplex-link $n(52) $n(101) 1.5Mb 640ms DropTail
$ns duplex-link $n(52) $n(98) 1.5Mb 590ms DropTail
$ns duplex-link $n(52) $n(88) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(83) 1.5Mb 370ms DropTail
$ns duplex-link $n(52) $n(82) 1.5Mb 250ms DropTail
if {$verbose} { puts -nonewline "1250..."; flush stdout }
$ns duplex-link $n(52) $n(77) 1.5Mb 290ms DropTail
$ns duplex-link $n(52) $n(76) 1.5Mb 70ms DropTail
$ns duplex-link $n(52) $n(72) 1.5Mb 120ms DropTail
$ns duplex-link $n(52) $n(65) 1.5Mb 410ms DropTail
$ns duplex-link $n(52) $n(56) 1.5Mb 130ms DropTail
$ns duplex-link $n(53) $n(149) 1.5Mb 890ms DropTail
$ns duplex-link $n(53) $n(147) 1.5Mb 560ms DropTail
$ns duplex-link $n(53) $n(146) 1.5Mb 800ms DropTail
$ns duplex-link $n(53) $n(137) 1.5Mb 800ms DropTail
$ns duplex-link $n(53) $n(129) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "1260..."; flush stdout }
$ns duplex-link $n(53) $n(126) 1.5Mb 790ms DropTail
$ns duplex-link $n(53) $n(113) 1.5Mb 160ms DropTail
$ns duplex-link $n(53) $n(106) 1.5Mb 600ms DropTail
$ns duplex-link $n(53) $n(101) 1.5Mb 270ms DropTail
$ns duplex-link $n(53) $n(81) 1.5Mb 620ms DropTail
$ns duplex-link $n(53) $n(72) 1.5Mb 640ms DropTail
$ns duplex-link $n(53) $n(71) 1.5Mb 490ms DropTail
$ns duplex-link $n(53) $n(66) 1.5Mb 610ms DropTail
$ns duplex-link $n(53) $n(58) 1.5Mb 950ms DropTail
$ns duplex-link $n(53) $n(57) 1.5Mb 170ms DropTail
if {$verbose} { puts -nonewline "1270..."; flush stdout }
$ns duplex-link $n(53) $n(56) 1.5Mb 560ms DropTail
$ns duplex-link $n(53) $n(55) 1.5Mb 820ms DropTail
$ns duplex-link $n(54) $n(139) 1.5Mb 180ms DropTail
$ns duplex-link $n(54) $n(137) 1.5Mb 150ms DropTail
$ns duplex-link $n(54) $n(124) 1.5Mb 500ms DropTail
$ns duplex-link $n(54) $n(122) 1.5Mb 300ms DropTail
$ns duplex-link $n(54) $n(113) 1.5Mb 520ms DropTail
$ns duplex-link $n(54) $n(110) 1.5Mb 260ms DropTail
$ns duplex-link $n(54) $n(109) 1.5Mb 460ms DropTail
$ns duplex-link $n(54) $n(101) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "1280..."; flush stdout }
$ns duplex-link $n(54) $n(93) 1.5Mb 560ms DropTail
$ns duplex-link $n(54) $n(92) 1.5Mb 300ms DropTail
$ns duplex-link $n(54) $n(86) 1.5Mb 680ms DropTail
$ns duplex-link $n(54) $n(82) 1.5Mb 720ms DropTail
$ns duplex-link $n(54) $n(78) 1.5Mb 740ms DropTail
$ns duplex-link $n(54) $n(76) 1.5Mb 620ms DropTail
$ns duplex-link $n(54) $n(72) 1.5Mb 440ms DropTail
$ns duplex-link $n(54) $n(64) 1.5Mb 340ms DropTail
$ns duplex-link $n(54) $n(60) 1.5Mb 360ms DropTail
$ns duplex-link $n(55) $n(149) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "1290..."; flush stdout }
$ns duplex-link $n(55) $n(141) 1.5Mb 200ms DropTail
$ns duplex-link $n(55) $n(126) 1.5Mb 490ms DropTail
$ns duplex-link $n(55) $n(112) 1.5Mb 400ms DropTail
$ns duplex-link $n(55) $n(92) 1.5Mb 470ms DropTail
$ns duplex-link $n(55) $n(91) 1.5Mb 560ms DropTail
$ns duplex-link $n(55) $n(90) 1.5Mb 340ms DropTail
$ns duplex-link $n(55) $n(76) 1.5Mb 530ms DropTail
$ns duplex-link $n(55) $n(74) 1.5Mb 230ms DropTail
$ns duplex-link $n(55) $n(69) 1.5Mb 240ms DropTail
$ns duplex-link $n(55) $n(66) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "1300..."; flush stdout }
$ns duplex-link $n(55) $n(65) 1.5Mb 560ms DropTail
$ns duplex-link $n(56) $n(149) 1.5Mb 690ms DropTail
$ns duplex-link $n(56) $n(145) 1.5Mb 260ms DropTail
$ns duplex-link $n(56) $n(143) 1.5Mb 240ms DropTail
$ns duplex-link $n(56) $n(139) 1.5Mb 470ms DropTail
$ns duplex-link $n(56) $n(134) 1.5Mb 320ms DropTail
$ns duplex-link $n(56) $n(129) 1.5Mb 230ms DropTail
$ns duplex-link $n(56) $n(120) 1.5Mb 570ms DropTail
$ns duplex-link $n(56) $n(117) 1.5Mb 380ms DropTail
$ns duplex-link $n(56) $n(116) 1.5Mb 710ms DropTail
if {$verbose} { puts -nonewline "1310..."; flush stdout }
$ns duplex-link $n(56) $n(112) 1.5Mb 230ms DropTail
$ns duplex-link $n(56) $n(108) 1.5Mb 250ms DropTail
$ns duplex-link $n(56) $n(105) 1.5Mb 590ms DropTail
$ns duplex-link $n(56) $n(104) 1.5Mb 200ms DropTail
$ns duplex-link $n(56) $n(103) 1.5Mb 650ms DropTail
$ns duplex-link $n(56) $n(102) 1.5Mb 230ms DropTail
$ns duplex-link $n(56) $n(100) 1.5Mb 360ms DropTail
$ns duplex-link $n(56) $n(98) 1.5Mb 520ms DropTail
$ns duplex-link $n(56) $n(96) 1.5Mb 300ms DropTail
$ns duplex-link $n(56) $n(94) 1.5Mb 300ms DropTail
if {$verbose} { puts -nonewline "1320..."; flush stdout }
$ns duplex-link $n(56) $n(86) 1.5Mb 270ms DropTail
$ns duplex-link $n(56) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(56) $n(79) 1.5Mb 260ms DropTail
$ns duplex-link $n(56) $n(75) 1.5Mb 170ms DropTail
$ns duplex-link $n(56) $n(69) 1.5Mb 170ms DropTail
$ns duplex-link $n(57) $n(146) 1.5Mb 650ms DropTail
$ns duplex-link $n(57) $n(128) 1.5Mb 470ms DropTail
$ns duplex-link $n(57) $n(118) 1.5Mb 770ms DropTail
$ns duplex-link $n(57) $n(113) 1.5Mb 80ms DropTail
$ns duplex-link $n(57) $n(106) 1.5Mb 440ms DropTail
if {$verbose} { puts -nonewline "1330..."; flush stdout }
$ns duplex-link $n(57) $n(102) 1.5Mb 400ms DropTail
$ns duplex-link $n(57) $n(95) 1.5Mb 710ms DropTail
$ns duplex-link $n(57) $n(92) 1.5Mb 840ms DropTail
$ns duplex-link $n(57) $n(91) 1.5Mb 170ms DropTail
$ns duplex-link $n(57) $n(89) 1.5Mb 400ms DropTail
$ns duplex-link $n(57) $n(85) 1.5Mb 590ms DropTail
$ns duplex-link $n(57) $n(76) 1.5Mb 470ms DropTail
$ns duplex-link $n(57) $n(72) 1.5Mb 480ms DropTail
$ns duplex-link $n(57) $n(70) 1.5Mb 640ms DropTail
$ns duplex-link $n(57) $n(64) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "1340..."; flush stdout }
$ns duplex-link $n(58) $n(147) 1.5Mb 560ms DropTail
$ns duplex-link $n(58) $n(140) 1.5Mb 750ms DropTail
$ns duplex-link $n(58) $n(134) 1.5Mb 580ms DropTail
$ns duplex-link $n(58) $n(133) 1.5Mb 620ms DropTail
$ns duplex-link $n(58) $n(131) 1.5Mb 740ms DropTail
$ns duplex-link $n(58) $n(130) 1.5Mb 160ms DropTail
$ns duplex-link $n(58) $n(128) 1.5Mb 800ms DropTail
$ns duplex-link $n(58) $n(126) 1.5Mb 380ms DropTail
$ns duplex-link $n(58) $n(125) 1.5Mb 40ms DropTail
$ns duplex-link $n(58) $n(120) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "1350..."; flush stdout }
$ns duplex-link $n(58) $n(119) 1.5Mb 840ms DropTail
$ns duplex-link $n(58) $n(117) 1.5Mb 650ms DropTail
$ns duplex-link $n(58) $n(116) 1.5Mb 1060ms DropTail
$ns duplex-link $n(58) $n(113) 1.5Mb 790ms DropTail
$ns duplex-link $n(58) $n(111) 1.5Mb 340ms DropTail
$ns duplex-link $n(58) $n(110) 1.5Mb 320ms DropTail
$ns duplex-link $n(58) $n(101) 1.5Mb 810ms DropTail
$ns duplex-link $n(58) $n(99) 1.5Mb 810ms DropTail
$ns duplex-link $n(58) $n(92) 1.5Mb 690ms DropTail
$ns duplex-link $n(58) $n(89) 1.5Mb 850ms DropTail
if {$verbose} { puts -nonewline "1360..."; flush stdout }
$ns duplex-link $n(58) $n(85) 1.5Mb 290ms DropTail
$ns duplex-link $n(58) $n(81) 1.5Mb 380ms DropTail
$ns duplex-link $n(58) $n(66) 1.5Mb 380ms DropTail
$ns duplex-link $n(59) $n(146) 1.5Mb 450ms DropTail
$ns duplex-link $n(59) $n(141) 1.5Mb 610ms DropTail
$ns duplex-link $n(59) $n(137) 1.5Mb 330ms DropTail
$ns duplex-link $n(59) $n(135) 1.5Mb 560ms DropTail
$ns duplex-link $n(59) $n(125) 1.5Mb 640ms DropTail
$ns duplex-link $n(59) $n(121) 1.5Mb 410ms DropTail
$ns duplex-link $n(59) $n(116) 1.5Mb 500ms DropTail
if {$verbose} { puts -nonewline "1370..."; flush stdout }
$ns duplex-link $n(59) $n(115) 1.5Mb 490ms DropTail
$ns duplex-link $n(59) $n(112) 1.5Mb 190ms DropTail
$ns duplex-link $n(59) $n(105) 1.5Mb 440ms DropTail
$ns duplex-link $n(59) $n(97) 1.5Mb 370ms DropTail
$ns duplex-link $n(59) $n(93) 1.5Mb 680ms DropTail
$ns duplex-link $n(59) $n(92) 1.5Mb 440ms DropTail
$ns duplex-link $n(59) $n(87) 1.5Mb 500ms DropTail
$ns duplex-link $n(59) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(59) $n(81) 1.5Mb 230ms DropTail
$ns duplex-link $n(59) $n(79) 1.5Mb 140ms DropTail
if {$verbose} { puts -nonewline "1380..."; flush stdout }
$ns duplex-link $n(59) $n(76) 1.5Mb 570ms DropTail
$ns duplex-link $n(59) $n(72) 1.5Mb 440ms DropTail
$ns duplex-link $n(60) $n(146) 1.5Mb 520ms DropTail
$ns duplex-link $n(60) $n(145) 1.5Mb 610ms DropTail
$ns duplex-link $n(60) $n(137) 1.5Mb 500ms DropTail
$ns duplex-link $n(60) $n(134) 1.5Mb 640ms DropTail
$ns duplex-link $n(60) $n(130) 1.5Mb 720ms DropTail
$ns duplex-link $n(60) $n(128) 1.5Mb 280ms DropTail
$ns duplex-link $n(60) $n(124) 1.5Mb 690ms DropTail
$ns duplex-link $n(60) $n(122) 1.5Mb 80ms DropTail
if {$verbose} { puts -nonewline "1390..."; flush stdout }
$ns duplex-link $n(60) $n(115) 1.5Mb 620ms DropTail
$ns duplex-link $n(60) $n(101) 1.5Mb 150ms DropTail
$ns duplex-link $n(60) $n(96) 1.5Mb 310ms DropTail
$ns duplex-link $n(60) $n(93) 1.5Mb 730ms DropTail
$ns duplex-link $n(60) $n(91) 1.5Mb 230ms DropTail
$ns duplex-link $n(60) $n(77) 1.5Mb 620ms DropTail
$ns duplex-link $n(60) $n(76) 1.5Mb 500ms DropTail
$ns duplex-link $n(60) $n(74) 1.5Mb 660ms DropTail
$ns duplex-link $n(60) $n(73) 1.5Mb 170ms DropTail
$ns duplex-link $n(60) $n(70) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "1400..."; flush stdout }
$ns duplex-link $n(60) $n(68) 1.5Mb 630ms DropTail
$ns duplex-link $n(61) $n(149) 1.5Mb 570ms DropTail
$ns duplex-link $n(61) $n(148) 1.5Mb 280ms DropTail
$ns duplex-link $n(61) $n(145) 1.5Mb 270ms DropTail
$ns duplex-link $n(61) $n(144) 1.5Mb 460ms DropTail
$ns duplex-link $n(61) $n(140) 1.5Mb 690ms DropTail
$ns duplex-link $n(61) $n(139) 1.5Mb 580ms DropTail
$ns duplex-link $n(61) $n(132) 1.5Mb 330ms DropTail
$ns duplex-link $n(61) $n(129) 1.5Mb 310ms DropTail
$ns duplex-link $n(61) $n(122) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "1410..."; flush stdout }
$ns duplex-link $n(61) $n(118) 1.5Mb 330ms DropTail
$ns duplex-link $n(61) $n(116) 1.5Mb 1010ms DropTail
$ns duplex-link $n(61) $n(109) 1.5Mb 280ms DropTail
$ns duplex-link $n(61) $n(103) 1.5Mb 280ms DropTail
$ns duplex-link $n(61) $n(93) 1.5Mb 120ms DropTail
$ns duplex-link $n(61) $n(89) 1.5Mb 800ms DropTail
$ns duplex-link $n(61) $n(87) 1.5Mb 60ms DropTail
$ns duplex-link $n(61) $n(82) 1.5Mb 620ms DropTail
$ns duplex-link $n(61) $n(76) 1.5Mb 440ms DropTail
$ns duplex-link $n(61) $n(73) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "1420..."; flush stdout }
$ns duplex-link $n(61) $n(70) 1.5Mb 260ms DropTail
$ns duplex-link $n(61) $n(68) 1.5Mb 170ms DropTail
$ns duplex-link $n(61) $n(64) 1.5Mb 760ms DropTail
$ns duplex-link $n(62) $n(146) 1.5Mb 190ms DropTail
$ns duplex-link $n(62) $n(145) 1.5Mb 290ms DropTail
$ns duplex-link $n(62) $n(138) 1.5Mb 590ms DropTail
$ns duplex-link $n(62) $n(128) 1.5Mb 830ms DropTail
$ns duplex-link $n(62) $n(126) 1.5Mb 370ms DropTail
$ns duplex-link $n(62) $n(119) 1.5Mb 870ms DropTail
$ns duplex-link $n(62) $n(115) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1430..."; flush stdout }
$ns duplex-link $n(62) $n(106) 1.5Mb 380ms DropTail
$ns duplex-link $n(62) $n(103) 1.5Mb 220ms DropTail
$ns duplex-link $n(62) $n(102) 1.5Mb 470ms DropTail
$ns duplex-link $n(62) $n(90) 1.5Mb 600ms DropTail
$ns duplex-link $n(62) $n(85) 1.5Mb 320ms DropTail
$ns duplex-link $n(62) $n(84) 1.5Mb 40ms DropTail
$ns duplex-link $n(62) $n(74) 1.5Mb 420ms DropTail
$ns duplex-link $n(62) $n(72) 1.5Mb 360ms DropTail
$ns duplex-link $n(62) $n(71) 1.5Mb 490ms DropTail
$ns duplex-link $n(62) $n(69) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "1440..."; flush stdout }
$ns duplex-link $n(62) $n(67) 1.5Mb 190ms DropTail
$ns duplex-link $n(62) $n(66) 1.5Mb 410ms DropTail
$ns duplex-link $n(63) $n(149) 1.5Mb 930ms DropTail
$ns duplex-link $n(63) $n(148) 1.5Mb 570ms DropTail
$ns duplex-link $n(63) $n(146) 1.5Mb 490ms DropTail
$ns duplex-link $n(63) $n(139) 1.5Mb 720ms DropTail
$ns duplex-link $n(63) $n(134) 1.5Mb 70ms DropTail
$ns duplex-link $n(63) $n(133) 1.5Mb 940ms DropTail
$ns duplex-link $n(63) $n(129) 1.5Mb 480ms DropTail
$ns duplex-link $n(63) $n(120) 1.5Mb 820ms DropTail
if {$verbose} { puts -nonewline "1450..."; flush stdout }
$ns duplex-link $n(63) $n(118) 1.5Mb 750ms DropTail
$ns duplex-link $n(63) $n(115) 1.5Mb 750ms DropTail
$ns duplex-link $n(63) $n(106) 1.5Mb 310ms DropTail
$ns duplex-link $n(63) $n(105) 1.5Mb 820ms DropTail
$ns duplex-link $n(63) $n(95) 1.5Mb 610ms DropTail
$ns duplex-link $n(63) $n(89) 1.5Mb 820ms DropTail
$ns duplex-link $n(63) $n(85) 1.5Mb 550ms DropTail
$ns duplex-link $n(63) $n(83) 1.5Mb 390ms DropTail
$ns duplex-link $n(63) $n(71) 1.5Mb 300ms DropTail
$ns duplex-link $n(63) $n(68) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1460..."; flush stdout }
$ns duplex-link $n(63) $n(64) 1.5Mb 880ms DropTail
$ns duplex-link $n(64) $n(139) 1.5Mb 190ms DropTail
$ns duplex-link $n(64) $n(117) 1.5Mb 270ms DropTail
$ns duplex-link $n(64) $n(114) 1.5Mb 900ms DropTail
$ns duplex-link $n(64) $n(108) 1.5Mb 440ms DropTail
$ns duplex-link $n(64) $n(95) 1.5Mb 620ms DropTail
$ns duplex-link $n(64) $n(91) 1.5Mb 560ms DropTail
$ns duplex-link $n(64) $n(89) 1.5Mb 160ms DropTail
$ns duplex-link $n(64) $n(87) 1.5Mb 710ms DropTail
$ns duplex-link $n(64) $n(84) 1.5Mb 870ms DropTail
if {$verbose} { puts -nonewline "1470..."; flush stdout }
$ns duplex-link $n(64) $n(82) 1.5Mb 840ms DropTail
$ns duplex-link $n(64) $n(77) 1.5Mb 800ms DropTail
$ns duplex-link $n(64) $n(69) 1.5Mb 530ms DropTail
$ns duplex-link $n(65) $n(146) 1.5Mb 530ms DropTail
$ns duplex-link $n(65) $n(141) 1.5Mb 760ms DropTail
$ns duplex-link $n(65) $n(137) 1.5Mb 600ms DropTail
$ns duplex-link $n(65) $n(134) 1.5Mb 530ms DropTail
$ns duplex-link $n(65) $n(132) 1.5Mb 360ms DropTail
$ns duplex-link $n(65) $n(129) 1.5Mb 350ms DropTail
$ns duplex-link $n(65) $n(125) 1.5Mb 720ms DropTail
if {$verbose} { puts -nonewline "1480..."; flush stdout }
$ns duplex-link $n(65) $n(114) 1.5Mb 490ms DropTail
$ns duplex-link $n(65) $n(108) 1.5Mb 330ms DropTail
$ns duplex-link $n(65) $n(102) 1.5Mb 270ms DropTail
$ns duplex-link $n(65) $n(93) 1.5Mb 720ms DropTail
$ns duplex-link $n(65) $n(90) 1.5Mb 440ms DropTail
$ns duplex-link $n(65) $n(80) 1.5Mb 400ms DropTail
$ns duplex-link $n(65) $n(79) 1.5Mb 210ms DropTail
$ns duplex-link $n(65) $n(73) 1.5Mb 70ms DropTail
$ns duplex-link $n(65) $n(72) 1.5Mb 370ms DropTail
$ns duplex-link $n(66) $n(145) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "1490..."; flush stdout }
$ns duplex-link $n(66) $n(144) 1.5Mb 530ms DropTail
$ns duplex-link $n(66) $n(143) 1.5Mb 520ms DropTail
$ns duplex-link $n(66) $n(141) 1.5Mb 410ms DropTail
$ns duplex-link $n(66) $n(139) 1.5Mb 250ms DropTail
$ns duplex-link $n(66) $n(138) 1.5Mb 330ms DropTail
$ns duplex-link $n(66) $n(137) 1.5Mb 300ms DropTail
$ns duplex-link $n(66) $n(135) 1.5Mb 340ms DropTail
$ns duplex-link $n(66) $n(133) 1.5Mb 410ms DropTail
$ns duplex-link $n(66) $n(131) 1.5Mb 510ms DropTail
$ns duplex-link $n(66) $n(129) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "1500..."; flush stdout }
$ns duplex-link $n(66) $n(127) 1.5Mb 300ms DropTail
$ns duplex-link $n(66) $n(114) 1.5Mb 540ms DropTail
$ns duplex-link $n(66) $n(108) 1.5Mb 40ms DropTail
$ns duplex-link $n(66) $n(106) 1.5Mb 220ms DropTail
$ns duplex-link $n(66) $n(98) 1.5Mb 280ms DropTail
$ns duplex-link $n(66) $n(92) 1.5Mb 470ms DropTail
$ns duplex-link $n(66) $n(89) 1.5Mb 470ms DropTail
$ns duplex-link $n(66) $n(86) 1.5Mb 510ms DropTail
$ns duplex-link $n(66) $n(81) 1.5Mb 10ms DropTail
$ns duplex-link $n(66) $n(74) 1.5Mb 380ms DropTail
if {$verbose} { puts -nonewline "1510..."; flush stdout }
$ns duplex-link $n(66) $n(73) 1.5Mb 320ms DropTail
$ns duplex-link $n(66) $n(69) 1.5Mb 110ms DropTail
$ns duplex-link $n(66) $n(67) 1.5Mb 350ms DropTail
$ns duplex-link $n(67) $n(148) 1.5Mb 280ms DropTail
$ns duplex-link $n(67) $n(140) 1.5Mb 770ms DropTail
$ns duplex-link $n(67) $n(130) 1.5Mb 50ms DropTail
$ns duplex-link $n(67) $n(120) 1.5Mb 480ms DropTail
$ns duplex-link $n(67) $n(119) 1.5Mb 710ms DropTail
$ns duplex-link $n(67) $n(106) 1.5Mb 430ms DropTail
$ns duplex-link $n(67) $n(101) 1.5Mb 790ms DropTail
if {$verbose} { puts -nonewline "1520..."; flush stdout }
$ns duplex-link $n(67) $n(95) 1.5Mb 130ms DropTail
$ns duplex-link $n(67) $n(90) 1.5Mb 480ms DropTail
$ns duplex-link $n(67) $n(84) 1.5Mb 190ms DropTail
$ns duplex-link $n(67) $n(83) 1.5Mb 760ms DropTail
$ns duplex-link $n(67) $n(71) 1.5Mb 530ms DropTail
$ns duplex-link $n(67) $n(70) 1.5Mb 430ms DropTail
$ns duplex-link $n(68) $n(148) 1.5Mb 390ms DropTail
$ns duplex-link $n(68) $n(147) 1.5Mb 590ms DropTail
$ns duplex-link $n(68) $n(143) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(139) 1.5Mb 650ms DropTail
if {$verbose} { puts -nonewline "1530..."; flush stdout }
$ns duplex-link $n(68) $n(136) 1.5Mb 390ms DropTail
$ns duplex-link $n(68) $n(132) 1.5Mb 390ms DropTail
$ns duplex-link $n(68) $n(129) 1.5Mb 360ms DropTail
$ns duplex-link $n(68) $n(116) 1.5Mb 1000ms DropTail
$ns duplex-link $n(68) $n(107) 1.5Mb 600ms DropTail
$ns duplex-link $n(68) $n(104) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(90) 1.5Mb 620ms DropTail
$ns duplex-link $n(68) $n(85) 1.5Mb 350ms DropTail
$ns duplex-link $n(68) $n(83) 1.5Mb 590ms DropTail
$ns duplex-link $n(68) $n(78) 1.5Mb 400ms DropTail
if {$verbose} { puts -nonewline "1540..."; flush stdout }
$ns duplex-link $n(69) $n(149) 1.5Mb 520ms DropTail
$ns duplex-link $n(69) $n(148) 1.5Mb 160ms DropTail
$ns duplex-link $n(69) $n(143) 1.5Mb 400ms DropTail
$ns duplex-link $n(69) $n(132) 1.5Mb 100ms DropTail
$ns duplex-link $n(69) $n(131) 1.5Mb 440ms DropTail
$ns duplex-link $n(69) $n(108) 1.5Mb 90ms DropTail
$ns duplex-link $n(69) $n(96) 1.5Mb 140ms DropTail
$ns duplex-link $n(69) $n(91) 1.5Mb 320ms DropTail
$ns duplex-link $n(69) $n(79) 1.5Mb 180ms DropTail
$ns duplex-link $n(69) $n(75) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "1550..."; flush stdout }
$ns duplex-link $n(70) $n(139) 1.5Mb 660ms DropTail
$ns duplex-link $n(70) $n(134) 1.5Mb 290ms DropTail
$ns duplex-link $n(70) $n(133) 1.5Mb 790ms DropTail
$ns duplex-link $n(70) $n(130) 1.5Mb 440ms DropTail
$ns duplex-link $n(70) $n(127) 1.5Mb 650ms DropTail
$ns duplex-link $n(70) $n(123) 1.5Mb 770ms DropTail
$ns duplex-link $n(70) $n(118) 1.5Mb 550ms DropTail
$ns duplex-link $n(70) $n(105) 1.5Mb 630ms DropTail
$ns duplex-link $n(70) $n(103) 1.5Mb 500ms DropTail
$ns duplex-link $n(70) $n(93) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "1560..."; flush stdout }
$ns duplex-link $n(70) $n(83) 1.5Mb 530ms DropTail
$ns duplex-link $n(70) $n(80) 1.5Mb 660ms DropTail
$ns duplex-link $n(70) $n(79) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(77) 1.5Mb 160ms DropTail
$ns duplex-link $n(70) $n(73) 1.5Mb 480ms DropTail
$ns duplex-link $n(70) $n(72) 1.5Mb 180ms DropTail
$ns duplex-link $n(71) $n(148) 1.5Mb 330ms DropTail
$ns duplex-link $n(71) $n(147) 1.5Mb 380ms DropTail
$ns duplex-link $n(71) $n(144) 1.5Mb 330ms DropTail
$ns duplex-link $n(71) $n(139) 1.5Mb 410ms DropTail
if {$verbose} { puts -nonewline "1570..."; flush stdout }
$ns duplex-link $n(71) $n(136) 1.5Mb 470ms DropTail
$ns duplex-link $n(71) $n(134) 1.5Mb 370ms DropTail
$ns duplex-link $n(71) $n(132) 1.5Mb 250ms DropTail
$ns duplex-link $n(71) $n(127) 1.5Mb 560ms DropTail
$ns duplex-link $n(71) $n(126) 1.5Mb 330ms DropTail
$ns duplex-link $n(71) $n(123) 1.5Mb 520ms DropTail
$ns duplex-link $n(71) $n(113) 1.5Mb 340ms DropTail
$ns duplex-link $n(71) $n(92) 1.5Mb 720ms DropTail
$ns duplex-link $n(71) $n(82) 1.5Mb 310ms DropTail
$ns duplex-link $n(71) $n(73) 1.5Mb 160ms DropTail
if {$verbose} { puts -nonewline "1580..."; flush stdout }
$ns duplex-link $n(72) $n(149) 1.5Mb 670ms DropTail
$ns duplex-link $n(72) $n(144) 1.5Mb 260ms DropTail
$ns duplex-link $n(72) $n(141) 1.5Mb 500ms DropTail
$ns duplex-link $n(72) $n(139) 1.5Mb 490ms DropTail
$ns duplex-link $n(72) $n(120) 1.5Mb 570ms DropTail
$ns duplex-link $n(72) $n(116) 1.5Mb 780ms DropTail
$ns duplex-link $n(72) $n(114) 1.5Mb 280ms DropTail
$ns duplex-link $n(72) $n(97) 1.5Mb 90ms DropTail
$ns duplex-link $n(72) $n(94) 1.5Mb 310ms DropTail
$ns duplex-link $n(72) $n(91) 1.5Mb 310ms DropTail
if {$verbose} { puts -nonewline "1590..."; flush stdout }
$ns duplex-link $n(72) $n(90) 1.5Mb 490ms DropTail
$ns duplex-link $n(72) $n(88) 1.5Mb 300ms DropTail
$ns duplex-link $n(72) $n(84) 1.5Mb 390ms DropTail
$ns duplex-link $n(72) $n(79) 1.5Mb 300ms DropTail
$ns duplex-link $n(72) $n(75) 1.5Mb 220ms DropTail
$ns duplex-link $n(73) $n(145) 1.5Mb 490ms DropTail
$ns duplex-link $n(73) $n(139) 1.5Mb 370ms DropTail
$ns duplex-link $n(73) $n(135) 1.5Mb 620ms DropTail
$ns duplex-link $n(73) $n(128) 1.5Mb 440ms DropTail
$ns duplex-link $n(73) $n(127) 1.5Mb 600ms DropTail
if {$verbose} { puts -nonewline "1600..."; flush stdout }
$ns duplex-link $n(73) $n(117) 1.5Mb 230ms DropTail
$ns duplex-link $n(73) $n(115) 1.5Mb 640ms DropTail
$ns duplex-link $n(73) $n(114) 1.5Mb 430ms DropTail
$ns duplex-link $n(73) $n(112) 1.5Mb 130ms DropTail
$ns duplex-link $n(73) $n(106) 1.5Mb 260ms DropTail
$ns duplex-link $n(73) $n(100) 1.5Mb 130ms DropTail
$ns duplex-link $n(73) $n(85) 1.5Mb 410ms DropTail
$ns duplex-link $n(73) $n(79) 1.5Mb 180ms DropTail
$ns duplex-link $n(73) $n(75) 1.5Mb 290ms DropTail
$ns duplex-link $n(74) $n(149) 1.5Mb 230ms DropTail
if {$verbose} { puts -nonewline "1610..."; flush stdout }
$ns duplex-link $n(74) $n(146) 1.5Mb 360ms DropTail
$ns duplex-link $n(74) $n(143) 1.5Mb 830ms DropTail
$ns duplex-link $n(74) $n(142) 1.5Mb 40ms DropTail
$ns duplex-link $n(74) $n(138) 1.5Mb 250ms DropTail
$ns duplex-link $n(74) $n(134) 1.5Mb 890ms DropTail
$ns duplex-link $n(74) $n(130) 1.5Mb 260ms DropTail
$ns duplex-link $n(74) $n(125) 1.5Mb 400ms DropTail
$ns duplex-link $n(74) $n(124) 1.5Mb 410ms DropTail
$ns duplex-link $n(74) $n(122) 1.5Mb 610ms DropTail
$ns duplex-link $n(74) $n(121) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "1620..."; flush stdout }
$ns duplex-link $n(74) $n(120) 1.5Mb 330ms DropTail
$ns duplex-link $n(74) $n(109) 1.5Mb 580ms DropTail
$ns duplex-link $n(74) $n(104) 1.5Mb 440ms DropTail
$ns duplex-link $n(74) $n(100) 1.5Mb 780ms DropTail
$ns duplex-link $n(74) $n(94) 1.5Mb 380ms DropTail
$ns duplex-link $n(74) $n(93) 1.5Mb 480ms DropTail
$ns duplex-link $n(74) $n(83) 1.5Mb 830ms DropTail
$ns duplex-link $n(74) $n(77) 1.5Mb 490ms DropTail
$ns duplex-link $n(75) $n(142) 1.5Mb 810ms DropTail
$ns duplex-link $n(75) $n(134) 1.5Mb 190ms DropTail
if {$verbose} { puts -nonewline "1630..."; flush stdout }
$ns duplex-link $n(75) $n(132) 1.5Mb 440ms DropTail
$ns duplex-link $n(75) $n(130) 1.5Mb 680ms DropTail
$ns duplex-link $n(75) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(75) $n(126) 1.5Mb 250ms DropTail
$ns duplex-link $n(75) $n(125) 1.5Mb 580ms DropTail
$ns duplex-link $n(75) $n(120) 1.5Mb 730ms DropTail
$ns duplex-link $n(75) $n(118) 1.5Mb 700ms DropTail
$ns duplex-link $n(75) $n(114) 1.5Mb 150ms DropTail
$ns duplex-link $n(75) $n(108) 1.5Mb 420ms DropTail
$ns duplex-link $n(75) $n(105) 1.5Mb 760ms DropTail
if {$verbose} { puts -nonewline "1640..."; flush stdout }
$ns duplex-link $n(75) $n(100) 1.5Mb 390ms DropTail
$ns duplex-link $n(75) $n(99) 1.5Mb 360ms DropTail
$ns duplex-link $n(75) $n(98) 1.5Mb 690ms DropTail
$ns duplex-link $n(75) $n(91) 1.5Mb 240ms DropTail
$ns duplex-link $n(75) $n(90) 1.5Mb 640ms DropTail
$ns duplex-link $n(75) $n(78) 1.5Mb 150ms DropTail
$ns duplex-link $n(75) $n(77) 1.5Mb 430ms DropTail
$ns duplex-link $n(76) $n(149) 1.5Mb 850ms DropTail
$ns duplex-link $n(76) $n(142) 1.5Mb 770ms DropTail
$ns duplex-link $n(76) $n(141) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "1650..."; flush stdout }
$ns duplex-link $n(76) $n(133) 1.5Mb 860ms DropTail
$ns duplex-link $n(76) $n(131) 1.5Mb 340ms DropTail
$ns duplex-link $n(76) $n(130) 1.5Mb 620ms DropTail
$ns duplex-link $n(76) $n(127) 1.5Mb 730ms DropTail
$ns duplex-link $n(76) $n(126) 1.5Mb 160ms DropTail
$ns duplex-link $n(76) $n(122) 1.5Mb 550ms DropTail
$ns duplex-link $n(76) $n(119) 1.5Mb 1030ms DropTail
$ns duplex-link $n(76) $n(114) 1.5Mb 100ms DropTail
$ns duplex-link $n(76) $n(102) 1.5Mb 400ms DropTail
$ns duplex-link $n(76) $n(90) 1.5Mb 660ms DropTail
if {$verbose} { puts -nonewline "1660..."; flush stdout }
$ns duplex-link $n(76) $n(81) 1.5Mb 450ms DropTail
$ns duplex-link $n(77) $n(148) 1.5Mb 330ms DropTail
$ns duplex-link $n(77) $n(147) 1.5Mb 550ms DropTail
$ns duplex-link $n(77) $n(145) 1.5Mb 170ms DropTail
$ns duplex-link $n(77) $n(141) 1.5Mb 340ms DropTail
$ns duplex-link $n(77) $n(139) 1.5Mb 610ms DropTail
$ns duplex-link $n(77) $n(138) 1.5Mb 610ms DropTail
$ns duplex-link $n(77) $n(137) 1.5Mb 570ms DropTail
$ns duplex-link $n(77) $n(133) 1.5Mb 680ms DropTail
$ns duplex-link $n(77) $n(121) 1.5Mb 210ms DropTail
if {$verbose} { puts -nonewline "1670..."; flush stdout }
$ns duplex-link $n(77) $n(118) 1.5Mb 420ms DropTail
$ns duplex-link $n(77) $n(116) 1.5Mb 1000ms DropTail
$ns duplex-link $n(77) $n(114) 1.5Mb 410ms DropTail
$ns duplex-link $n(77) $n(109) 1.5Mb 210ms DropTail
$ns duplex-link $n(77) $n(95) 1.5Mb 270ms DropTail
$ns duplex-link $n(77) $n(93) 1.5Mb 130ms DropTail
$ns duplex-link $n(77) $n(83) 1.5Mb 610ms DropTail
$ns duplex-link $n(77) $n(80) 1.5Mb 600ms DropTail
$ns duplex-link $n(77) $n(78) 1.5Mb 460ms DropTail
$ns duplex-link $n(78) $n(132) 1.5Mb 560ms DropTail
if {$verbose} { puts -nonewline "1680..."; flush stdout }
$ns duplex-link $n(78) $n(108) 1.5Mb 540ms DropTail
$ns duplex-link $n(78) $n(101) 1.5Mb 740ms DropTail
$ns duplex-link $n(78) $n(82) 1.5Mb 140ms DropTail
$ns duplex-link $n(78) $n(79) 1.5Mb 540ms DropTail
$ns duplex-link $n(79) $n(147) 1.5Mb 190ms DropTail
$ns duplex-link $n(79) $n(143) 1.5Mb 490ms DropTail
$ns duplex-link $n(79) $n(134) 1.5Mb 580ms DropTail
$ns duplex-link $n(79) $n(133) 1.5Mb 500ms DropTail
$ns duplex-link $n(79) $n(130) 1.5Mb 560ms DropTail
$ns duplex-link $n(79) $n(118) 1.5Mb 430ms DropTail
if {$verbose} { puts -nonewline "1690..."; flush stdout }
$ns duplex-link $n(79) $n(103) 1.5Mb 720ms DropTail
$ns duplex-link $n(79) $n(101) 1.5Mb 290ms DropTail
$ns duplex-link $n(79) $n(100) 1.5Mb 250ms DropTail
$ns duplex-link $n(79) $n(93) 1.5Mb 580ms DropTail
$ns duplex-link $n(79) $n(82) 1.5Mb 500ms DropTail
$ns duplex-link $n(80) $n(149) 1.5Mb 320ms DropTail
$ns duplex-link $n(80) $n(148) 1.5Mb 270ms DropTail
$ns duplex-link $n(80) $n(147) 1.5Mb 50ms DropTail
$ns duplex-link $n(80) $n(145) 1.5Mb 670ms DropTail
$ns duplex-link $n(80) $n(135) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "1700..."; flush stdout }
$ns duplex-link $n(80) $n(130) 1.5Mb 580ms DropTail
$ns duplex-link $n(80) $n(122) 1.5Mb 210ms DropTail
$ns duplex-link $n(80) $n(115) 1.5Mb 430ms DropTail
$ns duplex-link $n(80) $n(114) 1.5Mb 750ms DropTail
$ns duplex-link $n(80) $n(113) 1.5Mb 440ms DropTail
$ns duplex-link $n(80) $n(108) 1.5Mb 250ms DropTail
$ns duplex-link $n(80) $n(107) 1.5Mb 80ms DropTail
$ns duplex-link $n(80) $n(105) 1.5Mb 360ms DropTail
$ns duplex-link $n(80) $n(103) 1.5Mb 750ms DropTail
$ns duplex-link $n(80) $n(100) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1710..."; flush stdout }
$ns duplex-link $n(80) $n(96) 1.5Mb 220ms DropTail
$ns duplex-link $n(80) $n(92) 1.5Mb 330ms DropTail
$ns duplex-link $n(80) $n(83) 1.5Mb 530ms DropTail
$ns duplex-link $n(81) $n(129) 1.5Mb 60ms DropTail
$ns duplex-link $n(81) $n(120) 1.5Mb 290ms DropTail
$ns duplex-link $n(81) $n(119) 1.5Mb 590ms DropTail
$ns duplex-link $n(81) $n(117) 1.5Mb 280ms DropTail
$ns duplex-link $n(81) $n(116) 1.5Mb 700ms DropTail
$ns duplex-link $n(81) $n(110) 1.5Mb 290ms DropTail
$ns duplex-link $n(81) $n(108) 1.5Mb 50ms DropTail
if {$verbose} { puts -nonewline "1720..."; flush stdout }
$ns duplex-link $n(81) $n(99) 1.5Mb 530ms DropTail
$ns duplex-link $n(81) $n(97) 1.5Mb 190ms DropTail
$ns duplex-link $n(81) $n(95) 1.5Mb 220ms DropTail
$ns duplex-link $n(82) $n(148) 1.5Mb 620ms DropTail
$ns duplex-link $n(82) $n(142) 1.5Mb 930ms DropTail
$ns duplex-link $n(82) $n(139) 1.5Mb 700ms DropTail
$ns duplex-link $n(82) $n(137) 1.5Mb 860ms DropTail
$ns duplex-link $n(82) $n(131) 1.5Mb 230ms DropTail
$ns duplex-link $n(82) $n(130) 1.5Mb 800ms DropTail
$ns duplex-link $n(82) $n(129) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "1730..."; flush stdout }
$ns duplex-link $n(82) $n(128) 1.5Mb 790ms DropTail
$ns duplex-link $n(82) $n(120) 1.5Mb 840ms DropTail
$ns duplex-link $n(82) $n(115) 1.5Mb 830ms DropTail
$ns duplex-link $n(82) $n(105) 1.5Mb 880ms DropTail
$ns duplex-link $n(82) $n(102) 1.5Mb 500ms DropTail
$ns duplex-link $n(82) $n(100) 1.5Mb 430ms DropTail
$ns duplex-link $n(82) $n(96) 1.5Mb 580ms DropTail
$ns duplex-link $n(82) $n(95) 1.5Mb 690ms DropTail
$ns duplex-link $n(82) $n(86) 1.5Mb 300ms DropTail
$ns duplex-link $n(82) $n(84) 1.5Mb 700ms DropTail
if {$verbose} { puts -nonewline "1740..."; flush stdout }
$ns duplex-link $n(83) $n(148) 1.5Mb 530ms DropTail
$ns duplex-link $n(83) $n(144) 1.5Mb 450ms DropTail
$ns duplex-link $n(83) $n(143) 1.5Mb 370ms DropTail
$ns duplex-link $n(83) $n(128) 1.5Mb 540ms DropTail
$ns duplex-link $n(83) $n(120) 1.5Mb 660ms DropTail
$ns duplex-link $n(83) $n(119) 1.5Mb 930ms DropTail
$ns duplex-link $n(83) $n(117) 1.5Mb 340ms DropTail
$ns duplex-link $n(83) $n(112) 1.5Mb 260ms DropTail
$ns duplex-link $n(83) $n(109) 1.5Mb 400ms DropTail
$ns duplex-link $n(83) $n(103) 1.5Mb 930ms DropTail
if {$verbose} { puts -nonewline "1750..."; flush stdout }
$ns duplex-link $n(83) $n(98) 1.5Mb 730ms DropTail
$ns duplex-link $n(83) $n(93) 1.5Mb 740ms DropTail
$ns duplex-link $n(83) $n(84) 1.5Mb 760ms DropTail
$ns duplex-link $n(84) $n(133) 1.5Mb 660ms DropTail
$ns duplex-link $n(84) $n(130) 1.5Mb 170ms DropTail
$ns duplex-link $n(84) $n(128) 1.5Mb 850ms DropTail
$ns duplex-link $n(84) $n(120) 1.5Mb 640ms DropTail
$ns duplex-link $n(84) $n(118) 1.5Mb 390ms DropTail
$ns duplex-link $n(84) $n(112) 1.5Mb 600ms DropTail
$ns duplex-link $n(84) $n(106) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1760..."; flush stdout }
$ns duplex-link $n(84) $n(101) 1.5Mb 870ms DropTail
$ns duplex-link $n(84) $n(92) 1.5Mb 730ms DropTail
$ns duplex-link $n(84) $n(89) 1.5Mb 910ms DropTail
$ns duplex-link $n(84) $n(87) 1.5Mb 170ms DropTail
$ns duplex-link $n(85) $n(148) 1.5Mb 40ms DropTail
$ns duplex-link $n(85) $n(141) 1.5Mb 310ms DropTail
$ns duplex-link $n(85) $n(139) 1.5Mb 340ms DropTail
$ns duplex-link $n(85) $n(136) 1.5Mb 160ms DropTail
$ns duplex-link $n(85) $n(127) 1.5Mb 270ms DropTail
$ns duplex-link $n(85) $n(126) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "1770..."; flush stdout }
$ns duplex-link $n(85) $n(124) 1.5Mb 310ms DropTail
$ns duplex-link $n(85) $n(120) 1.5Mb 320ms DropTail
$ns duplex-link $n(85) $n(119) 1.5Mb 610ms DropTail
$ns duplex-link $n(85) $n(116) 1.5Mb 800ms DropTail
$ns duplex-link $n(85) $n(107) 1.5Mb 300ms DropTail
$ns duplex-link $n(85) $n(103) 1.5Mb 460ms DropTail
$ns duplex-link $n(85) $n(101) 1.5Mb 540ms DropTail
$ns duplex-link $n(85) $n(91) 1.5Mb 470ms DropTail
$ns duplex-link $n(86) $n(149) 1.5Mb 890ms DropTail
$ns duplex-link $n(86) $n(148) 1.5Mb 530ms DropTail
if {$verbose} { puts -nonewline "1780..."; flush stdout }
$ns duplex-link $n(86) $n(136) 1.5Mb 590ms DropTail
$ns duplex-link $n(86) $n(134) 1.5Mb 150ms DropTail
$ns duplex-link $n(86) $n(133) 1.5Mb 910ms DropTail
$ns duplex-link $n(86) $n(127) 1.5Mb 770ms DropTail
$ns duplex-link $n(86) $n(120) 1.5Mb 800ms DropTail
$ns duplex-link $n(86) $n(117) 1.5Mb 660ms DropTail
$ns duplex-link $n(86) $n(114) 1.5Mb 130ms DropTail
$ns duplex-link $n(86) $n(105) 1.5Mb 760ms DropTail
$ns duplex-link $n(87) $n(143) 1.5Mb 480ms DropTail
$ns duplex-link $n(87) $n(139) 1.5Mb 520ms DropTail
if {$verbose} { puts -nonewline "1790..."; flush stdout }
$ns duplex-link $n(87) $n(137) 1.5Mb 460ms DropTail
$ns duplex-link $n(87) $n(135) 1.5Mb 130ms DropTail
$ns duplex-link $n(87) $n(134) 1.5Mb 530ms DropTail
$ns duplex-link $n(87) $n(130) 1.5Mb 210ms DropTail
$ns duplex-link $n(87) $n(124) 1.5Mb 130ms DropTail
$ns duplex-link $n(87) $n(123) 1.5Mb 630ms DropTail
$ns duplex-link $n(87) $n(118) 1.5Mb 310ms DropTail
$ns duplex-link $n(87) $n(95) 1.5Mb 150ms DropTail
$ns duplex-link $n(87) $n(90) 1.5Mb 470ms DropTail
$ns duplex-link $n(87) $n(88) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1800..."; flush stdout }
$ns duplex-link $n(88) $n(149) 1.5Mb 440ms DropTail
$ns duplex-link $n(88) $n(146) 1.5Mb 300ms DropTail
$ns duplex-link $n(88) $n(123) 1.5Mb 310ms DropTail
$ns duplex-link $n(88) $n(122) 1.5Mb 200ms DropTail
$ns duplex-link $n(88) $n(121) 1.5Mb 270ms DropTail
$ns duplex-link $n(88) $n(115) 1.5Mb 400ms DropTail
$ns duplex-link $n(88) $n(110) 1.5Mb 370ms DropTail
$ns duplex-link $n(88) $n(107) 1.5Mb 140ms DropTail
$ns duplex-link $n(88) $n(94) 1.5Mb 60ms DropTail
$ns duplex-link $n(88) $n(92) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "1810..."; flush stdout }
$ns duplex-link $n(89) $n(143) 1.5Mb 800ms DropTail
$ns duplex-link $n(89) $n(142) 1.5Mb 770ms DropTail
$ns duplex-link $n(89) $n(141) 1.5Mb 850ms DropTail
$ns duplex-link $n(89) $n(131) 1.5Mb 560ms DropTail
$ns duplex-link $n(89) $n(128) 1.5Mb 110ms DropTail
$ns duplex-link $n(89) $n(125) 1.5Mb 890ms DropTail
$ns duplex-link $n(89) $n(121) 1.5Mb 650ms DropTail
$ns duplex-link $n(89) $n(118) 1.5Mb 650ms DropTail
$ns duplex-link $n(89) $n(114) 1.5Mb 840ms DropTail
$ns duplex-link $n(89) $n(102) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1820..."; flush stdout }
$ns duplex-link $n(89) $n(100) 1.5Mb 340ms DropTail
$ns duplex-link $n(90) $n(147) 1.5Mb 70ms DropTail
$ns duplex-link $n(90) $n(140) 1.5Mb 480ms DropTail
$ns duplex-link $n(90) $n(139) 1.5Mb 110ms DropTail
$ns duplex-link $n(90) $n(137) 1.5Mb 170ms DropTail
$ns duplex-link $n(90) $n(135) 1.5Mb 490ms DropTail
$ns duplex-link $n(90) $n(134) 1.5Mb 810ms DropTail
$ns duplex-link $n(90) $n(128) 1.5Mb 260ms DropTail
$ns duplex-link $n(90) $n(124) 1.5Mb 590ms DropTail
$ns duplex-link $n(90) $n(122) 1.5Mb 260ms DropTail
if {$verbose} { puts -nonewline "1830..."; flush stdout }
$ns duplex-link $n(90) $n(121) 1.5Mb 370ms DropTail
$ns duplex-link $n(90) $n(100) 1.5Mb 460ms DropTail
$ns duplex-link $n(90) $n(95) 1.5Mb 360ms DropTail
$ns duplex-link $n(91) $n(148) 1.5Mb 460ms DropTail
$ns duplex-link $n(91) $n(144) 1.5Mb 420ms DropTail
$ns duplex-link $n(91) $n(143) 1.5Mb 350ms DropTail
$ns duplex-link $n(91) $n(134) 1.5Mb 430ms DropTail
$ns duplex-link $n(91) $n(132) 1.5Mb 370ms DropTail
$ns duplex-link $n(91) $n(128) 1.5Mb 510ms DropTail
$ns duplex-link $n(91) $n(127) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "1840..."; flush stdout }
$ns duplex-link $n(91) $n(119) 1.5Mb 880ms DropTail
$ns duplex-link $n(91) $n(106) 1.5Mb 280ms DropTail
$ns duplex-link $n(91) $n(105) 1.5Mb 710ms DropTail
$ns duplex-link $n(91) $n(96) 1.5Mb 390ms DropTail
$ns duplex-link $n(92) $n(148) 1.5Mb 430ms DropTail
$ns duplex-link $n(92) $n(147) 1.5Mb 360ms DropTail
$ns duplex-link $n(92) $n(141) 1.5Mb 540ms DropTail
$ns duplex-link $n(92) $n(135) 1.5Mb 580ms DropTail
$ns duplex-link $n(92) $n(134) 1.5Mb 1060ms DropTail
$ns duplex-link $n(92) $n(132) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "1850..."; flush stdout }
$ns duplex-link $n(92) $n(127) 1.5Mb 210ms DropTail
$ns duplex-link $n(92) $n(122) 1.5Mb 540ms DropTail
$ns duplex-link $n(92) $n(117) 1.5Mb 530ms DropTail
$ns duplex-link $n(92) $n(115) 1.5Mb 390ms DropTail
$ns duplex-link $n(92) $n(114) 1.5Mb 1010ms DropTail
$ns duplex-link $n(92) $n(111) 1.5Mb 390ms DropTail
$ns duplex-link $n(92) $n(107) 1.5Mb 410ms DropTail
$ns duplex-link $n(92) $n(103) 1.5Mb 730ms DropTail
$ns duplex-link $n(92) $n(101) 1.5Mb 620ms DropTail
$ns duplex-link $n(92) $n(99) 1.5Mb 890ms DropTail
if {$verbose} { puts -nonewline "1860..."; flush stdout }
$ns duplex-link $n(92) $n(97) 1.5Mb 640ms DropTail
$ns duplex-link $n(93) $n(147) 1.5Mb 630ms DropTail
$ns duplex-link $n(93) $n(145) 1.5Mb 270ms DropTail
$ns duplex-link $n(93) $n(144) 1.5Mb 470ms DropTail
$ns duplex-link $n(93) $n(139) 1.5Mb 700ms DropTail
$ns duplex-link $n(93) $n(132) 1.5Mb 450ms DropTail
$ns duplex-link $n(93) $n(121) 1.5Mb 270ms DropTail
$ns duplex-link $n(93) $n(119) 1.5Mb 930ms DropTail
$ns duplex-link $n(93) $n(100) 1.5Mb 780ms DropTail
$ns duplex-link $n(93) $n(97) 1.5Mb 350ms DropTail
if {$verbose} { puts -nonewline "1870..."; flush stdout }
$ns duplex-link $n(93) $n(94) 1.5Mb 490ms DropTail
$ns duplex-link $n(94) $n(133) 1.5Mb 390ms DropTail
$ns duplex-link $n(94) $n(116) 1.5Mb 670ms DropTail
$ns duplex-link $n(94) $n(107) 1.5Mb 160ms DropTail
$ns duplex-link $n(94) $n(105) 1.5Mb 330ms DropTail
$ns duplex-link $n(94) $n(104) 1.5Mb 110ms DropTail
$ns duplex-link $n(94) $n(99) 1.5Mb 510ms DropTail
$ns duplex-link $n(94) $n(96) 1.5Mb 20ms DropTail
$ns duplex-link $n(95) $n(136) 1.5Mb 60ms DropTail
$ns duplex-link $n(95) $n(133) 1.5Mb 420ms DropTail
if {$verbose} { puts -nonewline "1880..."; flush stdout }
$ns duplex-link $n(95) $n(130) 1.5Mb 180ms DropTail
$ns duplex-link $n(95) $n(125) 1.5Mb 230ms DropTail
$ns duplex-link $n(95) $n(124) 1.5Mb 230ms DropTail
$ns duplex-link $n(95) $n(115) 1.5Mb 140ms DropTail
$ns duplex-link $n(95) $n(114) 1.5Mb 610ms DropTail
$ns duplex-link $n(95) $n(113) 1.5Mb 680ms DropTail
$ns duplex-link $n(95) $n(110) 1.5Mb 140ms DropTail
$ns duplex-link $n(95) $n(106) 1.5Mb 330ms DropTail
$ns duplex-link $n(95) $n(102) 1.5Mb 310ms DropTail
$ns duplex-link $n(96) $n(149) 1.5Mb 390ms DropTail
if {$verbose} { puts -nonewline "1890..."; flush stdout }
$ns duplex-link $n(96) $n(148) 1.5Mb 90ms DropTail
$ns duplex-link $n(96) $n(146) 1.5Mb 240ms DropTail
$ns duplex-link $n(96) $n(145) 1.5Mb 450ms DropTail
$ns duplex-link $n(96) $n(135) 1.5Mb 350ms DropTail
$ns duplex-link $n(96) $n(133) 1.5Mb 390ms DropTail
$ns duplex-link $n(96) $n(125) 1.5Mb 430ms DropTail
$ns duplex-link $n(96) $n(121) 1.5Mb 200ms DropTail
$ns duplex-link $n(96) $n(119) 1.5Mb 570ms DropTail
$ns duplex-link $n(96) $n(112) 1.5Mb 200ms DropTail
$ns duplex-link $n(96) $n(110) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "1900..."; flush stdout }
$ns duplex-link $n(96) $n(100) 1.5Mb 410ms DropTail
$ns duplex-link $n(96) $n(98) 1.5Mb 270ms DropTail
$ns duplex-link $n(97) $n(145) 1.5Mb 250ms DropTail
$ns duplex-link $n(97) $n(134) 1.5Mb 420ms DropTail
$ns duplex-link $n(97) $n(128) 1.5Mb 570ms DropTail
$ns duplex-link $n(97) $n(126) 1.5Mb 300ms DropTail
$ns duplex-link $n(97) $n(122) 1.5Mb 390ms DropTail
$ns duplex-link $n(97) $n(121) 1.5Mb 180ms DropTail
$ns duplex-link $n(97) $n(120) 1.5Mb 480ms DropTail
$ns duplex-link $n(97) $n(119) 1.5Mb 770ms DropTail
if {$verbose} { puts -nonewline "1910..."; flush stdout }
$ns duplex-link $n(97) $n(114) 1.5Mb 370ms DropTail
$ns duplex-link $n(97) $n(112) 1.5Mb 240ms DropTail
$ns duplex-link $n(97) $n(107) 1.5Mb 360ms DropTail
$ns duplex-link $n(97) $n(104) 1.5Mb 110ms DropTail
$ns duplex-link $n(98) $n(146) 1.5Mb 270ms DropTail
$ns duplex-link $n(98) $n(145) 1.5Mb 560ms DropTail
$ns duplex-link $n(98) $n(137) 1.5Mb 200ms DropTail
$ns duplex-link $n(98) $n(118) 1.5Mb 10ms DropTail
$ns duplex-link $n(98) $n(111) 1.5Mb 100ms DropTail
$ns duplex-link $n(98) $n(108) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "1920..."; flush stdout }
$ns duplex-link $n(98) $n(105) 1.5Mb 90ms DropTail
$ns duplex-link $n(99) $n(146) 1.5Mb 670ms DropTail
$ns duplex-link $n(99) $n(136) 1.5Mb 770ms DropTail
$ns duplex-link $n(99) $n(118) 1.5Mb 800ms DropTail
$ns duplex-link $n(99) $n(114) 1.5Mb 510ms DropTail
$ns duplex-link $n(99) $n(105) 1.5Mb 840ms DropTail
$ns duplex-link $n(99) $n(103) 1.5Mb 1030ms DropTail
$ns duplex-link $n(99) $n(102) 1.5Mb 430ms DropTail
$ns duplex-link $n(100) $n(148) 1.5Mb 490ms DropTail
$ns duplex-link $n(100) $n(138) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "1930..."; flush stdout }
$ns duplex-link $n(100) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(100) $n(128) 1.5Mb 400ms DropTail
$ns duplex-link $n(100) $n(110) 1.5Mb 700ms DropTail
$ns duplex-link $n(101) $n(145) 1.5Mb 760ms DropTail
$ns duplex-link $n(101) $n(142) 1.5Mb 780ms DropTail
$ns duplex-link $n(101) $n(139) 1.5Mb 270ms DropTail
$ns duplex-link $n(101) $n(138) 1.5Mb 550ms DropTail
$ns duplex-link $n(101) $n(135) 1.5Mb 770ms DropTail
$ns duplex-link $n(101) $n(130) 1.5Mb 830ms DropTail
$ns duplex-link $n(101) $n(105) 1.5Mb 670ms DropTail
if {$verbose} { puts -nonewline "1940..."; flush stdout }
$ns duplex-link $n(101) $n(104) 1.5Mb 440ms DropTail
$ns duplex-link $n(102) $n(141) 1.5Mb 500ms DropTail
$ns duplex-link $n(102) $n(137) 1.5Mb 370ms DropTail
$ns duplex-link $n(102) $n(131) 1.5Mb 420ms DropTail
$ns duplex-link $n(102) $n(125) 1.5Mb 480ms DropTail
$ns duplex-link $n(102) $n(124) 1.5Mb 460ms DropTail
$ns duplex-link $n(102) $n(123) 1.5Mb 350ms DropTail
$ns duplex-link $n(102) $n(122) 1.5Mb 220ms DropTail
$ns duplex-link $n(102) $n(121) 1.5Mb 250ms DropTail
$ns duplex-link $n(102) $n(118) 1.5Mb 370ms DropTail
if {$verbose} { puts -nonewline "1950..."; flush stdout }
$ns duplex-link $n(102) $n(113) 1.5Mb 370ms DropTail
$ns duplex-link $n(103) $n(141) 1.5Mb 190ms DropTail
$ns duplex-link $n(103) $n(137) 1.5Mb 600ms DropTail
$ns duplex-link $n(103) $n(136) 1.5Mb 340ms DropTail
$ns duplex-link $n(103) $n(132) 1.5Mb 570ms DropTail
$ns duplex-link $n(103) $n(128) 1.5Mb 950ms DropTail
$ns duplex-link $n(103) $n(125) 1.5Mb 200ms DropTail
$ns duplex-link $n(103) $n(115) 1.5Mb 350ms DropTail
$ns duplex-link $n(103) $n(110) 1.5Mb 370ms DropTail
$ns duplex-link $n(103) $n(106) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "1960..."; flush stdout }
$ns duplex-link $n(103) $n(104) 1.5Mb 570ms DropTail
$ns duplex-link $n(104) $n(149) 1.5Mb 490ms DropTail
$ns duplex-link $n(104) $n(147) 1.5Mb 250ms DropTail
$ns duplex-link $n(104) $n(146) 1.5Mb 210ms DropTail
$ns duplex-link $n(104) $n(142) 1.5Mb 470ms DropTail
$ns duplex-link $n(104) $n(138) 1.5Mb 410ms DropTail
$ns duplex-link $n(104) $n(136) 1.5Mb 300ms DropTail
$ns duplex-link $n(104) $n(131) 1.5Mb 450ms DropTail
$ns duplex-link $n(104) $n(130) 1.5Mb 420ms DropTail
$ns duplex-link $n(104) $n(128) 1.5Mb 460ms DropTail
if {$verbose} { puts -nonewline "1970..."; flush stdout }
$ns duplex-link $n(104) $n(126) 1.5Mb 410ms DropTail
$ns duplex-link $n(104) $n(124) 1.5Mb 390ms DropTail
$ns duplex-link $n(104) $n(119) 1.5Mb 670ms DropTail
$ns duplex-link $n(104) $n(114) 1.5Mb 470ms DropTail
$ns duplex-link $n(104) $n(112) 1.5Mb 170ms DropTail
$ns duplex-link $n(104) $n(111) 1.5Mb 430ms DropTail
$ns duplex-link $n(105) $n(149) 1.5Mb 170ms DropTail
$ns duplex-link $n(105) $n(147) 1.5Mb 350ms DropTail
$ns duplex-link $n(105) $n(143) 1.5Mb 810ms DropTail
$ns duplex-link $n(105) $n(140) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "1980..."; flush stdout }
$ns duplex-link $n(105) $n(139) 1.5Mb 410ms DropTail
$ns duplex-link $n(105) $n(137) 1.5Mb 150ms DropTail
$ns duplex-link $n(105) $n(135) 1.5Mb 320ms DropTail
$ns duplex-link $n(105) $n(134) 1.5Mb 880ms DropTail
$ns duplex-link $n(105) $n(131) 1.5Mb 840ms DropTail
$ns duplex-link $n(105) $n(124) 1.5Mb 440ms DropTail
$ns duplex-link $n(105) $n(122) 1.5Mb 540ms DropTail
$ns duplex-link $n(105) $n(120) 1.5Mb 260ms DropTail
$ns duplex-link $n(105) $n(117) 1.5Mb 530ms DropTail
$ns duplex-link $n(105) $n(110) 1.5Mb 110ms DropTail
if {$verbose} { puts -nonewline "1990..."; flush stdout }
$ns duplex-link $n(106) $n(126) 1.5Mb 280ms DropTail
$ns duplex-link $n(106) $n(120) 1.5Mb 510ms DropTail
$ns duplex-link $n(106) $n(119) 1.5Mb 810ms DropTail
$ns duplex-link $n(106) $n(118) 1.5Mb 450ms DropTail
$ns duplex-link $n(106) $n(116) 1.5Mb 730ms DropTail
$ns duplex-link $n(106) $n(108) 1.5Mb 190ms DropTail
$ns duplex-link $n(106) $n(107) 1.5Mb 380ms DropTail
$ns duplex-link $n(107) $n(149) 1.5Mb 390ms DropTail
$ns duplex-link $n(107) $n(146) 1.5Mb 430ms DropTail
$ns duplex-link $n(107) $n(145) 1.5Mb 620ms DropTail
if {$verbose} { puts -nonewline "2000..."; flush stdout }
$ns duplex-link $n(107) $n(143) 1.5Mb 650ms DropTail
$ns duplex-link $n(107) $n(128) 1.5Mb 210ms DropTail
$ns duplex-link $n(107) $n(127) 1.5Mb 330ms DropTail
$ns duplex-link $n(107) $n(122) 1.5Mb 140ms DropTail
$ns duplex-link $n(107) $n(119) 1.5Mb 480ms DropTail
$ns duplex-link $n(107) $n(115) 1.5Mb 450ms DropTail
$ns duplex-link $n(107) $n(109) 1.5Mb 460ms DropTail
$ns duplex-link $n(108) $n(147) 1.5Mb 200ms DropTail
$ns duplex-link $n(108) $n(145) 1.5Mb 420ms DropTail
$ns duplex-link $n(108) $n(138) 1.5Mb 360ms DropTail
if {$verbose} { puts -nonewline "2010..."; flush stdout }
$ns duplex-link $n(108) $n(137) 1.5Mb 340ms DropTail
$ns duplex-link $n(108) $n(136) 1.5Mb 290ms DropTail
$ns duplex-link $n(108) $n(131) 1.5Mb 470ms DropTail
$ns duplex-link $n(108) $n(130) 1.5Mb 430ms DropTail
$ns duplex-link $n(108) $n(127) 1.5Mb 340ms DropTail
$ns duplex-link $n(108) $n(123) 1.5Mb 360ms DropTail
$ns duplex-link $n(108) $n(118) 1.5Mb 320ms DropTail
$ns duplex-link $n(108) $n(114) 1.5Mb 520ms DropTail
$ns duplex-link $n(109) $n(149) 1.5Mb 680ms DropTail
$ns duplex-link $n(109) $n(148) 1.5Mb 320ms DropTail
if {$verbose} { puts -nonewline "2020..."; flush stdout }
$ns duplex-link $n(109) $n(145) 1.5Mb 160ms DropTail
$ns duplex-link $n(109) $n(139) 1.5Mb 520ms DropTail
$ns duplex-link $n(109) $n(138) 1.5Mb 610ms DropTail
$ns duplex-link $n(109) $n(134) 1.5Mb 320ms DropTail
$ns duplex-link $n(109) $n(133) 1.5Mb 690ms DropTail
$ns duplex-link $n(109) $n(130) 1.5Mb 450ms DropTail
$ns duplex-link $n(109) $n(127) 1.5Mb 560ms DropTail
$ns duplex-link $n(109) $n(126) 1.5Mb 190ms DropTail
$ns duplex-link $n(109) $n(122) 1.5Mb 470ms DropTail
$ns duplex-link $n(109) $n(120) 1.5Mb 590ms DropTail
if {$verbose} { puts -nonewline "2030..."; flush stdout }
$ns duplex-link $n(109) $n(114) 1.5Mb 270ms DropTail
$ns duplex-link $n(110) $n(133) 1.5Mb 310ms DropTail
$ns duplex-link $n(110) $n(132) 1.5Mb 300ms DropTail
$ns duplex-link $n(110) $n(130) 1.5Mb 210ms DropTail
$ns duplex-link $n(110) $n(121) 1.5Mb 220ms DropTail
$ns duplex-link $n(111) $n(138) 1.5Mb 300ms DropTail
$ns duplex-link $n(111) $n(124) 1.5Mb 360ms DropTail
$ns duplex-link $n(111) $n(123) 1.5Mb 570ms DropTail
$ns duplex-link $n(111) $n(122) 1.5Mb 630ms DropTail
$ns duplex-link $n(111) $n(121) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "2040..."; flush stdout }
$ns duplex-link $n(111) $n(120) 1.5Mb 380ms DropTail
$ns duplex-link $n(112) $n(140) 1.5Mb 230ms DropTail
$ns duplex-link $n(112) $n(132) 1.5Mb 190ms DropTail
$ns duplex-link $n(112) $n(128) 1.5Mb 370ms DropTail
$ns duplex-link $n(112) $n(127) 1.5Mb 470ms DropTail
$ns duplex-link $n(112) $n(122) 1.5Mb 160ms DropTail
$ns duplex-link $n(113) $n(145) 1.5Mb 670ms DropTail
$ns duplex-link $n(113) $n(140) 1.5Mb 50ms DropTail
$ns duplex-link $n(113) $n(134) 1.5Mb 630ms DropTail
$ns duplex-link $n(113) $n(124) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "2050..."; flush stdout }
$ns duplex-link $n(113) $n(123) 1.5Mb 450ms DropTail
$ns duplex-link $n(113) $n(120) 1.5Mb 580ms DropTail
$ns duplex-link $n(114) $n(147) 1.5Mb 700ms DropTail
$ns duplex-link $n(114) $n(143) 1.5Mb 40ms DropTail
$ns duplex-link $n(114) $n(135) 1.5Mb 610ms DropTail
$ns duplex-link $n(114) $n(131) 1.5Mb 380ms DropTail
$ns duplex-link $n(114) $n(130) 1.5Mb 690ms DropTail
$ns duplex-link $n(114) $n(122) 1.5Mb 640ms DropTail
$ns duplex-link $n(114) $n(121) 1.5Mb 520ms DropTail
$ns duplex-link $n(114) $n(117) 1.5Mb 640ms DropTail
if {$verbose} { puts -nonewline "2060..."; flush stdout }
$ns duplex-link $n(115) $n(149) 1.5Mb 290ms DropTail
$ns duplex-link $n(115) $n(143) 1.5Mb 740ms DropTail
$ns duplex-link $n(115) $n(131) 1.5Mb 820ms DropTail
$ns duplex-link $n(115) $n(129) 1.5Mb 340ms DropTail
$ns duplex-link $n(116) $n(147) 1.5Mb 580ms DropTail
$ns duplex-link $n(116) $n(144) 1.5Mb 920ms DropTail
$ns duplex-link $n(116) $n(138) 1.5Mb 800ms DropTail
$ns duplex-link $n(116) $n(137) 1.5Mb 810ms DropTail
$ns duplex-link $n(116) $n(134) 1.5Mb 920ms DropTail
$ns duplex-link $n(116) $n(124) 1.5Mb 1080ms DropTail
if {$verbose} { puts -nonewline "2070..."; flush stdout }
$ns duplex-link $n(116) $n(122) 1.5Mb 410ms DropTail
$ns duplex-link $n(116) $n(119) 1.5Mb 850ms DropTail
$ns duplex-link $n(117) $n(141) 1.5Mb 670ms DropTail
$ns duplex-link $n(117) $n(140) 1.5Mb 240ms DropTail
$ns duplex-link $n(117) $n(138) 1.5Mb 430ms DropTail
$ns duplex-link $n(117) $n(134) 1.5Mb 680ms DropTail
$ns duplex-link $n(117) $n(132) 1.5Mb 270ms DropTail
$ns duplex-link $n(117) $n(130) 1.5Mb 670ms DropTail
$ns duplex-link $n(117) $n(125) 1.5Mb 680ms DropTail
$ns duplex-link $n(117) $n(122) 1.5Mb 10ms DropTail
if {$verbose} { puts -nonewline "2080..."; flush stdout }
$ns duplex-link $n(117) $n(121) 1.5Mb 450ms DropTail
$ns duplex-link $n(117) $n(118) 1.5Mb 510ms DropTail
$ns duplex-link $n(118) $n(149) 1.5Mb 240ms DropTail
$ns duplex-link $n(118) $n(139) 1.5Mb 400ms DropTail
$ns duplex-link $n(118) $n(138) 1.5Mb 220ms DropTail
$ns duplex-link $n(118) $n(137) 1.5Mb 190ms DropTail
$ns duplex-link $n(118) $n(130) 1.5Mb 250ms DropTail
$ns duplex-link $n(118) $n(129) 1.5Mb 310ms DropTail
$ns duplex-link $n(119) $n(147) 1.5Mb 450ms DropTail
$ns duplex-link $n(119) $n(146) 1.5Mb 740ms DropTail
if {$verbose} { puts -nonewline "2090..."; flush stdout }
$ns duplex-link $n(119) $n(143) 1.5Mb 1100ms DropTail
$ns duplex-link $n(119) $n(133) 1.5Mb 220ms DropTail
$ns duplex-link $n(119) $n(130) 1.5Mb 740ms DropTail
$ns duplex-link $n(119) $n(128) 1.5Mb 440ms DropTail
$ns duplex-link $n(119) $n(127) 1.5Mb 370ms DropTail
$ns duplex-link $n(120) $n(141) 1.5Mb 500ms DropTail
$ns duplex-link $n(120) $n(135) 1.5Mb 500ms DropTail
$ns duplex-link $n(120) $n(134) 1.5Mb 890ms DropTail
$ns duplex-link $n(120) $n(126) 1.5Mb 770ms DropTail
$ns duplex-link $n(120) $n(124) 1.5Mb 610ms DropTail
if {$verbose} { puts -nonewline "2100..."; flush stdout }
$ns duplex-link $n(120) $n(123) 1.5Mb 200ms DropTail
$ns duplex-link $n(121) $n(149) 1.5Mb 450ms DropTail
$ns duplex-link $n(121) $n(145) 1.5Mb 330ms DropTail
$ns duplex-link $n(121) $n(139) 1.5Mb 420ms DropTail
$ns duplex-link $n(121) $n(135) 1.5Mb 160ms DropTail
$ns duplex-link $n(121) $n(134) 1.5Mb 570ms DropTail
$ns duplex-link $n(121) $n(133) 1.5Mb 480ms DropTail
$ns duplex-link $n(121) $n(131) 1.5Mb 610ms DropTail
$ns duplex-link $n(121) $n(129) 1.5Mb 170ms DropTail
$ns duplex-link $n(121) $n(127) 1.5Mb 330ms DropTail
if {$verbose} { puts -nonewline "2110..."; flush stdout }
$ns duplex-link $n(121) $n(125) 1.5Mb 230ms DropTail
$ns duplex-link $n(122) $n(149) 1.5Mb 530ms DropTail
$ns duplex-link $n(122) $n(146) 1.5Mb 500ms DropTail
$ns duplex-link $n(122) $n(140) 1.5Mb 230ms DropTail
$ns duplex-link $n(123) $n(145) 1.5Mb 780ms DropTail
$ns duplex-link $n(123) $n(140) 1.5Mb 460ms DropTail
$ns duplex-link $n(123) $n(139) 1.5Mb 110ms DropTail
$ns duplex-link $n(123) $n(136) 1.5Mb 520ms DropTail
$ns duplex-link $n(123) $n(135) 1.5Mb 650ms DropTail
$ns duplex-link $n(123) $n(133) 1.5Mb 340ms DropTail
if {$verbose} { puts -nonewline "2120..."; flush stdout }
$ns duplex-link $n(123) $n(131) 1.5Mb 650ms DropTail
$ns duplex-link $n(124) $n(149) 1.5Mb 610ms DropTail
$ns duplex-link $n(124) $n(144) 1.5Mb 490ms DropTail
$ns duplex-link $n(124) $n(142) 1.5Mb 410ms DropTail
$ns duplex-link $n(124) $n(139) 1.5Mb 650ms DropTail
$ns duplex-link $n(124) $n(138) 1.5Mb 580ms DropTail
$ns duplex-link $n(124) $n(135) 1.5Mb 130ms DropTail
$ns duplex-link $n(124) $n(132) 1.5Mb 400ms DropTail
$ns duplex-link $n(124) $n(129) 1.5Mb 380ms DropTail
$ns duplex-link $n(124) $n(125) 1.5Mb 30ms DropTail
if {$verbose} { puts -nonewline "2130..."; flush stdout }
$ns duplex-link $n(125) $n(144) 1.5Mb 520ms DropTail
$ns duplex-link $n(125) $n(141) 1.5Mb 210ms DropTail
$ns duplex-link $n(125) $n(129) 1.5Mb 400ms DropTail
$ns duplex-link $n(125) $n(128) 1.5Mb 830ms DropTail
$ns duplex-link $n(126) $n(144) 1.5Mb 120ms DropTail
$ns duplex-link $n(126) $n(142) 1.5Mb 730ms DropTail
$ns duplex-link $n(126) $n(140) 1.5Mb 610ms DropTail
$ns duplex-link $n(126) $n(135) 1.5Mb 460ms DropTail
$ns duplex-link $n(126) $n(128) 1.5Mb 850ms DropTail
$ns duplex-link $n(127) $n(144) 1.5Mb 810ms DropTail
if {$verbose} { puts -nonewline "2140..."; flush stdout }
$ns duplex-link $n(127) $n(142) 1.5Mb 210ms DropTail
$ns duplex-link $n(127) $n(141) 1.5Mb 350ms DropTail
$ns duplex-link $n(127) $n(138) 1.5Mb 90ms DropTail
$ns duplex-link $n(127) $n(132) 1.5Mb 310ms DropTail
$ns duplex-link $n(128) $n(139) 1.5Mb 170ms DropTail
$ns duplex-link $n(128) $n(135) 1.5Mb 730ms DropTail
$ns duplex-link $n(128) $n(134) 1.5Mb 900ms DropTail
$ns duplex-link $n(128) $n(133) 1.5Mb 440ms DropTail
$ns duplex-link $n(129) $n(142) 1.5Mb 440ms DropTail
$ns duplex-link $n(129) $n(139) 1.5Mb 290ms DropTail
if {$verbose} { puts -nonewline "2150..."; flush stdout }
$ns duplex-link $n(129) $n(135) 1.5Mb 330ms DropTail
$ns duplex-link $n(130) $n(139) 1.5Mb 610ms DropTail
$ns duplex-link $n(130) $n(133) 1.5Mb 520ms DropTail
$ns duplex-link $n(131) $n(145) 1.5Mb 540ms DropTail
$ns duplex-link $n(131) $n(144) 1.5Mb 430ms DropTail
$ns duplex-link $n(131) $n(139) 1.5Mb 560ms DropTail
$ns duplex-link $n(131) $n(137) 1.5Mb 790ms DropTail
$ns duplex-link $n(131) $n(135) 1.5Mb 770ms DropTail
$ns duplex-link $n(132) $n(142) 1.5Mb 420ms DropTail
$ns duplex-link $n(133) $n(141) 1.5Mb 480ms DropTail
if {$verbose} { puts -nonewline "2160..."; flush stdout }
$ns duplex-link $n(133) $n(135) 1.5Mb 520ms DropTail
$ns duplex-link $n(134) $n(149) 1.5Mb 990ms DropTail
$ns duplex-link $n(134) $n(148) 1.5Mb 630ms DropTail
$ns duplex-link $n(134) $n(147) 1.5Mb 750ms DropTail
$ns duplex-link $n(134) $n(139) 1.5Mb 780ms DropTail
$ns duplex-link $n(134) $n(135) 1.5Mb 650ms DropTail
$ns duplex-link $n(135) $n(146) 1.5Mb 150ms DropTail
$ns duplex-link $n(135) $n(143) 1.5Mb 610ms DropTail
$ns duplex-link $n(135) $n(141) 1.5Mb 120ms DropTail
$ns duplex-link $n(136) $n(145) 1.5Mb 470ms DropTail
if {$verbose} { puts -nonewline "2170..."; flush stdout }
$ns duplex-link $n(136) $n(137) 1.5Mb 280ms DropTail
$ns duplex-link $n(137) $n(147) 1.5Mb 240ms DropTail
$ns duplex-link $n(137) $n(146) 1.5Mb 420ms DropTail
$ns duplex-link $n(137) $n(145) 1.5Mb 690ms DropTail
$ns duplex-link $n(137) $n(139) 1.5Mb 280ms DropTail
$ns duplex-link $n(138) $n(148) 1.5Mb 290ms DropTail
$ns duplex-link $n(139) $n(147) 1.5Mb 70ms DropTail
$ns duplex-link $n(139) $n(141) 1.5Mb 600ms DropTail
$ns duplex-link $n(140) $n(147) 1.5Mb 410ms DropTail
$ns duplex-link $n(140) $n(144) 1.5Mb 570ms DropTail
if {$verbose} { puts -nonewline "2180..."; flush stdout }
$ns duplex-link $n(140) $n(143) 1.5Mb 500ms DropTail
$ns duplex-link $n(140) $n(141) 1.5Mb 830ms DropTail
$ns duplex-link $n(143) $n(146) 1.5Mb 480ms DropTail
$ns duplex-link $n(143) $n(145) 1.5Mb 260ms DropTail
$ns duplex-link $n(144) $n(149) 1.5Mb 930ms DropTail
$ns duplex-link $n(144) $n(148) 1.5Mb 570ms DropTail
if {$verbose} { puts ""}

set mproto CtrMcast
set mrthandle [$ns mrtproto $mproto {}]
$ns at 0 "$mrthandle switch-treetype $g"

if {$verbose} {puts "starting"}
set rcvr118 [new Agent/Null]
$ns attach-agent $n(118) $rcvr118
$ns at 1 "$n(118) join-group $rcvr118 $g"
set rcvr37 [new Agent/Null]
$ns attach-agent $n(37) $rcvr37
$ns at 2 "$n(37) join-group $rcvr37 $g"
set rcvr91 [new Agent/Null]
$ns attach-agent $n(91) $rcvr91
$ns at 3 "$n(91) join-group $rcvr91 $g"
set rcvr73 [new Agent/Null]
$ns attach-agent $n(73) $rcvr73
$ns at 4 "$n(73) join-group $rcvr73 $g"
set rcvr67 [new Agent/Null]
$ns attach-agent $n(67) $rcvr67
$ns at 5 "$n(67) join-group $rcvr67 $g"
set rcvr115 [new Agent/Null]
$ns attach-agent $n(115) $rcvr115
$ns at 6 "$n(115) join-group $rcvr115 $g"
set rcvr114 [new Agent/Null]
$ns attach-agent $n(114) $rcvr114
$ns at 7 "$n(114) join-group $rcvr114 $g"
set rcvr47 [new Agent/Null]
$ns attach-agent $n(47) $rcvr47
$ns at 8 "$n(47) join-group $rcvr47 $g"
set rcvr19 [new Agent/Null]
$ns attach-agent $n(19) $rcvr19
$ns at 9 "$n(19) join-group $rcvr19 $g"
set rcvr66 [new Agent/Null]
$ns attach-agent $n(66) $rcvr66
$ns at 10 "$n(66) join-group $rcvr66 $g"

set sender [new Agent/CBR]
$sender set dst_ $g
$sender set class_ 2
$ns attach-agent $n(2) $sender

$ns at 0 "$sender start"

# START ns
$ns at 10.99 "[$ns clearMemTrace]"
$ns at 11 "exit 0"
$ns run

