
/*
 * dmalloc_support.cc
 * Copyright (C) 1997 by USC/ISI
 * All rights reserved.                                            
 *                                                                
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation, advertising
 * materials, and other materials related to such distribution and use
 * acknowledge that the software was developed by the University of
 * Southern California, Information Sciences Institute.  The name of the
 * University may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * @(#) $Header: /home/cr1/benjie/cvsroot/ns/our-ns/lib/dmalloc_support.cc,v 1.1.1.1 2001/06/20 15:38:17 benjie Exp $ (USC/ISI)
 */


/*
 * Redefine new and friends to use dmalloc.
 */

#ifdef HAVE_LIBDMALLOC

extern "C" {
#include <stdlib.h>
#include "dmalloc.h"
#include "return.h"
}

/* i pasted in these new bodies for the allocation operators -- they
are stolen from dmalloc.cc in dmalloc directory -- there is no
SET_RET_ADDR anywhere in the dmalloc sources, so this file was
originally written by some sort of crack smoker, or at least that is
my opinion on the matter. */

void *
operator new(size_t n)
{
// 	   SET_RET_ADDR(_dmalloc_file, _dmalloc_line);
// 	   return _malloc_leap(_dmalloc_file, _dmalloc_line, n);
  char	*file;
  GET_RET_ADDR(file);
  return _malloc_leap(file, 0, n);
}

void *
operator new[](size_t n)
{
// 	   SET_RET_ADDR(_dmalloc_file, _dmalloc_line);
// 	   return _malloc_leap(_dmalloc_file, _dmalloc_line, n);
  char	*file;
  GET_RET_ADDR(file);
  return _malloc_leap(file, 0, n);
}

void
operator delete(void * cp)
{
// 	   if (!cp)   // silently ignore null pointers
// 		   return;
// 	   SET_RET_ADDR(_dmalloc_file, _dmalloc_line);
// 	   _free_leap(_dmalloc_file, _dmalloc_line, cp);
  char	*file;
  GET_RET_ADDR(file);
  _free_leap(file, 0, cp);
}

/* where is operator delete[] ??? why is ns so funky??? */

#endif /* HAVE_LIBDMALLOC */
