#!/usr/local/bin/perl

#if ($#ARGV != 2) {
#    print "usage: tr-to-plotable <from node> <to node> <trace file>\n";
#    print "    looks for tcp connection from -> to and outputs segment nums\n";
#    die   "    assumes there is only one such connection\n";
#}


my @offered_load = (0, 10, 50, 100, 300);
my @num_nodes = (4, 8, 16);

my $logs = "logs";
my $input_cp = "/dev/null";
my $xfer_size = 20547;   # 20547pkts @ 1460 each => 30MB
my $mac_layer = "Mac/802_11";
my $mac_label = "UNKNOWN";
my $scen_base = "ntr-scen/perf-eval";
my $testport = 36;
my $runtime = 900.0;

my $ip1 = "128.2.250.144"; #     farm7 data src
my $ip2 = "128.2.250.51"; #      farm2 data sink
my $phys_if = "xl0";


my $edst = "00:60:08:af:ea:24";  # ether addr of data sink

if ($mac_layer eq 'Mac/NULL') {
    $mac_label = 'macnull';
} elsif ($mac_layer eq 'Mac/802_11') {
    $mac_label = 'mac802';
}



sub perf {
    print "@_\n";
    system(@_);
}

open REMOTE_CMDS, ">remote-cmds" or die " can't write remote-cmds\n";
print REMOTE_CMDS <<"CMDS"
    ssh -x -l ns $ip1 ./startftp.csh &
    ssh -x -l ns $ip2 '/sbin/ping $ip1 > ping-log' &
CMDS
;
close REMOTE_CMDS;
perf("chmod a+x remote-cmds");

my $nn;				# number of nodes
my $pps;			# packets per second bkgnd load

foreach $nn (@num_nodes) {
    foreach $pps (@offered_load) {

	print "\n\n Begining for $nn nodes and $pps packets/sec\n\n";

	open SCEN,">$scen_base-$nn" 
	    or die "can't write scenario file $scen_base-$nn";
	print SCEN<<"SCEN1"
#
# nodes: $nn, max time: $runtime.00, max x: 10000.000000, max y: 1000.000000
# nominal range: 250.000000 link bw: 2000000.000000
# comm pattern:  
# background bitmap:  0 0
#
\$node_(1) set Z_ 0.0
\$node_(1) set Y_ 100.00
\$node_(1) set X_ 50.00
\$node_(2) set Z_ 0.0
\$node_(2) set Y_ 100.00
\$node_(2) set X_ 200.00

\$node_(3) set Z_ 0.0
\$node_(3) set Y_ 100.00
\$node_(3) set X_ 9900.00

SCEN1
    ;
	my ($i);
	my $yloc = 10.0;
	for ($i = 4; $i <= $nn; $i++) {
	    print SCEN<<"SCEN2"
\$node_($i) set Z_ 0.0
\$node_($i) set Y_ $yloc.0
\$node_($i) set X_ 9950.00
SCEN2
    ;
	    $yloc += 10.0;
	}
	close SCEN;

	perf("rm -f conn.cp");
	perf("cp $input_cp conn.cp");
	open CPF,">>conn.cp" 
	    or die "can't write connection pattern file conn.cp";
	
	if ($pps > 0) {
	    my $rate = 1/$pps;
	    my $cnt = ($runtime + 1.0 ) * $pps;
	    print CPF <<"CP1"
#
# 0.100000 4 -> 3 cbr $cnt $pps 1
#
set cbr_(1) [\$ns_ create-connection  CBR \$node_(4) \\
              CBR \$node_(3) 0]
\$cbr_(1) set packetSize_ 1
\$cbr_(1) set interval_ $rate
\$cbr_(1) set random_ 1
\$cbr_(1) set maxpkts_ $cnt
\$ns_ at 0.10 "\$cbr_(1) start"

CP1
    ;
	}			# end if pps > 0

	print CPF <<"CP2"
\#\# Add direct emulation
source emulate/ns-emulate.tcl

AddEmulationChannel 1 \"$ip1\" 2 \"$ip2\" \"$phys_if\"

CP2
;
	close(CPF);
    
	perf("ssh -x -l root $ip2 tcpdump -w dump src $ip1 " . 
	     " and ether dst $edst and tcp and port ftp-data &");


	sleep(2);
	print "starting nse now ... \n";
	perf("./nse cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl " . 
	     " -sc $scen_base-$nn -cp conn.cp" .
	     " -cmd \"./remote-cmds &\" -mac $mac_layer -tr $logs/out-$nn-$pps.tr");

	print "retrieving log files ...\n";
	perf("ssh -x $ip1 killall ftp");
	perf("ssh -x $ip2 killall tcpdump ping");

	perf("scp root\@$ip2:dump $logs/dump-$nn-$pps");
	perf("scp ns\@$ip2:ping-log $logs/ping-$nn-$pps");
	perf("cp timelag_histogram $logs/lag_$nn\_$pps");
	perf("gzip -f $logs/dump-$nn-$pps $logs/out-$nn-$pps.tr");
    }
}
