/*
  $Id: tora_neighbor.cc,v 1.1.1.1 2001/06/20 15:38:16 benjie Exp $
  */

#include <agent.h>
#include <random.h>
#include <trace.h>

#include <cmu/ll.h>
#include <cmu/priqueue.h>
#include <cmu/tora/tora_packet.h>
#include <cmu/tora/tora.h>

#define	CURRENT_TIME	Scheduler::instance().clock()

/* ======================================================================
   TORANeighbor Class Functions
   ====================================================================== */
TORANeighbor::TORANeighbor(nsaddr_t id, Agent *a) : height(id)
{
	index = id;  
	lnk_stat = LINK_UN;
	time_act = Scheduler::instance().clock();

        agent = (toraAgent*) a;
}       


void
TORANeighbor::update_link_status(Height *h)
{
#ifdef LOGGING
        int t = lnk_stat;
#endif
	if(height.isNull())
		lnk_stat = LINK_UN;
	else if(h->isNull())
		lnk_stat = LINK_DN;
	else if(height.compare(h) > 0)
		lnk_stat = LINK_DN;
	else if(height.compare(h) < 0)
		lnk_stat = LINK_UP;
#ifdef LOGGING
        if(t != lnk_stat) {
                agent->log_nb_state_change(this);
        }
#endif
}

void
TORANeighbor::dump()
{
	fprintf(stdout, "\t\tNEIG: %d, Link Status: %d, Time Active: %f\n",
		index, lnk_stat, time_act);
	fprintf(stdout, "\t\t\ttau: %f, oid: %d, r: %d, delta: %d, id: %d\n",
		height.tau, height.oid, height.r, height.delta, height.id);
}

