#!/usr/bin/perl

# usage: drops-by-r <trace> <scen>

# summarize drops by radius from center of simulation universe.
# assumes static network, because assignes drop location based on
# dropping node's initial position.

$trace_file = $ARGV[0];
$scen_file = $ARGV[1];

$bucket_sz = 10; # metres

$x = -1;
$y = -1;

if ($scen_file =~ /(\d+)x(\d+)/) {
    $x = $1;
    $y = $2;
}
else {
    die "Scen file name doesn't contain dimensions";
}

$c_x = $x / 2;
$c_y = $y / 2;

$n = 0;
$max_bucket = 0;

open(SCEN, $scen_file);

while ($_ = <SCEN>) {
    if (/\$node_\((\d+)\) set X_ (\d+\.\d+)/) {
	$x_pos[$1] = $2;
	if ($1 > $n) {
	    $n = $1;
	}
    }
    if (/\$node_\((\d+)\) set Y_ (\d+\.\d+)/) {
	$y_pos[$1] = $2;
	if ($1 > $n) {
	    $n = $1;
	}
    }
}

close(SCEN);

# for ($i = 1; $i < $n; $i++) {
#     print "$i $x_pos[$i] $y_pos[$i]\n";
# }
			     
sub calc_dist {
    $x1 = shift;
    $y1 = shift;
    
    $dx = $x1 - $c_x;
    $dy = $y1 - $c_y;
    
    return sqrt($dx*$dx + $dy*$dy);
}

open(TR, $trace_file);

while ($_ = <TR>) {
    if (/^D \d+.\d+ _(\d+)_ (\S+)\s+(\S+) (\d+) (\S+) \d+ \[\w+ \w+ \S+ (\w+) \w+\]/o) {
	$node = $1;
	$dist = calc_dist($x_pos[$node], $y_pos[$node]);
	$bucket = int($dist / $bucket_sz);
	if ($bucket > $max_bucket) {
	    $max_bucket = $bucket;
	}
	$drops[$bucket]++;
    }
}

# details need to be worked out
print "# for each range r, show drops between the previous range and r\n";
print "# range\tdrops\tcumulative-drops\n";
$d_tot = 0;
for ($i = 1; $i <= $max_bucket + 1; $i++) {
    $r = $bucket_sz * $i;
    $d = $drops[$i - 1];
    $d_tot += $d;
    if ($d > 0) {
	print "$r\t$d\t$d_tot\n";
    }
    else {
	print "$r\t0\t$d_tot\n";
    }
}
