#!/usr/bin/perl
strict;

$first = 21;
$stop = 500;

@sleep_time;
@idle_time;
@last_action;
@last_idle;

for (my $i=0; $i<120; $i++) {
  $sleep_time[$i] = 0;
  $idle_time[$i] = 0;
  $last_action[$i] = 0;
  $last_idle[$i] = 0;
}

while (<>) {
  if ($_ =~ /^v ([\d.]+) _(\d+)_/) {
    $idle_time[$2] += ($1-$last_action[$2]);
    $last_action[$2] = $1;
    $last_idle[$2] = 1;
    if ($1 > $stop) { print $_; last; }
  }
  elsif ($_ =~ /^~ ([\d.]+) _(\d+)_/) {
    $idle_time[$2] += ($1-$last_action[$2]);
    $last_action[$2] = $1;
    $last_idle[$2] = 0;
    if ($1 > $stop) { print $_; last; }
  }
  elsif ($_ =~ /^- ([\d.]+) _(\d+)_/) {
    $sleep_time[$2] += ($1-$last_action[$2]);
    $last_action[$2] = $1;
    $last_idle[$2] = 1;
    if ($1 > $stop) { print $_; last; }
  }
}

my $n = 0;
my $total_sleep = 0;
my $total_idle = 0;
for($i=$first; $i<=120; $i++) {
  if ($last_action[$i] > 0) {
    $n++;
    if ($last_idle[$2]) {
      $idle_time[$i] += ($stop-$last_action[$i]);
    } else {
      $sleep_time[$i] += ($stop-$last_action[$i]);
    }
    $total_sleep += $sleep_time[$i];
    $total_idle += $idle_time[$i];
  }
}

printf("avg sleep time: %3.3f\n", $total_sleep/$n);
printf("avg idle  time: %3.3f\n", $total_idle/$n);

