#!/usr/bin/perl

$maxnodes = 120;
$nodes = 120;
$eskip = 20;
$estop = 200;
$period = 10;

my @time;
my @nannounce;
my @announce;
my @jtime;
my @jstart;
my @jdrain;

$coordinators = 0;

for (my $i=1; $i<=$maxnodes; $i++) {
 $time[$i] = 0;
 $nannounce[$i] = 0;
 $announce[$i] = 0;
 $jstart[$i] = 0;
 $jdrain[$i] = 0;
 $jtime[$i] = 0;
}

my $now = 0;
my $mark = 0;
my $cavgn = 0;
my $cavgs = 0;

while (<>) {
  if ($_ =~ /# ([\d.]+):/) {
    $now = $1;
  }
  if ($now >= $estop) { last; }

  while ($now > $mark+$period) {
    # print "$now $mark $coordinators\n";
    $cavgs++;
    $cavgn += $coordinators;
    $mark += $period;
  }

  if ($_ =~ /# ([\d.]+): (\d+) out of energy/) {
    $nodes--;
    print "$now $nodes\n";
  }
  elsif ($_ =~ /# ([\d.]+): (\d+) announce coordinator/) {
    $announce[$2] = $1; 
    $nannounce[$2]++; 
    $coordinators++;
    # printf "a $2: $coordinators\n";
  }
  elsif ($_ =~ /# ([\d.]+): (\d+) withdraw coordinator/) {
    $time[$2] += ($1-$announce[$2])+2;
    $announce[$2] = 0;
    $coordinators--;
    # printf "w $2: $coordinators\n";
  }

  elsif ($_ =~ /^([0-9.]+) ([0-9.]+) ([0-9]+) ([cn])([0-9]+) [0-9]+ [0-9]+ [0-9.]+ ([0-9.]+) ([0-9.]+)/) {
     # posx $1 posy $2 node $3 n/c $4 neighbor $5 Eremain $6 Einit $7
     if ($jstart[$3] == 0) {
       $jstart[$3] = $6;
       $jtime[$3] = $now;
     }
     $jdrain[$3] = $6;
  }
}

$totalTime = 0;
$totalNA = 0;
$totalDrain = 0;

for (my $i=$eskip+1; $i<=$maxnodes; $i++) {
  if ($announce[$i] > 0) {
    $time[$i] += ($estop-$announce[$i]);
    $announce[$i] = 0;
  }
  $totalTime  += $time[$i];
  $totalNA += $nannounce[$i];
  $drain = ($jstart[$i]-$jdrain[$i])/($estop-$jtime[$i]);
  $totalDrain += $drain;
  print "$i $time[$i] $drain\n";
}

if ($maxnodes > 0) {
  printf("# avg time:         %3.3f\n", $totalTime/($maxnodes-$eskip));
  printf("# avg announces:    %3.3f\n", $totalNA/($maxnodes-$eskip));
  printf("# avg consumption:  %3.3f\n", $totalDrain/($maxnodes-$eskip));
  printf("# avg coordinators: %3.3f\n", $cavgn/$cavgs);
  printf("# total nodes:      %d\n",    $maxnodes);
}

