#!/usr/bin/perl

$name = $ARGV[0];

$time     = 220;
$mobility = 0;
$route    = 10;
$energy   = 0;

$nodes  = 120;
$period = 20;
$max_x  = 1000;
$max_y  = 1000;

$range  = 250.00;
$bw     = 2000000.00;
$max_speed = 20;
$pause = 15;

$fn = "$max_x-$max_y-n$nodes-$name-t$time-m$mobility-p$pause-e$energy-r$route";
open(F0, ">$fn.scen") || die "$fn.scen: $!";

print F0<<EOF
#
# nodes: $nodes, max time: $time.00, max x: $max_x.00, max y: $max_y.00
# nominal range: $range link bw: $bw
# pause: 0.00, max speed: $max_speed

EOF
;

# initial positions

for (my $i = 1; $i <= $route; $i++) {
  my $pos_x = rand 50;
  my $pos_y = rand $max_y;
  my $pos_z = 0;
  print F0 "\$node_($i) set X_ $pos_x\n";
  print F0 "\$node_($i) set Y_ $pos_y\n";
  print F0 "\$node_($i) set Z_ $pos_z\n";
}
for (my $i = $route+1; $i <= $route*2; $i++) {
  my $pos_x = $max_x - 50 + rand 50;
  my $pos_y = rand $max_y;
  my $pos_z = 0;
  print F0 "\$node_($i) set X_ $pos_x\n";
  print F0 "\$node_($i) set Y_ $pos_y\n";
  print F0 "\$node_($i) set Z_ $pos_z\n";
}

my %position_x;
my %position_y;

for (my $i = $route*2+1; $i <= $nodes; $i++) {
  my $pos_x = rand $max_x;
  my $pos_y = rand $max_y;
  my $pos_z = 0;
  print F0 "\$node_($i) set X_ $pos_x\n";
  print F0 "\$node_($i) set Y_ $pos_y\n";
  print F0 "\$node_($i) set Z_ $pos_z\n";
  $position_x->[$i] = $pos_x;
  $position_y->[$i] = $pos_y;
}

# initial energy

if ($energy != 0) {
  for (my $i = 1; $i <= $route*2; $i++) {
    my $e = 2000;
    print F0 "\$node_($i) setenergy $e\n";
  }
  for (my $i = $route*2+1; $i <= $nodes; $i++) {
    my $e = 300;
    print F0 "\$node_($i) setenergy $e\n";
  }
}

# route packets

if ($route > 0) {
  my $n = $route*2;
  for (my $i = 1; $i <= $route*2; $i++) {
    print F0 "\$node_($i) srcsink $n\n";
  }
  my $t = $time-30;
  print F0 "set Pkts [expr $t / \$opt(pi)]\n";
  for (my $i = 1; $i <= $route; $i++) { 
    my $src = ($i+$route) % $nodes;
    my $dst = ($i) % $nodes;
    print F0 "set cbr_($src) [\$ns_ create-connection CBR \$node_($src) CBR \$node_($dst) 0]\n";
    print F0 "\$cbr_($src) set packetSize_ \$opt(ps)\n";
    print F0 "\$cbr_($src) set interval_ \$opt(pi)\n";
    print F0 "\$cbr_($src) set random_ 1\n";
    print F0 "\$cbr_($src) set maxpkts_ \$Pkts\n";
    my $st = 20+rand(5);
    print F0 "\$ns_ at $st \"\$cbr_($src) start\"\n";
  }
  for (my $i = 1; $i <= $route; $i++) { 
    my $src = ($i) % $nodes;
    my $dst = ($i+$route) % $nodes;
    print F0 "set cbr_($src) [\$ns_ create-connection CBR \$node_($src) CBR \$node_($dst) 0]\n";
    print F0 "\$cbr_($src) set packetSize_ \$opt(ps)\n";
    print F0 "\$cbr_($src) set interval_ \$opt(pi)\n";
    print F0 "\$cbr_($src) set random_ 1\n";
    print F0 "\$cbr_($src) set maxpkts_ \$Pkts\n";
    my $st = 20+rand(5);
    print F0 "\$ns_ at $st \"\$cbr_($src) start\"\n";
  }
}

# dump tables

$dumps = ($time/$period)-1;

for (my $j = 1; $j < $dumps; $j++) {
  $dt = $j*$period+$period;
  for (my $i = 1; $i <= $nodes; $i++) {
    if ($i == 1) {
      my $dtt = $dt-1;
      print F0 "\$ns_ at $dtt \"\$node_($i) dump-tables\"\n";
    } else {
      print F0 "\$ns_ at $dt \"\$node_($i) dump-tables\"\n";
    }
  }
}
for (my $i = 1; $i <= $nodes; $i++) {
  my $t1 = $time-2;
  my $t2 = $time-1;
  if ($i == 1) {
    print F0 "\$ns_ at $t1 \"\$node_($i) dump-tables\"\n";
  } else {
    print F0 "\$ns_ at $t2 \"\$node_($i) dump-tables\"\n";
  }
}

# mobility

if ($mobility) {
  my %movetime;
  for (my $i = $route*2+1; $i <= $nodes; $i++) { $movetime->[$i] = rand 30; }
  my $not_done = 1;
  while ($not_done == 1) {
    $not_done = 0;
    for (my $i = $route*2+1; $i <= $nodes; $i++) {
      if ($movetime->[$i] < $time) {
        my $pos_x = rand $max_x;
        my $pos_y = rand $max_y;
        my $speed = rand $max_speed;
        print F0 "\$ns_ at $movetime->[$i] \"\$node_($i) setdest $pos_x $pos_y $speed\"\n";
        my $dd = sqrt(($position_x->[$i]-$pos_x)*($position_x->[$i]-$pos_x)+($position_y->[$i]-$pos_y)*($position_y->[$i]-$pos_y));
	$position_x->[$i] = $pos_x;
	$position_y->[$i] = $pos_y;
        my $skip = $pause + $dd/$speed;
        $movetime->[$i] += $skip;
	$not_done = 1;
      } 
    }
  }
}

close F0;

