#!/usr/bin/perl

$name = $ARGV[0];

$time     = 310;
$energy   = 1;

$nodes  = 144;
$period = 20;
$max_x  = 1253;
$max_y  = 1253;

$range  = 250.00;
$bw     = 2000000.00;

$fn = "$max_x-$max_y-n$nodes-$name-t$time-m0-p0-e$energy-r$route";
open(F0, ">$fn.scen") || die "$fn.scen: $!";

print F0<<EOF
#
# nodes: $nodes, max time: $time.00, max x: $max_x.00, max y: $max_y.00
# nominal range: $range link bw: $bw
# pause: 0.00, max speed: $max_speed

EOF
;

# initial positions

my $s = sqrt($nodes);
my $l = $max_x / $s;

for (my $i = 1; $i <= $nodes; $i++) {
  my $pos_x = int(($i-1)%$s)*$l;
  my $pos_y = int(($i-1)/$s)*$l;
  my $pos_z = 0;
  print F0 "\$node_($i) set X_ $pos_x\n";
  print F0 "\$node_($i) set Y_ $pos_y\n";
  print F0 "\$node_($i) set Z_ $pos_z\n";
}

# initial energy

if ($energy != 0) {
  for (my $i = 1; $i <= $nodes; $i++) {
    my $e = 300;
    print F0 "\$node_($i) setenergy $e\n";
  }
}

# dump tables

$dumps = ($time/$period)-1;

for (my $j = 1; $j < $dumps; $j++) {
  $dt = $j*$period+$period;
  for (my $i = 1; $i <= $nodes; $i++) {
    if ($i == 1) {
      my $dtt = $dt-1;
      print F0 "\$ns_ at $dtt \"\$node_($i) dump-tables\"\n";
    } else {
      print F0 "\$ns_ at $dt \"\$node_($i) dump-tables\"\n";
    }
  }
}
for (my $i = 1; $i <= $nodes; $i++) {
  my $t1 = $time-2;
  my $t2 = $time-1;
  if ($i == 1) {
    print F0 "\$ns_ at $t1 \"\$node_($i) dump-tables\"\n";
  } else {
    print F0 "\$ns_ at $t2 \"\$node_($i) dump-tables\"\n";
  }
}

close F0;

