#!/usr/bin/perl

my $fn = $ARGV[0];
shift @ARGV;

my $max_x = 0;
my $max_y = 0;
my $first = 1;

my @nodes;      	# array of nodes
my %location;  		# node_id -> array of (posx, posy)
my %is_coordinator; 	# coordinator map
my @coordinators;	# array of coordinators
my @connections;	# (node,coordinator)
my @backbone;		# (coordinator, coordinator)
my %milage;		# node_id -> milage

my $totalpwr = 0;
my $pwrnodes = 0;

while (<>) {
  if ($_ =~ /^([0-9.]+) ([0-9.]+) ([0-9]+) ([cn])([0-9]+) [0-9]+ [0-9]+ [0-9.]+ ([0-9.]+) ([0-9.]+)/) {
     # print "posx $1 posy $2 node $3 n/c $4 neighbor $5 energy remain $6\n";
     # print "initial energy $7\n";

    if ($1 > $max_x) { $max_x = $1; }
    if ($2 > $max_y) { $max_y = $2; }

    if (!($location->[$3])) {
      # print "adding node $3 at $1,$2\n";
      $location->[$3] = [$1,$2];
      push(@nodes, $3);
      $milage->[$3] = 1-$6/$7;
      # print "$6/$7, $milage->[$3]\n";
      $totalpwr += $milage->[$3];
      $pwrnodes ++;
    }
  
    if ($4 eq "c") {
      if ($3 == $5 && !($is_coordinators->[$5])) {
        # print "adding $5 as coordinator\n";
	$is_coordinators->[$5] = 1;
	push(@coordinators, $5);
      }
    }

    if ($3 != $5) {
      push(@connections, $3);
      push(@connections, $5);
    }
  } 
  elsif ($_ =~ /^StartOfDump/) { 
    if ($first == 0) { last; }
    $first = 0;
  }
}
  
open(F0, ">$fn.nodes")        || die "$fn.nodes: $!";
open(F1, ">$fn.coordinators") || die "$fn.coordinators: $!";
open(F2, ">$fn.connections")  || die "$fn.connections: $!";
open(F3, ">$fn.backbone")     || die "$fn.backbone: $!";
open(F4, ">$fn.milage")       || die "$fn.milage: $!";
  
print F0 "# nodes\n";
  
for ($i=0; $i<=$#nodes; $i++) {
  print F0 "$location->[$nodes[$i]][0] ";
  print F0 "$location->[$nodes[$i]][1] $nodes[$i]\n"; 
}
  
print F1 "# coordinators\n";
 
for ($i=0; $i<=$#coordinators; $i++) {
  print F1 "$location->[$coordinators[$i]][0] ";
  print F1 "$location->[$coordinators[$i]][1] ";
  print F1 "$coordinators[$i]\n"; 
}
  
print F2 "# connections\n";
print F3 "# backbone\n";
  
for ($i=0; $i<=$#connections; $i+=2) {
  my $dx = $location->[$connections[$i+1]][0] - 
           $location->[$connections[$i]][0];
  my $dy = $location->[$connections[$i+1]][1] - 
           $location->[$connections[$i]][1];
  if ($is_coordinators->[$connections[$i]]) {
    print F2 "$location->[$connections[$i]][0] ";
    print F2 "$location->[$connections[$i]][1] ";
    print F2 "$dx $dy\n";
  }
  
  if ($is_coordinators->[$connections[$i]] && 
      $is_coordinators->[$connections[$i+1]]) {
    print F3 "$location->[$connections[$i]][0] ";
    print F3 "$location->[$connections[$i]][1] ";
    print F3 "$dx $dy\n";
  }
}

print F4 "# milage\n";
for ($i=0; $i<=$#nodes; $i++) {
  print F4 "$nodes[$i] $milage->[$nodes[$i]]\n";
}

close(F4);
close(F3);
close(F2);
close(F1);
close(F0);
 
$dim = int($max_x);
if ($max_y > $max_x) { $dim = int($max_y); }
$dim += 200;

open(F0, ">$fn.plot")   || die "$fn.plot: $!";
open(F1, ">$fn.core")   || die "$fn.core: $!";
open(F2, ">$fn.pps")    || die "$fn.pps: $!";
open(F3, ">$fn.ppt")    || die "$fn.ppt: $!";
  
print F0 "set nolabel\n";
print F1 "set nolabel\n";
print F2 "set nolabel\n";
print F3 "set nolabel\n";
  
for ($i=0; $i<=$#nodes; $i++) {
  my $posx = $location->[$nodes[$i]][0]+10;
  my $posy = $location->[$nodes[$i]][1]+10;
  print F0 "set label \"$nodes[$i]\" at $posx,$posy\n";
  print F1 "set label \"$nodes[$i]\" at $posx,$posy\n";
}
 
print F2 "set output \"$fn.ps\"\n";
print F2 "set term postscript eps enhanced 16\n";
print F2 "set size 0.6,0.6\n";
print F3 "set output \"$fn.pts\"\n";
print F3 "set term postscript eps enhanced color 16\n";
print F3 "set size 0.6,0.6\n";
print F3 "set xlabel \"node number\"\n";
print F3 "set ylabel \"time as coordinator (sec)\"\n";
  
print F0 "plot [0:$dim][0:$dim] ";
print F1 "plot [0:$dim][0:$dim] ";
print F2 "plot [0:$dim-100][0:$dim-100] ";
print F3 "plot ";
  
print F0 "\"$fn.connections\" title \"connections\" with vector, ";
print F1 "\"$fn.backbone\" title \"backbone\" with vector, ";

print F0 "\"$fn.nodes\" title \"nodes\", ";
print F1 "\"$fn.nodes\" title \"nodes\", ";
print F2 "\"$fn.nodes\" notitle, ";
  
print F0 "\"$fn.coordinators\" title \"coordinators\"\n";
print F1 "\"$fn.coordinators\" title \"coordinators\"\n";
print F2 "\"$fn.coordinators\" notitle\n";
print F3 "\"$fn.milage\" notitle with impulses\n";
  
close(F3);
close(F2);
close(F1);
close(F0);

system ("sort -n $fn.milage > $fn.milage.0; mv $fn.milage.0 $fn.milage");
open(F3, ">$fn.time")   || die "$fn.time: $!";
print F3 "plot [0:$#nodes][0:1] \"$fn.milage\" with impulses\n";
close(F3);
  
my $nn = $#nodes+1;
my $nc = $#coordinators+1;
my $p = $nc/$nn;
my $pwr = $totalpwr/$pwrnodes;

printf("$nn nodes, $nc coordinators, ratio %3.2f, %3.2f avg pwr consumed\n", 
       $p, $pwr);

