#!/usr/bin/perl
strict;

$numSent = 0;
$numReceived = 0;
$numDrops = 0;
$numZeros = 0;
$last = 0;

@sent;
@recv;
@drop;
@bufs;

for (my $i=0; $i<100000; $i++) {
  $sent[$i] = 0;
  $recv[$i] = 0;
  $drop[$i] = 0;
  $bufs[$i] = 0;
}

sub reset_stats {
  $numSent = 0;
  $numReceived = 0;
}

sub calc_stats {
  my ($s, $now, $length, $sent, $recv) = @_;
  printf ("$s $now %3.3f %3.3f $sent $recv\n", $sent/$length, $recv/$length);
}

reset_stats();

$lastMark = 0;
$now = 0;

while (<>) {
  if ($_ =~ /[rsDf] ([\d.]+) _\d+_/) {
    $now = $1;
  }
  if ($_ =~ /D ([\d.]+) [0-9_A-Za-z ]+ RCV (\d+) [a-z\d.J: \[\]-]+ (\d+) 0$/) {
    $numReceived++;
    $recv[$2] = $1;
  }
  elsif ($_ =~ /D ([\d.]+) [0-9_]+ RTR [A-Za-z ]+ (\d+) cbr /) {
    $numDrops++;
    $drop[$2] = $1;
  }
  elsif ($_ =~ /s ([0-9.]+) [0-9_]+ AGT  --- (\d+) cbr/) { 
    $numSent++;
    $sent[$2] = $1;
    $last = $2;
  }
  
  if ($_ =~ /D ([\d.]+) [0-9_]+ MAC  BUF (\d+) cbr /) {
    $bufs[$2] = $1;
  }
}

$samples = 0;
$total = 0;
$dsamples = 0;
$dtotal = 0;
$bsamples = 0;
$btotal = 0;

for (my $i=0; $i<$last; $i++) {
  if ($sent[$i] != 0) {
    # printf("$i $sent[$i] $recv[$i] $drop[$i]\n");
    if ($recv[$i] > 0) {
      $samples++;
      $total+=($recv[$i]-$sent[$i]);
    } 
    if ($drop[$i] > 0) {
      $dsamples++;
      $dtotal+=($drop[$i]-$sent[$i]);
    }
    if ($bufs[$i] > 0) {
      $bsamples++;
      $btotal+=($bufs[$i]-$sent[$i]);
    }
  }
}

calc_stats("recvs:", $now, $now-$lastMark, $numSent, $numReceived);
calc_stats("drops:", $now, $now-$lastMark, $numSent, $numDrops);

printf("average recv latency: %3.3f\n",$total/$samples);
printf("average drop latency: %3.3f\n",$dtotal/$dsamples);
if ($bsamples > 0) {
  printf("average bufd latency: %3.3f\n",$btotal/$bsamples);
}

