#!/usr/bin/perl

$period = 10;
$skip = 20;

for (my $i=0; $i<400; $i++) {
 $start[$i] = 0;
 $drain[$i] = 0;
}
$last = 0;
$now = 0;

sub p_stats {
  my $drain_total = 0;
  my $drain_ratio = 0;
  my $samples = 0;
  for(my $i=1; $i<400; $i++) {
    if ($start[$i] && $i > $skip) {
      $drain_total += $start[$i]-$drain[$i];
      $drain_ratio += (1-$drain[$i]/$start[$i]);
      $samples++;
    }
  }
  printf("$now average drain %3.3fJ (%3.3f)\n",
         $drain_total/$samples, $drain_ratio/$samples);
}

while (<>) {
  if ($_ =~ /[srDf] ([\d.]+) _(\d+)_ [A-Za-z\?\d.: \[\]-]+ ([\d.]+)J\]/) {
    $now = $1;
    if ($start[$2] == 0) {
      $start[$2] = $3;
    }
    $drain[$2] = $3;
    if ($1-$last > $period) { p_stats(); $last = $1; }
  }
}

p_stats();

