#!/usr/bin/perl
strict;

$beaconStart = 0;
$lastBeacon = 0;
$lastATIM = 0;
$now = 0;

$aSamples = 0;
$aSample = 0;
$highASample = 0;
$lowASample = 1;
$bSamples = 0;
$bSample = 0;
$highBSample = 0;
$lowBSample = 1;
$lastATIM = 0;

while (<>) {
  if ($_ =~ /[rsD] ([\d.]+) _(\d+)_ [a-zA-Z\d \[\]-]+ m b/) {
    $now = $1;
    if ($now - $lastBeacon > 0.1) {
      $b = $lastBeacon - $beaconStart;
      $a = $lastATIM - $beaconStart;
      $beaconStart = $now;
      print "$now $b $a\n";
      if ($now > 25 && $now < 80) {
        $bSamples++;
	$bSample+=$b;
        $aSamples++;
	$aSample+=$a;

	if ($a > $highASample) { $highASample = $a; }
	if ($a < $lowASample) { $lowASample = $a; }
	if ($b > $highBSample) { $highBSample = $b; }
	if ($b < $lowBSample) { $lowBSample = $b; }
      }
    }
    $lastBeacon = $now;
  } 
  elsif ($_ =~ /[rsD] ([\d.]+) _(\d+)_ [a-zA-Z\d \[\]-]+ m a/) {
    $lastATIM = $1;
  }
}

$aAvg = $aSample / $aSamples;
$bAvg = $bSample / $bSamples;

printf("Beacon: avg %0.6f, high %0.6f, low %0.6f\n", 
       $bAvg, $highBSample, $lowBSample);
printf("ATIM:   avg %0.6f, high %0.6f, low %0.6f\n", 
       $aAvg, $highASample, $lowASample);

