
#ifndef SPANPACKET_H
#define SPANPACKET_H

#define MAX_SPAN_NEIGHBORS    	256
#define MAX_SPAN_COORDINATORS 	32

#define SPAN_DEF_TTL       	32

#define SPAN_DROP_RECEIVED	"RCV"
#define SPAN_DROP_TX_FAILED	"TXF"
#define SPAN_DROP_BUF		"BUF"
#define SPAN_GF_TTL		"TTL"
#define SPAN_GF_HOLE		"GFH"

#include <packet.h>

struct hdr_span {
#define SPAN_DATA		0
#define SPAN_HELLO              1
  unsigned char type;
  bool is_coordinator;
  bool is_tentative;
  bool to_coordinator;
  int node_id;
  int x;
  int y;
  int dst_x;
  int dst_y;
  int nounce;
  inline int size() { return sizeof(struct hdr_span); }
  static int _offset;
};

struct span_hello {
  static int _offset;
  unsigned ncoordinators;
  unsigned nneighbors;
  unsigned coordinators[MAX_SPAN_COORDINATORS];
  unsigned neighbors[MAX_SPAN_NEIGHBORS];
  inline int size() { 
    return (2+ncoordinators+nneighbors)*sizeof(unsigned);
  }
};

struct span_poll {
  static int _offset;
  inline int size() { return sizeof(struct span_poll); }
};

#endif

