
#include <cmu/mac.h>
#include "gfrt.hh"

#define TRACE_ROUTE    0

GFRouter::GFRouter(NeighborTable &t)
  : _neighbors(t)
{
}

int
GFRouter::find_next_hop(int id, int dst_id, int dst_x, int dst_y, bool& coord)
{
#if TRACE_ROUTE > 1
  Scheduler & s = Scheduler::instance();
  double now = s.clock();
#endif
  coord = false;

  NeighborTable::Neighbor *self = _neighbors.search_neighbor(id);
  NeighborTable::Neighbor *dst = _neighbors.search_neighbor(dst_id);

  if (dst) {
    coord = self->find_coordinator(dst_id);
    return id;
  }

  double shortest_dist = distance_between(id, dst_x, dst_y);
  int hop = -1;
  coord = true;

  // first, try to route with only coordinators

  LLIterator *c_i = self->coord_iter();
  NeighborTable::Coordinator *c = (NeighborTable::Coordinator*) c_i->peek();
  while (c) {
    double d = distance_between(c->id, dst_x, dst_y);
#if TRACE_ROUTE > 1
    fprintf(stderr, "# %f %d: -> %d, %d looked at %f (c): ",
	    now, id, dst_id, c->id, d);
#endif
    if (d < shortest_dist) {
#if TRACE_ROUTE > 1
      fprintf(stderr, "shortest\n");
#endif
      shortest_dist = d; 
      hop = c->id;
    }
    else {
#if TRACE_ROUTE > 1
      fprintf(stderr, "skip\n");
#endif
    }
    c = (NeighborTable::Coordinator*) c_i->next();
  }
  delete c_i;

  // no route, use any node

  if (hop < 0) {
    coord = false;
    
    LLIterator *n_i = _neighbors.neighbors();
    NeighborTable::Neighbor *n = (NeighborTable::Neighbor*) n_i->peek();
    while (n) {
      double d = distance_between(n->id, dst_x, dst_y);
#if TRACE_ROUTE > 1 
      fprintf(stderr, "# %f %d: ->%d, %d looked at %f (n): ",
	      now, id, dst_id, n->id, d);
#endif 
      if (d < shortest_dist || shortest_dist < 0) { 
#if TRACE_ROUTE > 1 
	fprintf(stderr, "shortest\n");
#endif 
	shortest_dist = d; 
	hop = n->id;
      } 
      else {
#if TRACE_ROUTE > 1
        fprintf(stderr, "skip\n");
#endif
      }

      n = (NeighborTable::Neighbor*) n_i->next();
    }
    delete n_i;

#if TRACE_ROUTE > 0
    if (hop >= 0 && dst_id != hop) 
      fprintf(stderr,"# %f %d: to %d, via %d (neighbor) instead\n", 
	      Scheduler::instance().clock(), id, dst_id, hop);
#endif
  }
  return hop;
}

int
GFRouter::forward_pkt(int id, hdr_ip *iph, hdr_cmn *cmnh, hdr_span *spanh)
{
  unsigned retry = 0;

  while (retry < 2) {
    if (--iph->ttl_ == 0)
      return GF_TTL;
    if (iph->dst() == (int)IP_BROADCAST) {
      cmnh->next_hop_ = MAC_BROADCAST;
      return GF_FWD;
    }
    bool coord = false;
    int via = find_next_hop(id, iph->dst(), spanh->dst_x, spanh->dst_y, coord);
    if (via < 0) {
      // update dst location, may be it moved...
      double x, y, z;
      (God::instance()->nodelist[iph->dst()])->getLoc(&x, &y, &z);
      spanh->dst_x = (int)x;
      spanh->dst_y = (int)y;
      retry++;
    }
    else {
      if (via != id)
        cmnh->next_hop_ = via;
      else
        cmnh->next_hop_ = iph->dst();
      if (coord)
	return GF_COORD;
      else
	return GF_FWD;
    }
  }
#if TRACE_ROUTE
  fprintf(stderr,"# routing error %f: %d no route to host %d\n", 
          Scheduler::instance().clock(), id, iph->dst());
#endif
  return GF_HOLE;
}

