#! /usr/bin/tclsh
# $Id: run-vary-density.tcl,v 1.1.1.1 2001/06/20 15:37:54 benjie Exp $

# usage: run-vary-density <length> <ns-dir>

# runs sims of varying densities on scenarios of side length <length>.
# Runs a sim for every n and speed with the given length that is found
# in ./scen/<n>/<length>/<speed>


set currdir [exec pwd]

set side_len [lindex $argv 0]
set ns_dir [lindex $argv 1]
set ns "$ns_dir/ns"

set speed 10
set num_pkts 6
set num_conns 3n

if { ! [ file exists "$currdir/trace" ] } {
    exec mkdir "$currdir/trace"
}

# glob in directory script was started from
set n_dirs [ glob scen/*/$side_len ]

# switch to ns directory so ns scripts work out
cd $ns_dir

foreach dir $n_dirs {
    set n 0
    regexp {^scen/([0-9]+)/} $dir junk n
    
    set scen_file "$currdir/scen/$n/$side_len/$speed"
    set cbr_file "$currdir/cbr/$n/$num_pkts/$num_conns"
    set trace_file "$currdir/trace/${n}n-${side_len}x${side_len}-$num_pkts-$num_conns-${speed}ms"

    exec $ns $ns_dir/cmu/scripts/run.ori.tcl -rp $ns_dir/cmu/hgps/hgps-nobias-nolocserver.tcl -x $side_len -y $side_len -cp $cbr_file -sc $scen_file -stop 300 -tr $trace_file
    exec perl $ns_dir/cmu/scripts/hgps.pl $trace_file RTR $n > $trace_file.summ
    exec /bin/echo gzip $trace_file
}    
