#!/usr/local/bin/perl

$infile = 0;
$line = 0;

# ======================================================================
# Main Procedure
# ======================================================================
if($#ARGV != 2) {
    print stderr "\nusage: $0 <input file> <AGT | RTR> <DSR | TORA | AODV | MSG >\n\n";
    exit 1;
}

if(! open $infile, $ARGV[0]) {
	print stderr "Could not open $ARGV[0]\n";
	exit 1;
}

if($ARGV[1] ne "AGT" && $ARGV[1] ne "RTR") {
        print stderr "Invalid Script Type";
        exit 1;
}

if($ARGV[2] ne "DSR" && $ARGV[2] ne "TORA" &&
   $ARGV[2] ne "AODV" && $ARGV[2] ne "MSG") {
        print stderr "Invalid Protocol $ARGV[2]\n";
        exit 1;
}

$SCRIPT_TYPE = $ARGV[1];
$PROTO = $ARGV[2];

#
# Strings to find in the totals output
#
$S[1] = "$PROTO TOTALS Transmitted";
$S[2] = "CBR TOTALS Transmitted";
$S[3] = "CBR TOTALS Received";
$S[4] = "CBR TOTALS Drops";
$S[5] = "CBR TOTALS Overhead";
$S[6] = "Optimal Path Len on sending";
$S[7] = "Actual Path Len on receiving";
$S[8] = "Actual - Optimal Path Len on receiving";
$S[9] = "END";

$DROP_NUM = 4;          # index of CBR Drops

#
# MATLAB Array Names
#
$NAME[1] = "t.rtr_tx";
$NAME[2] = "t.cbr_tx";
$NAME[3] = "t.cbr_rx";
$NAME[4] = "t.cbr_dr";
$NAME[5] = "t.cbr_ov";
$NAME[6] = "t.opt";
$NAME[7] = "t.act";
$NAME[8] = "t.dif";

# ======================================================================
#
# Identifing Comment
#
print "%\n% Script $ARGV[0], $ARGV[1], $ARGV[2]\n%\n";


$num = 1;               # index into S[]

while(<$infile>) {

        if($S[$num] eq "END") {
                last;                           # DONE
        }

	$line += 1;

        if($flag == 1) {

                if(/^\s+Packets:\s+(\d+)/o) {
                        print "$1 ";
                }
                elsif(/^\s+Bytes:\s+(\d+)/o) {
			print "$1 ";
			if($SCRIPT_TYPE eq "AGT" || $num != 4) {
				print "\];\n";
				$flag = 0;
				$num += 1;
			}
                }

		#
		# CBR MAC Drops
		#
		elsif($num == $DROP_NUM) {

			if(/^\s+Collision:\s+(\d+)/o) {
				print "$1 ";
			}
			elsif(/^\s+Duplicate:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+CRC Invalid:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Max Retries:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Invalid State:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Busy:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
			}

			#
			# CBR RTR Drops
			#
			elsif(/^\s+No Route:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+TTL Expired:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+RTR Queue Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Timeout:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Routing Loop:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+IFQ Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+ARP Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Callback:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
			}
			else {
		    		print "\];\n";
		    		$flag = 0;
		    		$num += 1;
			}
		}
		#
		# CBR Summary Information
		#
                elsif(/^\s+Optimal Len Sum:\s+(\d+)/o) {
                        print "$1 \];\n";
                        $flag = 0;
                        $num += 1;
                }
                elsif(/^\s+Optimal Len.*:\s+(\d+)/o) {
                        print "$1 ";
                }

                elsif(/^\s+Actual Len Sum:\s+(\d+)/o) {
                        print "$1 \];\n";
                        $flag = 0;
                        $num += 1;
                }
                elsif(/^\s+Actual Len.*:\s+(\d+)/o) {
                        print "$1 ";
                }

                elsif(/^\s+Actual - Optimal Len Sum:\s+(\d+)/o) {
                        print "$1 \];\n";
                        $flag = 0;
                        $num += 1;
                }
                elsif(/^\s+Actual - Optimal Len.*:\s+(\d+)/o) {
                        print "$1 ";
                }
                
                next;
       }

        if(/^\s+$S[$num]/) {
                $flag = 1;
                print "$NAME[$num] = \[ ";
        }
}

# ======================================================================

sub init_t {
        $T[1] = "CBR TOTALS ${node} Transmitted";
        $T[2] = "CBR TOTALS ${node} Received";
        $T[3] = "CBR TOTALS ${node} Forwards";
        $T[4] = "CBR TOTALS ${node} Drops";
}

sub init_n {
        $N[1] = "t.cbr_tx_${node}";
        $N[2] = "t.cbr_rx_${node}";
        $N[3] = "t.cbr_fw_${node}";
        $N[4] = "t.cbr_dr_${node}";
}

$flag = 0;
$node = 1;
$num = 1;
$maxnum = 5;

init_t();
init_n();

while(<$infile>) {

        if($num == $maxnum) {
                $num = 1;               # the next node
        }

	$line += 1;

        if($flag == 1) {

                if(/^\s+Packets:\s+(\d+)/o) {
                        print "$1 ";
                }
                elsif(/^\s+Bytes:\s+(\d+)/o) {
			print "$1 ";
			if($num != 4) {
				print "\];\n";
				$flag = 0;
				$num += 1;
			}
                }

		#
		# CBR MAC Drops
		#
		elsif($num == 4) {

			if(/^\s+Collision:\s+(\d+)/o) {
				print "$1 ";
			}
			elsif(/^\s+Duplicate:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+CRC Invalid:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Max Retries:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Invalid State:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Busy:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
			}

			#
			# CBR RTR Drops
			#
			elsif(/^\s+No Route:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+TTL Expired:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+RTR Queue Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Timeout:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Routing Loop:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+ARP Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+IFQ Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Callback:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
                                $node += 1;
                                init_t();
                                init_n();
			}
			else {
                                print stderr "Input Error in line $line\n$_\n";
                                exit 1;
			}
		}
                next;
        }

        if(/^\s+$T[$num]/) {
                $flag = 1;
                print "$N[$num] = \[ ";
        }
}

