#! /bin/sh
# $Id: make-cbr-files.sh,v 1.1.1.1 2001/06/20 15:37:54 benjie Exp $

# produces directory hierarchy of cbr scripts with paths in the
# following format:

# ./num-nodes/side-length/pkts-per-conn/num-conn 

# num-conn is either 3n (each node connects to 3 others) or nn (each
# node connects to every other node)

# traffic is generated to occur between 10 and 400 seconds; the
# `empty' 10 seconds in the beginning allows the routing protocols and
# location service etc. to initialize.

# first argument is the directory holding ns

cbr_dir=`pwd`
echo "working in cbr dir $cbr_dir"

ns=$1/ns
cbrgen_nn=$1/cmu/scripts/cbrgen-nn.tcl
cbrgen_cn=$1/cmu/scripts/cbrgen-cn.tcl
rate=4.0
c=3

# fill in actual packet/num-conns dirs and cbr files
function make_cbr_files () { # dir, n, side length

    dir=$1
    n=$2
    length=$3
    last_dir=$dir/$n/$length

    if [ ! -d $dir/$n ] ; then
	mkdir $dir/$n
    fi
    if [ ! -d $last_dir ] ; then
	mkdir $last_dir
    fi

    for num_pkts in 800 6
    do 
	if [ ! -d $last_dir/$num_pkts ] ; then
	     mkdir $last_dir/$num_pkts
	fi
	# make the cbr files
	$ns $cbrgen_nn -type cbr -nn $n -seed $RANDOM -rate $rate -numpackets $num_pkts > $last_dir/$num_pkts/nn
	$ns $cbrgen_cn -type cbr -nn $n -seed $RANDOM -rate $rate -numpackets $num_pkts -c $c > $last_dir/$num_pkts/${c}n
    done
}
	

# build cbr script hierarchy for n, length

for length in 500 700 800
do
    make_cbr_files $cbr_dir 50 $length
done

for length in 700 1000 1200
do
    make_cbr_files $cbr_dir 100 $length
done

for length in 800 1200 1500
do
    make_cbr_files $cbr_dir 150 $length
done

for length in 1000 1400 1700
do
    make_cbr_files $cbr_dir 200 $length
done

for length in 1100 1500 1900
do
    make_cbr_files $cbr_dir 250 $length
done


for length in 1200 1700 2100
do
    make_cbr_files $cbr_dir 300 $length
done

