# cbrgen-nn.tcl
# $Id: cbrgen-nn.tcl,v 1.1.1.1 2001/06/20 15:37:53 benjie Exp $
# make n^2 conns. across n nodes

# ======================================================================
# Default Script Options
# ======================================================================
set opt(nn)		0		;# Number of Nodes
set opt(seed)		0.0
set opt(pktsize)	128
set opt(numpackets)     0

set opt(rate)		0
set opt(interval)	0.0		;# inverse of rate
set opt(type)           ""

# ======================================================================

proc usage {} {
    global argv0

    puts "\nusage: $argv0 \[-type cbr|tcp\] \[-nn nodes\] \[-seed seed\] \[-rate rate\] \[-numpackets pkts-per-conn\]\n"
}

proc getopt {argc argv} {
	global opt
	lappend optlist nn seed rate type numpackets

	for {set i 0} {$i < $argc} {incr i} {
		set arg [lindex $argv $i]
		if {[string range $arg 0 0] != "-"} continue

		set name [string range $arg 1 end]
		set opt($name) [lindex $argv [expr $i+1]]
	}
}

proc create-cbr-connection { src dst } {
	global rng cbr_cnt opt

	set stime [$rng uniform 10.0 400.0]

	puts "#\n# $src connecting to $dst at time $stime\n#"

	puts "set cbr_($cbr_cnt) \[\$ns_ create-connection \
		CBR \$node_($src) CBR \$node_($dst) 0\]";

	puts "\$cbr_($cbr_cnt) set packetSize_ $opt(pktsize)"
	puts "\$cbr_($cbr_cnt) set interval_ $opt(interval)"
	puts "\$cbr_($cbr_cnt) set random_ 1"
	puts "\$cbr_($cbr_cnt) set maxpkts_ $opt(numpackets)"
	
	puts "\$ns_ at $stime \"\$cbr_($cbr_cnt) start\""
}

proc create-tcp-connection { src dst } {
	global rng cbr_cnt opt

	set stime [$rng uniform 10.0 400.0]

	puts "#\n# $src connecting to $dst at time $stime\n#"

	puts "set tcp_($cbr_cnt) \[\$ns_ create-connection \
		TCP \$node_($src) TCPSink \$node_($dst) 0\]";
	puts "\$tcp_($cbr_cnt) set window_ 32"
	puts "\$tcp_($cbr_cnt) set packetSize_ $opt(pktsize)"

	puts "set ftp_($cbr_cnt) \[\$tcp_($cbr_cnt) attach-source FTP\]"


	puts "\$ns_ at $stime \"\$ftp_($cbr_cnt) start\""

}

# ======================================================================

getopt $argc $argv

if { $opt(type) == "" } {
    usage
    exit
} elseif { $opt(type) == "cbr" } {
    if { $opt(nn) == 0 || $opt(seed) == 0.0 || $opt(rate) == 0  || $opt(numpackets) == 0} {
	usage
	exit
    }

    set opt(interval) [expr 1 / $opt(rate)]
    if { $opt(interval) <= 0.0 } {
	puts "\ninvalid sending rate $opt(rate)\n"
	exit
    }
}

puts "#\n# nodes: $opt(nn), send rate: $opt(interval), seed: $opt(seed)\n#"

set rng [new RNG]
$rng seed $opt(seed)

set u [new RandomVariable/Uniform]
$u set min_ 0
$u set max_ 100
$u use-rng $rng

set cbr_cnt 0

for {set i 1} {$i <= $opt(nn) } {incr i} {
    for {set j 1} {$j <= $opt(nn) } {incr j} {

	if {$i == $j} {continue }

	if { $opt(type) == "cbr" } {
		create-cbr-connection $i $j
	} else {
		create-tcp-connection $i $j
	}

	incr cbr_cnt
    }
}



