#ifndef __rtable_h__
#define __rtable_h__

#include <assert.h>
#include <sys/types.h>

#include <config.h>
#include <list.h>
#include <scheduler.h>

#define CURRENT_TIME    Scheduler::instance().clock()

/* =====================================================================
   Neighbor Cache Entry
   ===================================================================== */
class Neighbor {
        friend class AODV;
        friend class rt_entry;
 public:
        Neighbor(u_int32_t a) { nb_addr = a; }

 protected:
        LIST_ENTRY(Neighbor) nb_link;
        nsaddr_t        nb_addr;
        double          nb_expire;      // ALLOWED_HELLO_LOSS * HELLO_INTERVAL
};

LIST_HEAD(ncache, Neighbor);


/* =====================================================================
   Route Table Entry
   ===================================================================== */

class rt_entry {
        friend class rttable;
        friend class AODV;
 public:
        rt_entry();
        ~rt_entry();

        void            nb_insert(nsaddr_t id);
        Neighbor*       nb_lookup(nsaddr_t id);

 protected:
        LIST_ENTRY(rt_entry) rt_link;
        nsaddr_t        rt_dst;
        u_int32_t       rt_seqno;
        nsaddr_t        rt_nexthop;     // next hop IP address

        double          rt_expire;      // when entry expires
        u_int16_t       rt_hops;        // hop count
        u_int8_t        rt_flags;
#define RTF_UP 0x01

        /*
         *  Must receive 4 errors within 3 seconds in order to mark
         *  the route down.
         */
        u_int8_t        rt_errors;      // error count
        double          rt_error_time;
#define MAX_RT_ERROR            4       // errors
#define MAX_RT_ERROR_TIME       3       // seconds

        double          rt_req_timeout;         // when I can send another req
        u_int8_t        rt_req_cnt;             // number of route requests

        /*
         * a list of neighbors that are using this route.
         */
        ncache          rt_nblist;
};


/* =====================================================================
   The Routing Table
   ===================================================================== */
class rttable {
 public:
	rttable() { LIST_INIT(&rthead); }

        rt_entry*       head() { return rthead.lh_first; }

        rt_entry*       rt_lookup(nsaddr_t id);
        void            rt_delete(nsaddr_t id);
        rt_entry*       rt_add(nsaddr_t id);
 private:
        LIST_HEAD(, rt_entry) rthead;
};

#endif /* __rtable_h__ */
