#ifndef __quadtree_h__
#define __quadtree_h__
#include "list.h"

class qtree_node{
    public:
	qtree_node() {}
	double x; 
	double y;
	void *node;
	LIST_ENTRY(qtree_node) node_link;
};

class Quadtree {

public:
    Quadtree(double nwX,double nwY,double seX,double seY,int l,Quadtree *par,int ct);
    ~Quadtree();

    //just to make deletion faster, i require nodes to 
    //remember their position in the linked list
    void insertNode(double x, double y, void *obj, qtree_node *&, Quadtree *&);
    void deleteNode(qtree_node *pos);

    Quadtree *getNeighbor(int which_nb);

    Quadtree **children; //pointer to my four children if any
    Quadtree *parent;
    int child_type;
    LIST_HEAD(,qtree_node) head;

    int level;

    double nw_x,nw_y,se_x,se_y;
};

#endif /* __quadtree_h__ */
