#ifndef __mac_timers_h__
#define __mac_timers_h__

/* ======================================================================
   Timers
   ====================================================================== */
class Mac802_11;

class MacTimer : public Handler {
public:
	MacTimer(Mac802_11* m, double s = 0) : mac(m), slottime(s) {
		busy_ = paused_ = 0; stime = rtime = 0.0;
	}

	virtual void handle(Event *e) = 0;

	virtual void start(double time, const char *description=0);
	virtual void stop(void);
	virtual void pause(void) { assert(0); }
	virtual void resume(void) { assert(0); }

	inline int busy(void) { return busy_; }
	inline int paused(void) { return paused_; }
	inline double expire(void) {
		return ((stime + rtime) - Scheduler::instance().clock());
	}
	inline int expired(void) {
	    return (expire() <= 0.0) ? 1 : 0;
	}

protected:
	Mac802_11	*mac;
	int		busy_;
	int		paused_;
	Event		intr;
	double		stime;	// start time
	double		rtime;	// remaining time
	double		slottime;
};

class BackoffInterruptTimer : public MacTimer{
    public:
	BackoffInterruptTimer(Mac802_11 *m, double s) : MacTimer(m,s) {}
	void handle(Event *e);
};

class BackoffTimer : public MacTimer {
public:
	BackoffTimer(Mac802_11 *m, double s) : MacTimer(m, s), total_bftime(0.0),difs_wait(0.0) {interrupt_timer = new BackoffInterruptTimer(m,s); }

	void	start(int cw, double correction, 
		      int idle, const char *description = 0);
	void	handle(Event *e);
	void	pause(void);
	void    stop(void);
	void	resume(double difs);

	/* added by jinyang -- to keep track of backoff time */
	double total_bftime;

	char*   description() { return intr.description_; }

private:
	double	difs_wait;

	//jinyang -- to count the wasted backoff time in seconds
	Event	interrupt_event;
	BackoffInterruptTimer *interrupt_timer;
};

class DeferTimer : public MacTimer {
public:
	DeferTimer(Mac802_11 *m, double s) : MacTimer(m,s) {}

	void    pause(void);
	void	start(double, const char *description = 0);
	void	handle(Event *e);
};

class IFTimer : public MacTimer {
public:
	IFTimer(Mac802_11 *m) : MacTimer(m) {}

	void	handle(Event *e);
};

class NavTimer : public MacTimer {
public:
	NavTimer(Mac802_11 *m) : MacTimer(m) {}

	void	handle(Event *e);
};

class RxTimer : public MacTimer {
public:
	RxTimer(Mac802_11 *m) : MacTimer(m) {}

	void	handle(Event *e);
};

class TxTimer : public MacTimer {
public:
	TxTimer(Mac802_11 *m) : MacTimer(m) {}

	void	handle(Event *e);
};

class TBTTTimer : public MacTimer {
  public:
    TBTTTimer(Mac802_11 *m) : MacTimer(m) {}
    void handle(Event *e);
};

class BeaconTimer : public MacTimer {
  public:
    BeaconTimer(Mac802_11 *m) : MacTimer(m) {}
    void handle(Event *e);
};

class AdvEndTimer : public MacTimer {
  public:
    AdvEndTimer(Mac802_11 *m) : MacTimer(m) {}
    void handle(Event *e);
};

class ATIMEndTimer : public MacTimer {
  public:
    ATIMEndTimer(Mac802_11 *m) : MacTimer(m) {}
    void handle(Event *e);
};

#endif /* __mac_timers_h__ */

