/* 802.11 MAC MLME Functionality */
/* author: Kyle Jamieson <jamieson@mit.edu> */

#ifndef __mac_802_11_mlme_h__
#define __mac_802_11_mlme_h__

#include <packet.h>
#include <cmu/mac-802_11.h>

// since headers in ns must be fixed-length, we specifiy the
// maximum-length values for variable-length fields, and calculate the
// correct transmission times elsewhere.

const int MAX_SSID_INFO_LEN = 8;
const int MAX_RATES_LEN = 8;
const int MAX_PVB_LEN = 251;

// XXXXXX below is unused for DSSS XXXXXXX.

const int mac_802_11_p_usa = 79;
const int mac_802_11_hop_seq_usa[] = { 
    -1, // note: unused elt
    0, 23, 62, 8, 43, 16, 71, 47, 19, 61,
    76, 29, 59, 22, 52, 63, 26, 77, 31, 2,
    18, 11, 36, 71, 54, 69, 21, 3, 37, 10,
    34, 66, 7, 68, 75, 4, 60, 27, 12, 25,
    14, 57, 41, 74, 32, 70, 9, 58, 78, 45,
    20, 73, 64, 39, 13, 33, 65, 50, 56, 42,
    48, 15, 5, 17, 6, 67, 49, 40, 1, 28,
    55, 35, 53, 24, 44, 51, 38, 30, 46
};

const int mac_802_11_p_spain = 27;
const int mac_802_11_hop_seq_spain[] = {
    -1, // note: unused elt
    13, 4, 24, 18, 5, 12, 3, 10, 25,
    19, 8, 23, 15, 22, 9, 21, 0, 6,
    14, 1, 20, 7, 16, 2, 11, 17, 26
};

const int mac_802_11_p_france = 35;
const int mac_802_11_hop_seq_france[] = {
    -1, // note: unused elt
    17, 5, 18, 32, 23, 7, 16, 4, 13, 33, 26, 10,
    31, 20, 29, 22, 12, 6, 28, 14, 25, 0, 8, 1,
    15, 3, 11, 30, 24, 9, 27, 19, 2, 21, 34
};

struct management_frame {
    u_char mf_fcs[ETHER_FCS_LEN];    
};

struct cap_info {
    u_char ci_ess : 1;
    u_char ci_ibss : 1;
    u_char ci_cfpollable : 1;
    u_char ci_cfpollreq : 1;
    u_char ci_privacy : 1;
    u_int16_t ci_reserved : 11;
};

struct ssid {
    u_int8_t ssid_eid;
    u_int8_t ssid_length;
    u_char ssid_id[MAX_SSID_INFO_LEN];
};

struct supported_rates {
    u_int8_t sr_eid;
    u_int8_t sr_length;
    u_char sr_rates[MAX_RATES_LEN];
};

struct fh_param_set {
    u_int8_t fps_eid;
    u_int8_t fps_length;
    u_int16_t fps_dwelltime;
    u_int8_t fps_hopset;
    u_int8_t fps_hoppat;
    u_int8_t fps_hopind;
};

struct cf_param_set {
    u_int8_t cps_eid;
    u_int8_t cps_length;
    u_int8_t cps_cfp_count;
    u_int8_t cps_cfp_period;
    u_int16_t cps_maxdur;
    u_int8_t cps_durrem;
};

struct ibss_param_set {
    u_int8_t ips_eid;
    u_int8_t ips_length;
    u_int16_t ips_atim_wind;
};

struct tim {
    u_int8_t tim_eid;
    u_int8_t tim_length;
    u_int8_t tim_dtim_cnt;
    u_int8_t tim_dtim_pd;
    u_int8_t tim_bitmap_ctrl;
    u_char tim_pvb[MAX_PVB_LEN];
};

struct beacon_body {
    // value of the TSF timer
    u_int64_t bb_ts;
    u_int16_t bb_bi;
    struct cap_info bb_ci;
    struct ssid bb_ssid;
    struct supported_rates bb_sr;
    struct fh_param_set bb_fps;
    u_int8_t bb_dps;
    struct cf_param_set bb_cps;
    struct ibss_param_set bb_ips;
    struct tim bb_tim;
};

struct hdr_beacon {
    static int offset_;

    struct beacon_body bh_bb;
    u_char _bh_fcs[ETHER_FCS_LEN];
};

int ssid_size(struct ssid *);
int supported_rates_size(struct supported_rates *);
int tim_size(struct tim *);

#endif /* __mac_802_11_mlme_h__ */
