/* -*- c++ -*-
   debug.h
   $Id: debug.h,v 1.1.1.1 2001/06/20 15:37:50 benjie Exp $
   */
#ifndef __debug_h__
#define __debug_h__

#include <assert.h>
#include <string.h>

#include <sys/types.h>

// #define DEBUG

#ifdef DEBUG

#define SHOW_NAME(s)	\
	fprintf(stderr, "%s --- (%x) %s\n", __PRETTY_FUNCTION__, this, s);

#define SHOW_DONE()	SHOW_NAME("END")

#define SHOW_TIME()	\
	fprintf(stderr, "%s\t--- time: %f\n", __PRETTY_FUNCTION__, s.clock());

#define SHOW_ARGS()						\
	for(int i = 0; i < argc; i++)				\
		fprintf(stderr, "%2d - %s\n", i, argv[i]);

#define SHOW_EVENT(event, msg)					\
	fprintf(stderr, "\n%s --- (%x)\n\tEvent: %x\t%s\n",	\
		__PRETTY_FUNCTION__, this, event, msg);

#else /*DEBUG */

#define SHOW_NAME(s) {}
#define SHOW_TIME() {}
#define SHOW_ARGS() {}
#define SHOW_EVENT(event, msg) {}
#define SHOW_DONE() {}

#endif /* DEBUG */

struct hb {
  struct hb *next;
  void *d;
  void *value;
};

class HashSet {
public:
  HashSet(char *n) : name(n) {
    tbl_sz = 1024 * 128 + 1; max_hb = 0; htbl = new struct hb *[tbl_sz]; 
    bzero(htbl, sizeof(struct hb*) * tbl_sz); hb_freelist = 0; }
  inline int bucket(void *p);
  inline struct hb** find(void *p);
  inline void insert(void *p, void *value = 0);
  inline void remove(struct hb **);

  int max_hb;

private:
  int tbl_sz;
  char *name;
  struct hb **htbl;
  struct hb *hb_freelist;
};

inline int
HashSet::bucket(void *p)
{
  return ((u_int32_t)p>>4) % tbl_sz;
}

inline struct hb ** 
HashSet::find(void *p)
{
  struct hb **ans;
  int b = bucket(p);
  for (ans = &htbl[b]; *ans != 0; ans = &((*ans)->next))
    {
      if ((*ans)->d == p) return ans;
    }
  return 0;
}

inline void
HashSet::insert(void *p, void *value = 0)
{
  struct hb *n;
  int b = bucket(p);
  if (NULL == hb_freelist) 
    {
      n = (struct hb*)malloc(sizeof(struct hb));
      assert(n != 0);
      max_hb++;
    }
  else
    {
      n = hb_freelist;
      hb_freelist = hb_freelist->next;
    }
  
  n->d = p;
  n->value = value;
  n->next = htbl[b];
  htbl[b] = n;
}

inline void
HashSet::remove(struct hb **hbp)
{
  struct hb *t = (*hbp)->next;
  (*hbp)->next = hb_freelist;
  hb_freelist = *hbp;
  *hbp = t;
}


#endif /* __debug_h__ */
