/* adhockey-slave.cc
   $Id: adhockey-slaver.cc,v 1.1.1.1 2001/06/20 15:37:50 benjie Exp $
   
   remotely drive an ad-hockey visualizer that is slaved to us
   */
#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdlib.h>
#include <unistd.h>
#include <assert.h>

#include <object.h>
#include <scheduler.h>

class AdHockeySlaver: public NsObject {
public:
  AdHockeySlaver();

  virtual int command(int argc, const char*const* argv);
  void handle(Event*);
  void recv(class Packet *, class Handler *) {abort();}

private:
  void Startup();
  void Shutdown();

  Event	intr;
  double interval_;		// how often to send info
  
  int running;
  int fd;			// socket to send msgs on

  // location of slaved node
  struct sockaddr_in sin;
};

static class AdHockeySlaverclass : public TclClass {
public:
        AdHockeySlaverclass() : TclClass("AdHockeySlaver") {}
        TclObject* create(int, const char*const* ) {
	  return (new AdHockeySlaver);
        }
} class_AdHockeySlaver;

AdHockeySlaver::AdHockeySlaver() 
{
  bzero(&sin, sizeof(sin));
  sin.sin_family = AF_INET;
  // sin.sin_len = sizeof(sin);

  inet_aton("127.0.0.1",&sin.sin_addr);
  sin.sin_port = htons(3636);

  interval_ = 10.0;		// default to 10secs
  bind_time("interval_",&interval_);
  running = 0;
}


int
AdHockeySlaver::command(int argc, const char*const* argv)
{
  Tcl& tcl = Tcl::instance();

  if (argc == 2) {
    if(strcasecmp(argv[1], "start") == 0) {
      Startup();
      return TCL_OK;
    }               
    else if(strcasecmp(argv[1], "stop") == 0) {
      if (running) {
	Shutdown();
	return TCL_OK;
      } else {
	tcl.result("Not currently running");
	return TCL_ERROR;
      }
    }               
  } else if(argc == 3) {

    if(strcmp(argv[1], "ip-addr") == 0) {
      if (inet_aton(argv[2],&sin.sin_addr) <= 0) {
	tcl.result("can't interpret as dotted quad ip address");
	return TCL_ERROR;
      }
      return TCL_OK;
    }
    else if(strcmp(argv[1], "port") == 0) {
      sin.sin_port = htons(atoi(argv[2]));
      return TCL_OK;
    }
  }
  
  tcl.result("unknown command");
  return TCL_ERROR;
}

void
AdHockeySlaver::Startup() 
{
  if (running) return;

  assert(interval_ > 0.0 && "AdHockeySlaver interval must be > 0");

  fd = socket(AF_INET, SOCK_DGRAM, 0);
  if (fd < 0) { perror("adhockey slave socket"); abort(); }  

  handle((Event*) 0);
}

void
AdHockeySlaver::Shutdown() 
{
  assert(running);
  close(fd);
  Scheduler::instance().cancel(&intr);
  running = 0;
}

void
AdHockeySlaver::handle(Event *)
{
  u_int32_t time;
  
  // format the message
  time = htonl((u_int32_t) Scheduler::instance().clock());

  if (0 > sendto(fd, (char *)&time, sizeof(time), 0, 
		 (struct sockaddr*)&sin, sizeof(sin))){
    perror("sending from adhockey slave socket");
    abort();
  }

  Scheduler::instance().schedule(this,&intr,interval_);
}
