/*
 * Copyright (C) 1997 Massachusetts Institute of Technology 
 *
 * This software is being provided by the copyright holders under the
 * following license. By obtaining, using and/or copying this software,
 * you agree that you have read, understood, and will comply with the
 * following terms and conditions:
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose and without fee or royalty is
 * hereby granted, provided that the full text of this NOTICE appears on
 * ALL copies of the software and documentation or portions thereof,
 * including modifications, that you make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS. COPYRIGHT
 * HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE OR
 * DOCUMENTATION.
 *
 * The name and trademarks of copyright holders may NOT be used in
 * advertising or publicity pertaining to the software without specific,
 * written prior permission. Title to copyright in this software and any
 * associated documentation will at all times remain with copyright
 * holders. See the file AUTHORS which should have accompanied this software
 * for a list of all copyright holders.
 *
 * This file may be derived from previously copyrighted software. This
 * copyright applies only to those changes made by the copyright
 * holders listed in the AUTHORS file. The rest of this file is covered by
 * the copyright notices, if any, listed below.
 */

#include <kern/inc/env.h>
#include <kern/inc/pmap.h>
#include <kern/inc/syscall.h>
#include <kern/inc/console.h>
#include <kern/inc/printf.h>



// Dispatches to the correct kernel function, passing the arguments.

int
dispatch_syscall (u_int sn, u_int a1, u_int a2, u_int a3)
{
}

// returns the current environment id
u_int
sys_getenvid ()
{
  return curenv->env_id;
}

// prints the integer to the screen.
void
sys_cputu (u_int value)
{
  printf ("%d", value);
}

// prints the string to the screen.
void
sys_cputs (char *s)
{
  printf ("%s", s);
}

// deschedule current environment
void
sys_yield ()
{
  yield ();
}

// destroys the current environment
void
sys_env_destroy ()
{
  env_destroy (curenv);
}

// Allocates a new (child) environment.
//
// The state of the child is initialized as follows:  
//    env_parent_id -- set the the curenv's id
//    env_status  -- set to ENV_NOTRUNNABLE
//    env_xstacktop -- inherited from parent
//    env_pgfault_handler -- ditto
//    env_tf -- set so that the child
//              resumes execution at the point where the parent 
//              made the call to sys_env_alloc
//    env_tf.tf_eax -- set to 0, so that the child observes a 0
//                     return value
//    env_* -- All other fields are left to the values to which env_alloc
//             initialized them.
//
// RETURNS
//  <0 on error
//  otherwise envid of the new environment
//
int
sys_env_alloc ()
{
}


// clears curenv->env_ipc_blocked
void
sys_ipc_unblock ()
{
}

// Sends the 'value' to the target env 'envid'.
//
// The send fails, with a return value of -E_IPC_BLOCKED if the
// target's env_ipc_blocked field is set.
//
// Otherwise, the send succeeds, and the target's ipc fields are
// updated as follows:
//    env_ipc_block is set to 1 to block further IPCs
//    env_ipc_from is set to the sending envid
//    env_ipc_value is set to the 'value' parameter
//
// RETURNS
//  0 -- on success
//  <0 -- on error
int
sys_ipc_send (u_int envid, u_int value)
{
}

// Sets the current env's pagefault handler entry point and exception
// stack.
//
// xstacktop points one byte past exception stack
//
void
sys_set_pgfault_handler (u_int func, u_int xstacktop)
{
  curenv->env_pgfault_handler = func;
  curenv->env_xstacktop = xstacktop;
}


// Sets envid's env_status to status. 
//
// envid==0, means the current environment.
//
//RETURNS
// 0 -- on sucess
// <0 -- on error
//       envid must be 0, the current env's envid of a child of the
//       current environment => E_BAD_ENV

int
sys_set_env_status (u_int envid, u_int status)
{
  struct Env *env;
  int r;

  // 0 means self
  if (envid == 0)
    env = curenv;
  else if (!(env = envid2env (envid, &r)))
    return r;
  else if (env->env_parent_id != curenv->env_id)
    return -E_BAD_ENV;
  
  env->env_status = status;
  return 0;
}


// Modifies the permission for the page of memory at the virtual
// address 'va'.
//
// 'add' -- these permission bits are turned on
// 'del' -- these permission bits are turned off
//
// Upon the completion of this function the permission bits of the
// PTE must satifies:
// permission -- PG_U|PG_P are required,
//               PG_USER|PG_W are optional,
//               but not other bits are allowed
//
// The tlb is invalidated for 'va'.
//
//RETURNS
//  0 -- on success
//  <0 -- on error
//     va must be less than UTOP => -E_INVAL
//     the is no PTE corresponding to va => -E_INVAL
//     permission violation => -E_INVAL
int
sys_mod_perms (u_int va, u_int add, u_int del)
{
}

//
// Allocates a page of memory and maps it at 'va' with permission
// 'perm' in the address space of 'envid'.
//
// If a page is already mapped at 'va', it is unmapped as a
// side-effect.
//
// envid==0, means the current environment.
//
// perm -- PG_U|PG_P are required, 
//         PG_USER|PG_W are optional,
//         but not other bits are allowed
//
//RETURNS
// 0 -- on sucess
// <0 -- on error:
//    - va >= UTOP
//    - A env may modify its own address space or the address space of
//      its children.
//    - permission violation
//    - plus others.
int
sys_mem_alloc (u_int envid, u_int va, u_int perm)
{
}


//
// Remaps the page of memory at 'srcva' (in the current address space)
// at the address 'va' in the address space of 'envid' with permission
// 'perm'.
// envid==0, means the current environment.
//
// perm -- PG_U|PG_P are required, 
//         PG_USER|PG_W are optional,
//         but not other bits are allowed
//
//RETURNS
// 0 -- on sucess
// <0 -- on error:
//    - va >= UTOP
//    - srcva >= UTOP
//    - A env may modify its own address space or the address space of
//      its child.
//    - No page is mapped at 'srcva'
//    - permission violation
//    - plus others..

int
sys_mem_remap (u_int srcva, u_int envid, u_int va, u_int perm)
{
}


//
// Unmaps the page of memory at 'va' in the address space of 'envid'
// envid==0, means the current environment.
// (if no page is mapped, the function silently succeeds)
//
//RETURNS
// 0 -- on sucess
// <0 -- on error:
//    - va >= UTOP
//    - srcva >= UTOP
//    - A env may modify its own address space or the address space of
//      its child.
//    - No page is mapped at 'srcva'
//    - permission violation
//    - plus others..
int
sys_mem_unmap (u_int envid, u_int va)
{
}

