#ifndef _SYSCALL_H_
#define _SYSCALL_H_

#include <kern/inc/types.h>
#include <kern/inc/trap.h>

#define SYS_getenvid 0x0
#define SYS_yield 0x1
#define SYS_env_free 0x2
#define SYS_env_alloc 0x3
#define SYS_cputs 0x4
#define SYS_cputu 0x5
#define SYS_ipc_send 0x6
#define SYS_ipc_unblock 0x7
#define SYS_set_pgfault_handler 0x8
#define SYS_mod_pte 0x9
#define SYS_insert_pte 0xa
#define SYS_set_env_status 0xb

#define MAX_SYSCALL SYS_set_env_status

#define E_UNSPECIFIED	1	/* Unspecified or unknown problem */
#define E_BAD_ENV       2       /* Environment doesn't exist or otherwise
				   cannot be used in requested action */
#define E_INVAL		3	/* Invalid parameter */
#define E_NO_MEM	4	/* Request failed due to memory shortage */
#define E_NO_FREE_ENV   5       /* Attempt to create a new environment beyond
				   the maximum allowed */
#define E_IPC_BLOCKED   6       /* Attempt to ipc to env blocking ipc's */

#ifdef KERNEL

int dispatch_syscall (u_int, u_int, u_int, u_int);
u_int sys_getenvid ();
void sys_yield ();
void sys_env_free ();
int sys_env_alloc ();
void sys_cputs (char *);
void sys_cputu (u_int);
int sys_ipc_send (u_int, u_int);
void sys_ipc_unblock ();
void sys_set_pgfault_handler (u_int);
int sys_mod_pte (u_int, u_int, u_int);
int sys_insert_pte (u_int, u_int, u_int);
int sys_set_env_status (u_int, u_int);


#else

static inline int
sys_call (int sn, u_int a1, u_int a2, u_int a3)
{
  int ret;
  __asm __volatile ("int %5\n"
                    : "=a" (ret)
		    : "a" (sn), "b" (a3), "c" (a2), "d" (a1), "i" (T_SYSCALL)
		    : "cc", "memory");
  return (ret);
}

static inline u_int
sys_getenvid (void)
{
  return sys_call (SYS_getenvid, 0, 0, 0);
}

static inline void
sys_yield (void)
{
  (void) sys_call (SYS_yield, 0, 0, 0);
}

static inline void
sys_env_free (void)
{
  (void) sys_call (SYS_env_free, 0, 0, 0);
}

static inline int
sys_env_alloc (void)
{
  return sys_call (SYS_env_alloc, 0, 0, 0);
}

static inline void
sys_cputs (char *a1)
{
  (void) sys_call (SYS_cputs, (u_int) a1, 0, 0);
}

static inline void
sys_cputu (u_int a1)
{
  (void) sys_call (SYS_cputu, a1, 0, 0);
}

static inline int
sys_ipc_send (u_int a1, u_int a2)
{
  return sys_call (SYS_ipc_send, a1, a2, 0);
}

static inline void
sys_ipc_unblock (void)
{
  (void) sys_call (SYS_ipc_unblock, 0, 0, 0);
}

static inline void
sys_set_pgfault_handler (u_int a1)
{
  (void) sys_call (SYS_set_pgfault_handler, a1, 0, 0);
}

static inline int
sys_mod_pte (u_int a1, u_int a2, u_int a3)
{
  return sys_call (SYS_mod_pte, a1, a2, a3);
}

static inline int
sys_insert_pte (u_int a1, u_int a2, u_int a3)
{
  return sys_call (SYS_insert_pte, a1, a2, a3);
}

static inline int
sys_set_env_status (u_int a1, u_int a2)
{
  return sys_call (SYS_set_env_status, a1, a2, 0);
}

#endif /* KERNEL */

#endif /* !_SYSCALL_H_ */
