
/*
 * Copyright (C) 1997 Massachusetts Institute of Technology 
 *
 * This software is being provided by the copyright holders under the
 * following license. By obtaining, using and/or copying this software,
 * you agree that you have read, understood, and will comply with the
 * following terms and conditions:
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose and without fee or royalty is
 * hereby granted, provided that the full text of this NOTICE appears on
 * ALL copies of the software and documentation or portions thereof,
 * including modifications, that you make.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED. BY WAY OF EXAMPLE,
 * BUT NOT LIMITATION, COPYRIGHT HOLDERS MAKE NO REPRESENTATIONS OR
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR
 * THAT THE USE OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY
 * THIRD PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS. COPYRIGHT
 * HOLDERS WILL BEAR NO LIABILITY FOR ANY USE OF THIS SOFTWARE OR
 * DOCUMENTATION.
 *
 * The name and trademarks of copyright holders may NOT be used in
 * advertising or publicity pertaining to the software without specific,
 * written prior permission. Title to copyright in this software and any
 * associated documentation will at all times remain with copyright
 * holders. See the file AUTHORS which should have accompanied this software
 * for a list of all copyright holders.
 *
 * This file may be derived from previously copyrighted software. This
 * copyright applies only to those changes made by the copyright
 * holders listed in the AUTHORS file. The rest of this file is covered by
 * the copyright notices, if any, listed below.
 */


/*-
 * Copyright (c) 1993, 1994, 1995 Charles Hannum.  All rights reserved.
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz and Don Ahn.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* This code isn't actually from NetBSD, but I consulted the NetBSD
 * pccons driver heavily and copied some chunks like the scan codes,
 * hence the above copyright probably applies.
 */

#include <kern/inc/x86.h>
#include <kern/inc/pmap.h>
#include <kern/inc/console.h>
#include <kern/inc/mmu.h>
#include <kern/inc/printf.h>

static unsigned addr_6845;
static unsigned short *crt_buf;
static short crt_pos;

void
cninit (void)
{
  unsigned short volatile *cp;
  unsigned short was;
  unsigned cursorat;

  cp = (short *) (KERNBASE + CGA_BUF);
  was = *cp;
  *cp = (unsigned short) 0xA55A;
  if (*cp != 0xA55A) {
    cp = (short *) (KERNBASE + MONO_BUF);
    addr_6845 = MONO_BASE;
  } else {
    *cp = was;
    addr_6845 = CGA_BASE;
  }
  
  /* Extract cursor location */
  outb(addr_6845, 14);
  cursorat = inb(addr_6845+1) << 8;
  outb(addr_6845, 15);
  cursorat |= inb(addr_6845+1);

  crt_buf = (unsigned short *)cp;
  crt_pos = cursorat;
}


void
cnputc(short int c)
{
  /* if no attribute given, then use black on white */
  if (!(c & ~0xff)) c |= 0x0700;

  switch (c & 0xff) {
  case '\b':
    if (crt_pos > 0)
      crt_pos--;
    break;
  case '\n':
    crt_pos += CRT_COLS;
    /* cascade  */
  case '\r':
    crt_pos -= (crt_pos % CRT_COLS);
    break;
  case '\t':
    cnputc (' ');
    cnputc (' ');
    cnputc (' ');
    cnputc (' ');
    cnputc (' ');
    break;
  default:
    crt_buf[crt_pos++] = c;   /* write the character */
    break;
  }

  // What is the purpose of this?
  if (crt_pos >= CRT_SIZE) {
    int i;
    bcopy (crt_buf + CRT_COLS, crt_buf, CRT_SIZE << 1);
    for (i = CRT_SIZE - CRT_COLS; i < CRT_SIZE; i++)
      crt_buf[i] = 0x0700 | ' ';
    crt_pos -= CRT_COLS;
  }

  /* move that little blinky thing */
  outb(addr_6845, 14);
  outb(addr_6845+1, crt_pos >> 8);
  outb(addr_6845, 15);
  outb(addr_6845+1, crt_pos);
}
