#include "common.h"	
	
###################################################################
# The kernel (this code) is linked at address ~(KERNBASE + 1 Meg), 
# but the bootloader load it at address	~1 Meg.
#	
# LINK2LOAD(x) maps a symbol x from its link address to its actual
# location in physical memory (its load address).
###################################################################

#define	LINK2LOAD(x) ((x) - KERNBASE)

###################################################################
# boot stack
###################################################################
.data
	.p2align	PGSHIFT		# force page alignment
	.globl		bootstack
bootstack:
	.space		KSTKSIZE
	.globl		_bootstacktop   
_bootstacktop:

###################################################################
# setup the GDT	
###################################################################
.set CODE_SEL,0x8				# index of code seg within gdt
.set DATA_SEL,0x10				# index of data seg within gdt
.p2align	2				# force 4 byte alignment
gdt:
	SEG_NULL				# null seg
	SEG(STA_X|STA_R, ANSWER, 0xffffffff)	# code seg
	SEG(STA_W, ANSWER, 0xffffffff)	# data seg
gdtdesc:
	.word	0x17			# sizeof (gdt) - 1
	.long	LINK2LOAD(gdt)		# address gdt
	
###################################################################
# entry point
###################################################################
.text
.globl		start
start:
	movw	$0x1234,0x472			# warm boot
	lgdt	LINK2LOAD(gdtdesc)		# load descriptor
	movl	$DATA_SEL, %eax			# reload seg regs
	movw	%ax,%es				#
	movw	%ax,%ds				#
	movw	%ax,%ss				#
	ljmp	$CODE_SEL,$relocated		# reload CS
	
# Below relocated, segmentation maps address
# from the link address (down) to the load address. 	
relocated:
	movl	$0x0,%ebp			# And nuke frame pointer
	movl	$_bootstacktop,%esp		# set the stack pointer 
	
	/* Zero the BSS */
	xorl	%eax,%eax			# quickest way to get zero
	cld					# d=0 string op is ascending
	movl	$_edata,%edi			# destination of string op
	movl	$(3 + _end),%ecx		# repeat count for "rep"
	subl	$_edata,%ecx			#  = ceil ((_end-_edata)/4)
	shr	$2, %ecx
	rep
	 stosl					# store it!
	
	# now to C code
	call	_i386_init
