#ifndef _COMMON_H_
#define _COMMON_H_

	
//////////////////////////////////////////////////////////////////
//
// This is the Global Descriptor Table
//
//  An entry, a Segment Descriptor, looks like this:
//
// 31          24         19   16                 7           0
// ------------------------------------------------------------
// |             | |B| |A|       | |   |1|0|E|W|A|            |
// | BASE 31..24 |G|/|0|V| LIMIT |P|DPL|  TYPE   | BASE 23:16 |
// |             | |D| |L| 19..16| |   |1|1|C|R|A|            |
// ------------------------------------------------------------
// |                             |                            |
// |        BASE 15..0           |       LIMIT 15..0          |
// |                             |                            |
// ------------------------------------------------------------
//
//  Note the ordering of the data items is reversed from the above
//  description.
//
//////////////////////////////////////////////////////////////////
	
//	
// These macros format a segment according to the above format.
//	

#define SEG_NULL           \
	.word 0, 0;        \
	.byte 0, 0, 0, 0
#define SEG(type,base,lim)                                    \
	.word ((lim)&0xffff), ((base)&0xffff);                \
	.byte (((base)>>16)&0xff), (0x90|(type)),             \
		(0xc0|(((lim)>>16)&0xf)), (((base)>>24)&0xff)

#define STA_X 0x8              // Executable segment
#define STA_W 0x2              // Writeable (non-executable segments)
#define STA_R 0x2              // Readable (executable segments)

#define      KERNBASE        0xf0000000      /* start of kernel memory */
#define      PGSHIFT         12              /* LOG2(NBPG) */
#define      NBPG            (1 << PGSHIFT)  /* bytes/page */
#define      KSTKSIZE        (8 * NBPG)      /* size of a kernel stack */	


#endif /*_COMMON_H_ */
